<?php $__env->startSection('title'); ?>
    Create Tour
<?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
    <?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="breadcrumbs">
        <div class="breadcrumbs-inner">
            <div class="row m-0">
                <div class="col-sm-4">
                    <div class="page-header float-left">
                        <div class="page-title">
                            <h1>Tours</h1>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="page-header float-right">
                        <div class="page-title">
                            <ol class="breadcrumb text-right">
                                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                                <li><a href="<?php echo e(route('tour.index')); ?>">Tours</a></li>
                                <li class="active">Add Tour</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <strong>Tours</strong>
                        </div>
                        <div class="card-body card-block">
                            <form method="post" action="<?php echo e(route('tour.store')); ?>" enctype="multipart/form-data">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Tour Title <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="title" placeholder=""
                                        value="<?php echo e(old('title')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="tags">Tour Type</label>
                                    <select name="tags" data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value='<?php echo e($data->title); ?>'><?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="location_category_id" class="col-form-label">Location Category <span
                                            class="text-danger">*</span></label>
                                    <select name="location_category_id" class="form-control">
                                        <option value="">Select Location Category</option>
                                        <?php
                                            $location_categories = \App\Models\LocationCategory::where('status', 'active')->get();
                                        ?>
                                        <?php $__currentLoopData = $location_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>" <?php echo e(old('location_category_id') == $category->id ? 'selected' : ''); ?>>
                                                <?php echo e($category->title); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['location_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Tour Location <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="location" placeholder=""
                                        value="<?php echo e(old('location')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="map" class="col-form-label">Tour Map (Embeded Link)</label>
                                    <input class="form-control" id="map" name="map" value="<?php echo e(old('map')); ?>" type="url">
                                    <?php $__errorArgs = ['map'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Age Limit <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="age" placeholder=""
                                        value="<?php echo e(old('age')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputPhoto" class="col-form-label">Upload Tour image ( Size: 852px x 489px)
                                        <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        
                                        <input class="form-control" type="file" name="photo" required>
                                    </div>
                                    <div id="holder" style="margin-top:15px;max-height:100px;"></div>
                                    <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="description" class="col-form-label">Tour Description</label>
                                    <textarea class="form-control ckeditor" id="description" name="description" required><?php echo e(old('description')); ?></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="number_of_days" class="col-form-label">Number of Days <span
                                            class="text-danger">*</span></label>
                                    <input id="number_of_days" type="text" name="number_of_days" placeholder=""
                                        value="<?php echo e(old('number_of_days')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['number_of_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div id="itinerary-container">
                                    <fieldset>
                                        <legend for="fiels-1" class="w-100 d-flex justify-content-between align-items-center">
                                            <span class="text-muted">Itinerary Section</span>
                                            <button type="button" class="btn btn-sm btn-danger itinery-rem-button"  onclick="removeItItem(this)" style="border-radius: 50%; width: 30px; height: 30px">X</button>
                                        </legend>
                                        <div class="form-group itinerary-item">
                                            <label for="itinerary_title_1" class="col-form-label">Itinerary Title <span
                                                    class="text-danger">*</span></label>
                                            <input id="itinerary_title_1" type="text" name="itinerary_titles[]"
                                                class="form-control" required>

                                            <label for="itinerary_description_1" class="col-form-label">Description <span
                                                    class="text-danger">*</span></label>
                                            <textarea id="itinerary_description_1" name="itinerary_descriptions[]" class="form-control ckeditor" required></textarea>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="form-group">
                                    <button type="button" style="border-radius: 15px" id="add-itinerary" class="btn btn-info btn-sm">Add Itinerary</button>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Price Per Person <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="price" placeholder=""
                                        value="<?php echo e(old('price')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Price Per Child <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="price_per_child" placeholder=""
                                        value="<?php echo e(old('price_per_child')); ?>" class="form-control" >
                                    <?php $__errorArgs = ['price_per_child'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Discount <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="number" name="discount" placeholder=""
                                        value="<?php echo e(old('discount')); ?>" class="form-control" >
                                    <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="includes">Includes</label>
                                    <select name="includes[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $includes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value='<?php echo e($data->title); ?>'><?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="excludes">Excludes</label>
                                    <select name="excludes[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $excludes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value='<?php echo e($data->title); ?>'><?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="images" class="col-form-label">Upload Multiple Images (Size: 1024px x 576px | Max: 12 photos)</label>
                                    <div class="input-group">
                                        <input class="form-control" type="file" name="images[]" multiple>
                                    </div>
                                    <?php $__errorArgs = ['images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="status" class="col-form-label"><?php echo e(__('sidebar.post_status')); ?> <span
                                            class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option value="active">Active</option>
                                        <option value="featured">Featured</option>
                                        <option value="inactive">Inactive</option>
                                    </select>
                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Availability Section -->
                                <fieldset style="border: 1px solid #ddd; padding: 15px; margin-bottom: 20px; border-radius: 5px;">
                                    <legend style="font-size: 16px; font-weight: bold; color: #333; padding: 0 10px;">Tour Availability</legend>
                                    
                                    <div class="form-group">
                                        <label for="availability_type" class="col-form-label">Availability Type <span class="text-danger">*</span></label>
                                        <select name="availability_type" id="availability_type" class="form-control" onchange="toggleAvailabilityFields()">
                                            <option value="year_round" <?php echo e(old('availability_type') == 'year_round' ? 'selected' : ''); ?>>Available Year Round</option>
                                            <option value="seasonal" <?php echo e(old('availability_type') == 'seasonal' ? 'selected' : ''); ?>>Seasonal Availability</option>
                                            <option value="custom" <?php echo e(old('availability_type') == 'custom' ? 'selected' : ''); ?>>Custom Availability</option>
                                        </select>
                                        <?php $__errorArgs = ['availability_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div id="unavailable-periods-section" style="display: none;">
                                        <div class="form-group">
                                            <label class="col-form-label">Unavailable Periods</label>
                                            <div id="unavailable-periods-container">
                                                <div class="unavailable-period-item" style="border: 1px solid #eee; padding: 10px; margin-bottom: 10px; border-radius: 3px;">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <label>Start Date</label>
                                                            <input type="date" name="unavailable_periods[0][start_date]" class="form-control">
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label>End Date</label>
                                                            <input type="date" name="unavailable_periods[0][end_date]" class="form-control">
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label>Reason (Optional)</label>
                                                            <input type="text" name="unavailable_periods[0][reason]" class="form-control" placeholder="e.g., Heavy rains">
                                                        </div>
                                                        <div class="col-md-1">
                                                            <label>&nbsp;</label>
                                                            <button type="button" class="btn btn-danger btn-sm form-control" onclick="removePeriod(this)">×</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <button type="button" id="add-period" class="btn btn-info btn-sm">Add Another Period</button>
                                        </div>
                                    </div>

                                   
                                </fieldset>
                                <div class="form-group mb-3 text-right">
                                    <button type="reset"
                                        class="btn btn-warning"><?php echo e(__('sidebar.post_reset')); ?></button>
                                    <button class="btn btn-success"
                                        type="submit"><?php echo e(__('sidebar.post_submit')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $ = jQuery;

        function removeItItem(e) {
            if(confirm('Are you sure yo want to remove this section?')){
                e.parentNode.parentNode.remove();
            }
        }

        $(document).ready(function() {
            // $('.ckeditor').ckeditor();

            let itineraryCount = 1;

            $('#add-itinerary').on('click tap', function() {
                itineraryCount++;

                let itineraryItem = `
                <legend for="fiels-1" class="w-100 d-flex justify-content-between align-items-center">
                    <span class="text-muted">Itinerary Section</span>
                    <button type="button" class="btn btn-sm btn-danger itinery-rem-button" onclick="removeItItem(this)" style="border-radius: 50%; width: 30px; height: 30px">X</button>
                </legend>
                <div class="form-group itinerary-item">
                    <label for="itinerary_title_${itineraryCount}" class="col-form-label">Itinerary Title <span class="text-danger">*</span></label>
                    <input id="itinerary_title_${itineraryCount}" type="text" name="itinerary_titles[]" class="form-control" required>
                    
                    <label for="itinerary_description_${itineraryCount}" class="col-form-label">Description <span class="text-danger">*</span></label>
                    <textarea id="itinerary_description_${itineraryCount}" name="itinerary_descriptions[]" class="form-control" required></textarea>
                </div>`;

                let newSec = document.createElement('fieldset');
                newSec.id = `new-${itineraryCount}-sec`;
                document.getElementById('itinerary-container').appendChild(newSec);

                setTimeout(() => {
                    $(`#new-${itineraryCount}-sec`).html(`${itineraryItem}`);

                    setTimeout(() => {
                        CKEDITOR.replace(document.getElementById(`itinerary_description_${itineraryCount}`));
                        setTimeout(() => {
                            jQuery('.cke_notifications_area').remove()
                        }, 1000);
                    }, 100);
                }, 100);
            });

        setTimeout(() => {
            jQuery('.cke_notifications_area').remove()
        }, 1000);
    });

    // Availability functionality
    function toggleAvailabilityFields() {
        const availabilityType = document.getElementById('availability_type').value;
        const periodsSection = document.getElementById('unavailable-periods-section');
        
        if (availabilityType === 'seasonal' || availabilityType === 'custom') {
            periodsSection.style.display = 'block';
        } else {
            periodsSection.style.display = 'none';
        }
    }

    function removePeriod(button) {
        if (document.querySelectorAll('.unavailable-period-item').length > 1) {
            button.closest('.unavailable-period-item').remove();
            updatePeriodIndices();
        }
    }

    function updatePeriodIndices() {
        const periods = document.querySelectorAll('.unavailable-period-item');
        periods.forEach((period, index) => {
            const inputs = period.querySelectorAll('input');
            inputs[0].name = `unavailable_periods[${index}][start_date]`;
            inputs[1].name = `unavailable_periods[${index}][end_date]`;
            inputs[2].name = `unavailable_periods[${index}][reason]`;
        });
    }

    // Add period functionality
    document.getElementById('add-period').addEventListener('click', function() {
        const container = document.getElementById('unavailable-periods-container');
        const currentCount = container.children.length;
        
        const newPeriod = `
            <div class="unavailable-period-item" style="border: 1px solid #eee; padding: 10px; margin-bottom: 10px; border-radius: 3px;">
                <div class="row">
                    <div class="col-md-4">
                        <label>Start Date</label>
                        <input type="date" name="unavailable_periods[${currentCount}][start_date]" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <label>End Date</label>
                        <input type="date" name="unavailable_periods[${currentCount}][end_date]" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label>Reason (Optional)</label>
                        <input type="text" name="unavailable_periods[${currentCount}][reason]" class="form-control" placeholder="e.g., Heavy rains">
                    </div>
                    <div class="col-md-1">
                        <label>&nbsp;</label>
                        <button type="button" class="btn btn-danger btn-sm form-control" onclick="removePeriod(this)">×</button>
                    </div>
                </div>
            </div>
        `;
        
        container.insertAdjacentHTML('beforeend', newPeriod);
    });

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        toggleAvailabilityFields();
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/defenders/public_html/0255_projects/tembea/resources/views/backend/tour/create.blade.php ENDPATH**/ ?>