
<?php $__env->startSection('title'); ?> Location Categories <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Location Categories</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                <li><a href="<?php echo e(route('location-category.create')); ?>">Add Location Category</a></li>
                <li class="active">Location Categories</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Location Categories</strong>
                  </div>
                  <div class="card-body">
                    <?php if(count($location_categories)>0): ?>
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th>S.N.</th>
                                <th>Title</th>
                                <th>Slug</th>
                                <th>Photo</th>
                                <th>Status</th>
                                <th>Action</th>
                              </tr>
                          </thead>
                          <tbody>
                            <?php $__currentLoopData = $location_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                              <tr>
                                  <td><?php echo e($data->id); ?></td>
                                  <td><?php echo e($data->title); ?></td>
                                  <td><?php echo e($data->slug); ?></td>
                                  <td>
                                    <?php if($data->photo): ?>
                                        <img src="<?php echo e(Storage::url($data->photo)); ?>" class="img-fluid zoom" style="max-width:80px" alt="<?php echo e($data->photo); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('backend/img/thumbnail-default.jpg')); ?>" class="img-fluid zoom" style="max-width:100%" alt="avatar.png">
                                    <?php endif; ?>
                                  </td>
                                  <td>
                                      <?php if($data->status=='active'): ?>
                                          <span class="badge badge-success"><?php echo e($data->status); ?></span>
                                      <?php else: ?>
                                          <span class="badge badge-warning"><?php echo e($data->status); ?></span>
                                      <?php endif; ?>
                                  </td>
                                  <td>
                                      <a href="<?php echo e(route('location-category.edit',$data->id)); ?>" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fa fa-edit"></i></a>
                                      <form method="POST" action="<?php echo e(route('location-category.destroy',[$data->id])); ?>">
                                        <?php echo csrf_field(); ?> 
                                        <?php echo method_field('delete'); ?>
                                            <button class="btn btn-danger btn-sm dltBtn" data-id=<?php echo e($data->id); ?> style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                        </form>
                                  </td>
                                  
                              </tr>  
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                      </table>
                      <span style="float:right"><?php echo e($location_categories->links()); ?></span>
                      <?php else: ?>
                        <h6 class="text-center">No Location Categories found!!! Please create Location Category</h6>
                      <?php endif; ?>
                  </div>
              </div>
          </div>

      </div>
  </div><!-- .animated -->
</div><!-- .content -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/lib/datatable/dataTables.bootstrap.min.css')); ?>">
  <link href="<?php echo e(asset('backend/assets/css/lib/datatable/buttons.bootstrap.min.css')); ?>" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/lib/datatable/fixedHeader.dataTables.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/lib/datatable/scroller.dataTables.min.css')); ?>">
  <style>
      div.dataTables_wrapper div.dataTables_paginate{
          display: none;
      }
      .zoom {
        transition: transform .2s; /* Animation */
      }

      .zoom:hover {
        transform: scale(3.2);
      }
  </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>

  <!-- data table JS
		============================================ -->
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/datatables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/dataTables.bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/buttons.bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/buttons.colVis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/lib/datatable/datatables-init.js')); ?>"></script>


    <script>
        $(document).ready(function(){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $('.dltBtn').click(function(e){
                var form=$(this).closest('form');
                  var dataID=$(this).data('id');
                  // alert(dataID);
                  e.preventDefault();
                  swal({
                        title: "Are you sure?",
                        text: "Once deleted, you will not be able to recover this data!",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                           form.submit();
                        } else {
                            swal("Your data is safe!");
                        }
                    });
            })
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Ufanisi_projects\tembea\resources\views/backend/location-category/index.blade.php ENDPATH**/ ?>