<?php $__env->startSection('title'); ?> Bookings <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Bookings</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                <li class="active">Bookings</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Bookings</strong>
                  </div>
                  <div class="card-body">
                    <?php if(count($orders)>0): ?>
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th>S.N.</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Country</th>
                                <th>Tour</th>
                                <th>Date Created</th>
                                <th>Action</th>
                              </tr>
                          </thead>
                          <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                              <?php 
                                $tour=DB::table('tours')->select('title')->where('id',$order->tour_id)->get();
                              ?>
                              <tr>
                                <td><?php echo e($order->id); ?></td>
                                <td><?php echo e($order->first_name); ?> - <?php echo e($order->last_name); ?></td>
                                <td><?php echo e($order->email); ?></td>
                                <td><?php echo e($order->country); ?></td>
                                <td>
                                  <?php $__currentLoopData = $tour; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($order->tour->title ?? ''); ?>

                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo e($order->created_at->format('F d, Y h:i A')); ?></td>
                                <td>
                                <a href="<?php echo e(route('order.show',$order->id)); ?>" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="view" data-placement="bottom"><i class="fa fa-eye"></i></a>
                                <button class="btn btn-danger btn-sm dltBtn" data-toggle="modal" data-target="#modal-delete<?php echo e($order->id); ?>" data-id=<?php echo e($order->id); ?> style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                <div class="modal fade"  id="modal-delete<?php echo e($order->id); ?>" tabindex="-1" aria-labelledby="modal-new-address" aria-hidden="true">
                                    <div class="modal-dialog  modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h6 class="modal-title" id="staticBackdropLabel">
                                                </h6>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                  <span aria-hidden="true">×</span>
                                                </button>
                                                
                                            </div>
                                            <div class="modal-body">
                                                <form action="<?php echo e(route('order.destroy',$order->id)); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                <div class="row gy-3">
                                                    <div class="col-xl-6">
                                                        <H2>Are you Sure ?</H2>
                                                        <p>You won't be able to revert this!</p> 
                                                    </div>                                       
                                                </div>
                                            
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-danger">Yes, Delete It</button>
                                            </div>
                                        </form>
                                        
                                        </div>
                                    </div>
                                </div>
                                </td>
                              </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                      </table>
                      <?php else: ?>
                      <h6 class="text-center">No bookings found!!! Please book some </h6>
                    <?php endif; ?>
                  </div>
              </div>
          </div>


      </div>
  </div><!-- .animated -->
</div><!-- .content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/defenders/public_html/0255_projects/tembea/resources/views/backend/order/index.blade.php ENDPATH**/ ?>