<?php $__env->startSection('title'); ?> Edit Post <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumbs">
  <div class="breadcrumbs-inner">
      <div class="row m-0">
          <div class="col-sm-4">
              <div class="page-header float-left">
                  <div class="page-title">
                      <h1>Edit Articles</h1>
                  </div>
              </div>
          </div>
          <div class="col-sm-8">
              <div class="page-header float-right">
                  <div class="page-title">
                      <ol class="breadcrumb text-right">
                          <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                          <li><a href="<?php echo e(route('post.index')); ?>">Articles</a></li>
                          <li class="active">Edit Articles</li>
                      </ol>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>

<div class="content">
  <div class="animated fadeIn">
    <div class="row">
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
              <strong>Edit Articles</strong>
          </div>
          <div class="card-body card-block">
            <form method="post" action="<?php echo e(route('post.update',$post->id)); ?>" enctype="multipart/form-data">
              <?php echo csrf_field(); ?> 
              <?php echo method_field('PATCH'); ?>
              <div class="form-group">
                <label for="inputTitle" class="col-form-label">Article Title <span class="text-danger">*</span></label>
                <input id="inputTitle" type="text" name="title" placeholder=""  value="<?php echo e($post->title); ?>" class="form-control" required>
                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="text-danger"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>
              <div class="form-group">
                <label for="inputTitle" class="col-form-label">Article Quote <span class="text-danger">*</span></label>
                <input id="inputTitle" type="text" name="quote" placeholder=""  value="<?php echo e($post->quote); ?>" class="form-control" required>
                <?php $__errorArgs = ['quote'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="text-danger"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              
              <?php 
                      $post_tags=explode(',',$post->tags);
                      // dd($tags);
                    ?>
              <div class="form-group">
                <label for="tags">Article Tag</label>
                <select name="tags[]" multiple  data-live-search="true" class="form-control selectpicker" required>
                    <option value="">----</option>
                    <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                    <option value="<?php echo e($data->title); ?>"  <?php echo e((( in_array( "$data->title",$post_tags ) ) ? 'selected' : '')); ?>><?php echo e($data->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="form-group">
                <label for="inputPhoto" class="col-form-label">Upload article image <span class="text-danger">*</span></label>
                <div class="input-group">
                    
                <input class="form-control" type="file" name="photo" value="<?php echo e($post->photo); ?>">
              </div>
              <div id="holder" style="margin-top:15px;max-height:100px;"></div>

                <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="text-danger"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="form-group">
                <img src="<?php echo e(Storage::url($post->photo)); ?>" height="75" width="75" alt="" />
              </div>

              <div class="form-group">
                <label for="description" class="col-form-label">Article Description</label>
                <textarea class="form-control ckeditor" id="description" name="description"  required><?php echo e($post->description); ?></textarea>
                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="text-danger"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>
              
              <div class="form-group">
                <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
                <select name="status" class="form-control">
                  <option value="active" <?php echo e((($post->status=='active')? 'selected' : '')); ?>>Active</option>
                  <option value="inactive" <?php echo e((($post->status=='inactive')? 'selected' : '')); ?>>Inactive</option>
              </select>
                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="text-danger"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>
              <div class="form-group mb-3">
                <button class="btn btn-success" type="submit">Update</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
  
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
    });
</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rlmt0yhldtmh/public_html/0256/zawadi/resources/views/backend/post/edit.blade.php ENDPATH**/ ?>