<?php $__env->startSection('title'); ?> Tours <?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .tour-availability {
        margin-bottom: 10px;
    }
    
    .availability-badge, .availability-status {
        display: inline-block;
        padding: 4px 8px;
        font-size: 12px;
        border-radius: 15px;
        margin-right: 5px;
        margin-bottom: 5px;
    }
    
    .availability-badge.available {
        background-color: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }
    
    .availability-badge.seasonal {
        background-color: #fff3cd;
        color: #856404;
        border: 1px solid #ffeaa7;
    }
    
    .availability-badge.custom {
        background-color: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }
    
    .availability-status.available-dates {
        background-color: #d1ecf1;
        color: #0c5460;
        border: 1px solid #bee5eb;
    }
    
    .availability-badge i, .availability-status i {
        margin-right: 3px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main-content'); ?>

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" <?php if(isset($tourtag->banner) && $tourtag->banner): ?> data-background="<?php echo e(Storage::url($tourtag->banner)); ?>" <?php else: ?> data-background="<?php echo e(asset('frontend/assets/images/tours_page.jpg')); ?>" <?php endif; ?>></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title"><?php echo e($tourtag->title??'Tours'); ?> Tours</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="<?php echo e(route('home')); ?>"><i class="icon-home"></i>Home</a></span>
                                    <span><?php echo e($tourtag->title??'Tours'); ?> Tours</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- tour-grid area start -->
    <section class="bd-tour-grid-area section-space">
        <div class="container">
            <?php if(isset($search_context['has_date_filter']) && $search_context['has_date_filter']): ?>
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="search-results-info bg-light p-3 rounded">
                            <h6 class="mb-2">
                                <i class="fa-regular fa-filter"></i> Search Results
                            </h6>
                            <p class="mb-0">
                                Showing tours available from 
                                <strong><?php echo e(\Carbon\Carbon::parse($search_context['start_date'])->format('M d, Y')); ?></strong>
                                to 
                                <strong><?php echo e(\Carbon\Carbon::parse($search_context['end_date'])->format('M d, Y')); ?></strong>
                            </p>
                            <small class="text-muted">
                                Found <?php echo e(is_countable($tours) ? count($tours) : $tours->count()); ?> available tour(s) for your selected dates
                            </small>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="row gy-24">
                <?php if($tours): ?>
                    <?php $__currentLoopData = $tours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6">
                            <div class="tour-wrapper style-one">
                                <div class="p-relative">
                                    <div class="tour-thumb image-overly">
                                        <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>">
                                            <?php
                                                $photo=explode(',',$tour->photo);
                                            ?>
                                        <img src="<?php echo e(Storage::url($tour->photo)); ?>" class="img-responsive"  alt="<?php echo e(Storage::url($tour->photo)); ?>" />
                                        </a>
                                    </div>
                                    <div class="tour-meta d-flex align-items-center justify-content-between">
                                        <div class="tour-location">
                                            <span>
                                                <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>">
                                                    <i class="fa-regular fa-location-dot"></i> <?php echo e($tour->location); ?>

                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="tour-content">
                                    <h5 class="tour-title fw-5 underline mb-5">
                                        <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>">
                                            <?php echo e($tour->title); ?>

                                        </a>
                                    </h5>
                                    <span class="tour-price b3">$<?php echo e($tour->price); ?> per Person</span><br>
                                    <span class="tour-price b3">$<?php echo e($tour->price_per_child); ?> per Child</span>
                                    <div class="tour-divider"></div>
                                    <p><?php echo e($tour->tags); ?> </p>
                                    <div class="tour-divider"></div>
                                    
                                    <!-- Availability Information -->
                                    <div class="tour-availability mb-2">
                                        <?php if($tour->availability_type === 'year_round'): ?>
                                            <span class="availability-badge available">
                                                <i class="fa-regular fa-calendar-check"></i> Available Year Round
                                            </span>
                                        <?php elseif($tour->availability_type === 'seasonal'): ?>
                                            <span class="availability-badge seasonal">
                                                <i class="fa-regular fa-calendar-clock"></i> Seasonal Availability
                                            </span>
                                        <?php elseif($tour->availability_type === 'custom'): ?>
                                            <span class="availability-badge custom">
                                                <i class="fa-regular fa-calendar-days"></i> Limited Availability
                                            </span>
                                        <?php endif; ?>
                                        
                                        <?php if(isset($search_context['has_date_filter']) && $search_context['has_date_filter']): ?>
                                            <?php if($tour->isAvailableForDateRange($search_context['start_date'], $search_context['end_date'])): ?>
                                                <span class="availability-status available-dates">
                                                    <i class="fa-regular fa-circle-check"></i> Available for selected dates
                                                </span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>

                                    <div class="tour-meta d-flex align-items-center justify-content-between">
                                        <div class="time d-flex align-items-center gap--5">
                                            
                                            <span><?php echo e($tour->number_of_days); ?> days</span>
                                        </div>
                                        <div class="tour-btn">
                                            <a class="bd-text-btn style-two" href="<?php echo e(route('book')); ?>">Book Now
                                                <span class="icon__box">
                                                    <i class="fa-regular fa-arrow-right-long icon__first"></i>
                                                    <i class="fa-regular fa-arrow-right-long icon__second"></i>
                                                </span>
                                            </a>                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- tour-grid area end -->

</main>
<!-- Body main wrapper end -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/defenders/public_html/0255_projects/tembea/resources/views/frontend/pages/tour.blade.php ENDPATH**/ ?>