<?php $__env->startSection('title'); ?> Tours <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Tours</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                <li><a href="<?php echo e(route('tour.create')); ?>">Add Tour</a></li>
                <li class="active">Tours</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Tour</strong>
                  </div>
                  <div class="card-body">
                    <?php if(count($tours)>0): ?>
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th><?php echo e(__('sidebar.post_snumber')); ?></th>
                                <th><?php echo e(__('sidebar.post_title')); ?></th>
                                <th>Location</th>
                                <th>Number of Days</th>
                                <th>Price Per Person</th>
                                <th>Price Per Child</th>
                                <th>Tour Category</th>
                                <th><?php echo e(__('sidebar.post_photo')); ?></th>
                                <th><?php echo e(__('sidebar.post_status')); ?></th>
                                <th><?php echo e(__('sidebar.post_action')); ?></th>
                              </tr>
                          </thead>
                          <tbody>
                            <?php $__currentLoopData = $tours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                              <?php 
                              $author_info=DB::table('users')->select('name')->where('id',$tour->added_by)->get();
                              ?>
                              <tr>
                                <td><?php echo e($tour->id); ?></td>
                                <td><?php echo e($tour->title); ?></td>
                                <td><?php echo e($tour->location); ?></td>
                                <td><?php echo e($tour->number_of_days); ?></td>
                                <td><?php echo e($tour->price); ?></td>
                                <td><?php echo e($tour->price_per_child); ?></td>
                                <td><?php echo e($tour->tags); ?></td>
                                
                                <td>
                                    <?php if($tour->photo): ?>
                                        <img src="<?php echo e(Storage::url($tour->photo)); ?>" class="img-fluid zoom" style="max-width:80px" alt="<?php echo e(Storage::url($tour->photo)); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('backend/img/thumbnail-default.jpg')); ?>" class="img-fluid" style="max-width:80px" alt="avatar.png">
                                    <?php endif; ?>
                                </td>                   
                                <td>
                                    <?php if($tour->status=='active'): ?>
                                        <span class="badge badge-success"><?php echo e($tour->status); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-warning"><?php echo e($tour->status); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('tour.edit',$tour->id)); ?>" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fa fa-edit"></i></a>
                                    <button class="btn btn-danger btn-sm dltBtn" data-toggle="modal" data-target="#modal-delete<?php echo e($tour->id); ?>" data-id=<?php echo e($tour->id); ?> style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                    <div class="modal fade"  id="modal-delete<?php echo e($tour->id); ?>" tabindex="-1" aria-labelledby="modal-new-address" aria-hidden="true">
                                        <div class="modal-dialog  modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h6 class="modal-title" id="staticBackdropLabel">
                                                    </h6>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                      <span aria-hidden="true">×</span>
                                                    </button>
                                                    
                                                </div>
                                                <div class="modal-body">
                                                    <form action="<?php echo e(route('tour.destroy',$tour->id)); ?>" method="post">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                    <div class="row gy-3">
                                                        <div class="col-xl-6">
                                                            <H2>Are you Sure ?</H2>
                                                            <p>You won't be able to revert this!</p> 
                                                        </div>                                       
                                                    </div>
                                                
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger">Yes, Delete It</button>
                                                </div>
                                            </form>
                                            
                                            </div>
                                        </div>
                                    </div>
                                </td>
                              </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                      </table>
                      <?php else: ?>
                      <h6 class="text-center">No tours found!!! Please add tour</h6>
                    <?php endif; ?>
                  </div>
              </div>
          </div>

      </div>
  </div><!-- .animated -->
</div><!-- .content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rlmt0yhldtmh/public_html/0256/zawadi/resources/views/backend/tour/index.blade.php ENDPATH**/ ?>