<?php $__env->startSection('title','All Documents'); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Documents</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                <li><a href="<?php echo e(route('document.create')); ?>">Add Document</a></li>
                <li class="active">Documents</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Documents</strong>
                  </div>
                  <div class="card-body">
                    <?php if(count($documents)>0): ?>
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th>S.N.</th>
                                <th>Title</th>
                                <th>Photo</th>
                                <th>File</th>
                                <th>Status</th>
                                <th>Action</th>
                              </tr>
                          </thead>
                          <tbody>
                            <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <tr>
                                <td><?php echo e($document->id); ?></td>
                                <td><?php echo e($document->title); ?></td>
                                <td>
                                  <?php if($document->photo): ?>
                                      <img src="<?php echo e(Storage::url($document->photo)); ?>" class="img-fluid zoom" style="max-width:80px" alt="<?php echo e(Storage::url($document->photo)); ?>">
                                  <?php else: ?>
                                      <img src="<?php echo e(asset('backend/img/thumbnail-default.jpg')); ?>" class="img-fluid zoom" style="max-width:100%" alt="avatar.png">
                                  <?php endif; ?>
                                </td>
                                <td>
                                  <?php if($document->file): ?>
                                    <a href="<?php echo e(Storage::url($document->file)); ?>" target="_blank">Download File</a>
                                    <?php else: ?>
                                    No File
                                  <?php endif; ?>
                                </td>
                                <td>
                                  <?php if($document->status=='active'): ?>
                                      <span class="badge badge-success"><?php echo e($document->status); ?></span>
                                  <?php else: ?>
                                      <span class="badge badge-warning"><?php echo e($document->status); ?></span>
                                  <?php endif; ?>
                                </td>
                                <td>
                                  <a href="<?php echo e(route('document.edit',$document->id)); ?>" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fa fa-edit"></i></a>
                                  <button class="btn btn-danger btn-sm dltBtn" data-toggle="modal" data-target="#modal-delete<?php echo e($document->id); ?>" data-id=<?php echo e($document->id); ?> style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                  <div class="modal fade"  id="modal-delete<?php echo e($document->id); ?>" tabindex="-1" aria-labelledby="modal-new-address" aria-hidden="true">
                                      <div class="modal-dialog  modal-dialog-centered">
                                          <div class="modal-content">
                                              <div class="modal-header">
                                                  <h6 class="modal-title" id="staticBackdropLabel">
                                                  </h6>
                                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">×</span>
                                                  </button>
                                                  
                                              </div>
                                              <div class="modal-body">
                                                  <form action="<?php echo e(route('document.destroy',$document->id)); ?>" method="post">
                                                      <?php echo csrf_field(); ?>
                                                      <?php echo method_field('DELETE'); ?>
                                                  <div class="row gy-3">
                                                      <div class="col-xl-6">
                                                          <H2>Are you Sure ?</H2>
                                                          <p>You won't be able to revert this!</p> 
                                                      </div>                                       
                                                  </div>
                                              
                                              </div>
                                              <div class="modal-footer">
                                                  <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                                                  <button type="submit" class="btn btn-danger">Yes, Delete It</button>
                                              </div>
                                          </form>
                                          
                                          </div>
                                      </div>
                                  </div>
                                </td>
                              </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                      </table>
                      <?php else: ?>
                      <h6 class="text-center">No documents found!!! Please add document</h6>
                    <?php endif; ?>
                  </div>
              </div>
          </div>


      </div>
  </div><!-- .animated -->
</div><!-- .content -->
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/defenders/public_html/0255_projects/tembea/resources/views/backend/document/index.blade.php ENDPATH**/ ?>