<?php $__env->startSection('title','Admin Profile'); ?>
<?php $__env->startSection('main-content'); ?>

<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                <?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="card-header py-3">
                <h4 class=" font-weight-bold">Profile</h4>
            </div>
            <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card">
                                <div class="image">
                                    <?php if($profile->photo): ?>
                                    <img class="card-img-top img-fluid roundend-circle mt-4" style="border-radius:50%;height:80px;width:80px;margin:auto;" src="<?php echo e(Storage::url($profile->photo)); ?>" alt="<?php echo e(Storage::url($profile->photo)); ?>">
                                    <?php else: ?> 
                                    <img class="card-img-top img-fluid roundend-circle mt-4" style="border-radius:50%;height:80px;width:80px;margin:auto;" src="<?php echo e(asset('backend/images/avatar/1.png')); ?>" alt="profile picture">
                                    <?php endif; ?>
                                </div>
                                <div class="card-body mt-4 ml-2">
                                <h5 class="card-title text-left"><small><i class="fas fa-user"></i> <?php echo e($profile->name); ?></small></h5>
                                <p class="card-text text-left"><small><i class="fas fa-envelope"></i> <?php echo e($profile->email); ?></small></p>
                                <p class="card-text text-left"><small class="text-muted"><i class="fas fa-hammer"></i> <?php echo e($profile->role); ?></small></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <form class="border px-4 pt-2 pb-3" method="POST" action="<?php echo e(route('profile-update',$profile->id)); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Name</label>
                                <input id="inputTitle" type="text" name="name" placeholder=""  value="<?php echo e($profile->name); ?>" class="form-control">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                        
                                <div class="form-group">
                                    <label for="inputEmail" class="col-form-label">Email</label>
                                    <input id="inputEmail" disabled type="email" name="email" placeholder=""  value="<?php echo e($profile->email); ?>" class="form-control">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                        
                                <div class="form-group">
                                <label for="inputPhoto" class="col-form-label">Photo</label>
                                <div class="input-group">
                                    
                                    <input class="form-control" type="file" name="photo" value="<?php echo e($profile->photo); ?>">
                                </div>
                                    <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group">
                                    <label for="role" class="col-form-label">Role</label>
                                    <select name="role" class="form-control">
                                        <option value="">-----Select Role-----</option>
                                            <option value="admin" <?php echo e((($profile->role=='admin')? 'selected' : '')); ?>>Admin</option>
                                            <option value="user" <?php echo e((($profile->role=='user')? 'selected' : '')); ?>>User</option>
                                    </select>
                                    <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <button type="submit" class="btn btn-success btn-sm">Update</button>
                            </form>
                        </div>
                    </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<style>
    .breadcrumbs{
        list-style: none;
    }
    .breadcrumbs li{
        float:left;
        margin-right:10px;
    }
    .breadcrumbs li a:hover{
        text-decoration: none;
    }
    .breadcrumbs li .active{
        color:red;
    }
    .breadcrumbs li+li:before{
      content:"/\00a0";
    }
    .image{
        background:url('<?php echo e(asset('backend/img/background.jpg')); ?>');
        height:150px;
        background-position:center;
        background-attachment:cover;
        position: relative;
    }
    .image img{
        position: absolute;
        top:55%;
        left:35%;
        margin-top:30%;
    }
    i{
        font-size: 14px;
        padding-right:8px;
    }
  </style> 

<?php $__env->startPush('scripts'); ?>
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script>
    $('#lfm').filemanager('image');
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/defenders/public_html/0255_projects/tembea/resources/views/backend/users/profile.blade.php ENDPATH**/ ?>