<?php $__env->startSection('title'); ?> Tanzania Mainland <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" data-background="<?php echo e(asset('frontend/assets/images/tours_page.jpg')); ?>"></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">Tanzania Mainland</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="<?php echo e(route('home')); ?>"><i class="icon-home"></i>Home</a></span>
                                    <span>Tanzania Mainland</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- tour-grid area start -->
    <section class="bd-tour-grid-area section-space">
        <div class="container">
            <div class="row gy-24">
                <?php if($tours): ?>
                    <?php $__currentLoopData = $tours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6">
                            <div class="tour-wrapper style-one">
                                <div class="p-relative">
                                    <div class="tour-thumb image-overly">
                                        <a href="<?php echo e(route('tanzania.detail',$tour->slug)); ?>">
                                            <?php
                                                $photo=explode(',',$tour->photo);
                                            ?>
                                        <img src="<?php echo e(Storage::url($tour->photo)); ?>" class="img-responsive"  alt="<?php echo e(Storage::url($tour->photo)); ?>" />
                                        </a>
                                    </div>
                                    <div class="tour-meta d-flex align-items-center justify-content-between">
                                        <div class="tour-location">
                                            <span>
                                                <a href="<?php echo e(route('tanzania.detail',$tour->slug)); ?>">
                                                    <i class="fa-regular fa-location-dot"></i> <?php echo e($tour->location); ?>

                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="tour-content">
                                    <h5 class="tour-title fw-5 underline mb-5">
                                        <a href="<?php echo e(route('tanzania.detail',$tour->slug)); ?>">
                                            <?php echo e($tour->title); ?>

                                        </a>
                                    </h5>
                                    <span class="tour-price b3">$<?php echo e($tour->price); ?> per Person</span><br>
                                    <span class="tour-price b3">$<?php echo e($tour->price_per_child); ?> per Child</span>
                                    <div class="tour-divider"></div>
                                    <p><?php echo e($tour->tags); ?> </p>
                                    <div class="tour-divider"></div>

                                    <div class="tour-meta d-flex align-items-center justify-content-between">
                                        <div class="time d-flex align-items-center gap--5">
                                            
                                            <span><?php echo e($tour->number_of_days); ?> days</span>
                                        </div>
                                        <div class="tour-btn">
                                            <a class="bd-text-btn style-two" href="<?php echo e(route('book')); ?>">Book Now
                                                <span class="icon__box">
                                                    <i class="fa-regular fa-arrow-right-long icon__first"></i>
                                                    <i class="fa-regular fa-arrow-right-long icon__second"></i>
                                                </span>
                                            </a>                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- tour-grid area end -->

</main>
<!-- Body main wrapper end -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rlmt0yhldtmh/public_html/0256/zawadi/resources/views/frontend/pages/tanzania.blade.php ENDPATH**/ ?>