<?php $__env->startSection('title'); ?>
    Edit Tour
<?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
    <?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="breadcrumbs">
        <div class="breadcrumbs-inner">
            <div class="row m-0">
                <div class="col-sm-4">
                    <div class="page-header float-left">
                        <div class="page-title">
                            <h1>Edit Tour</h1>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="page-header float-right">
                        <div class="page-title">
                            <ol class="breadcrumb text-right">
                                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                                <li><a href="<?php echo e(route('tour.index')); ?>">Tours</a></li>
                                <li class="active">Edit Tour</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <strong>Edit Tour</strong>
                        </div>
                        <div class="card-body card-block">
                            <form method="post" action="<?php echo e(route('tour.update', $tour->id)); ?>"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>
                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Tour Title <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="title" placeholder=""
                                        value="<?php echo e($tour->title); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <?php
                                    $tour_tags = explode(',', $tour->tags);
                                ?>
                                <div class="form-group">
                                    <label for="tags">Tour Category</label>
                                    <select name="tags[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->title); ?>"
                                                <?php echo e(in_array("$data->title", $tour_tags) ? 'selected' : ''); ?>>
                                                <?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Tour Location <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="location" placeholder=""
                                        value="<?php echo e($tour->location); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="map" class="col-form-label">Tour Map (Embeded Link)</label>
                                    <input class="form-control" id="map" name="map" value="<?php echo e($tour->map); ?>" type="url">
                                    <?php $__errorArgs = ['map'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Age <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="age" placeholder=""
                                        value="<?php echo e($tour->age); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputPhoto" class="col-form-label">Upload tour image ( Size: 852px x 489px)
                                        <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        
                                        <input class="form-control" type="file" name="photo"
                                            value="<?php echo e($tour->photo); ?>">
                                    </div>
                                    <div id="holder" style="margin-top:15px;max-height:100px;"></div>

                                    <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <img src="<?php echo e(Storage::url($tour->photo)); ?>" height="75" width="75"
                                        alt="" />
                                </div>

                                <div class="form-group">
                                    <label for="description" class="col-form-label">Tour Description</label>
                                    <textarea class="form-control ckeditor" id="description" name="description" required><?php echo e($tour->description); ?></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Number of Days <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="number_of_days" placeholder=""
                                        value="<?php echo e($tour->number_of_days); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['number_of_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div id="itinerary-container">
                                    <?php for($z = 0; $z < count(json_decode($tour->itinerary_titles)); $z++): ?>
                                        <fieldset>
                                            <legend for="fiels-1" class="w-100 d-flex justify-content-between align-items-center">
                                                <span class="text-muted">Itinerary Section</span>
                                                <button type="button" class="btn btn-sm btn-danger itinery-rem-button"  onclick="removeItItem(this)" style="border-radius: 50%; width: 30px; height: 30px">X</button>
                                            </legend>
                                            <div class="form-group itinerary-item">
                                                <label for="itinerary_title_1" class="col-form-label">Itinerary Title
                                                    <span class="text-danger">*</span></label>
                                                <input id="itinerary_title_1" type="text" name="itinerary_titles[]"
                                                    value="<?php echo e(json_decode($tour->itinerary_titles)[$z]); ?>"
                                                    class="form-control" required>

                                                <label for="itinerary_description_1" class="col-form-label">Description
                                                    <span class="text-danger">*</span></label>
                                                <textarea id="itinerary_description_1" name="itinerary_descriptions[]" class="form-control ckeditor" required><?php echo e(json_decode($tour->itinerary_descriptions)[$z]); ?></textarea>
                                            </div>
                                        </fieldset>
                                    <?php endfor; ?>
                                </div>

                                <div class="form-group">
                                    <button type="button" style="border-radius: 15px" id="add-itinerary" class="btn btn-info btn-sm">Add Itinerary</button>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Price Per Person <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="price" placeholder=""
                                        value="<?php echo e($tour->price); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Price Per Child <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="price_per_child" placeholder=""
                                        value="<?php echo e($tour->price_per_child); ?>" class="form-control" >
                                    <?php $__errorArgs = ['price_per_child'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Discount <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="number" name="discount" placeholder=""
                                        value="<?php echo e($tour->discount); ?>" class="form-control" >
                                    <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <?php
                                    $tour_includes = explode(',', $tour->includes);
                                    // dd($includes);
                                ?>
                                <div class="form-group">
                                    <label for="includes">Includes</label>
                                    <select name="includes[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $includes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->title); ?>"
                                                <?php echo e(in_array("$data->title", $tour_includes) ? 'selected' : ''); ?>>
                                                <?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                
                                <?php
                                    $tour_excludes = explode(',', $tour->excludes);
                                    // dd($excludes);
                                ?>
                                <div class="form-group">
                                    <label for="excludes">Excludes</label>
                                    <select name="excludes[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $excludes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->title); ?>"
                                                <?php echo e(in_array("$data->title", $tour_excludes) ? 'selected' : ''); ?>>
                                                <?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="location_category_id" class="col-form-label">Location Category <span
                                            class="text-danger">*</span></label>
                                    <select name="location_category_id" class="form-control">
                                        <option value="">Select Location Category</option>
                                        <?php
                                            $location_categories = \App\Models\LocationCategory::where('status', 'active')->get();
                                        ?>
                                        <?php $__currentLoopData = $location_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>" <?php echo e($tour->location_category_id == $category->id ? 'selected' : ''); ?>>
                                                <?php echo e($category->title); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['location_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputPhotos" class="col-form-label">Upload Multiple Images (Size: 1024px x 576px | Max: 12 photos)</label>
                                    <div class="input-group">
                                        <input class="form-control" type="file" name="images[]" multiple>
                                    </div>
                                    <?php $__errorArgs = ['images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <?php if($tour->images): ?>
                                    <div class="form-group">
                                        <label for="currentImages">Current Images</label>
                                        <br>
                                        <?php
                                            // Convert comma-separated string to array
                                            $imageArray = explode(',', $tour->images);
                                        ?>
                                        <?php $__currentLoopData = $imageArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <img src="<?php echo e(Storage::url($image)); ?>" height="75" width="75"
                                                alt="" />
                                            
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>

                                <div class="form-group">
                                    <label for="status" class="col-form-label">Status <span
                                            class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option value="active" <?php echo e($tour->status == 'active' ? 'selected' : ''); ?>>Active
                                        </option>
                                        <option value="featured"<?php echo e($tour->status == 'featured' ? 'selected' : ''); ?>>Featured</option>

                                        <option value="inactive" <?php echo e($tour->status == 'inactive' ? 'selected' : ''); ?>>
                                            Inactive</option>
                                    </select>
                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group mb-3">
                                    <button class="btn btn-success" type="submit">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $ = jQuery;

        function removeItItem(e) {
            if (confirm('Are you sure yo want to remove this section?')) {
                e.parentNode.parentNode.remove();
            }
        }

        $(document).ready(function() {
            // $('.ckeditor').ckeditor();

            let itineraryCount = 1;

            $('#add-itinerary').on('click tap', function() {
                itineraryCount++;

                let itineraryItem = `
                <legend for="fiels-1" class="w-100 d-flex justify-content-between align-items-center">
                    <span class="text-muted">Itinerary Section</span>
                    <button type="button" class="btn btn-sm btn-danger itinery-rem-button" onclick="removeItItem(this)" style="border-radius: 50%; width: 30px; height: 30px">X</button>
                </legend>
                <div class="form-group itinerary-item">
                    <label for="itinerary_title_${itineraryCount}" class="col-form-label">Itinerary Title <span class="text-danger">*</span></label>
                    <input id="itinerary_title_${itineraryCount}" type="text" name="itinerary_titles[]" class="form-control" required>
                    
                    <label for="itinerary_description_${itineraryCount}" class="col-form-label">Description <span class="text-danger">*</span></label>
                    <textarea id="itinerary_description_${itineraryCount}" name="itinerary_descriptions[]" class="form-control" required></textarea>
                </div>`;

                let newSec = document.createElement('fieldset');
                newSec.id = `new-${itineraryCount}-sec`;
                document.getElementById('itinerary-container').appendChild(newSec);

                setTimeout(() => {
                    $(`#new-${itineraryCount}-sec`).html(`${itineraryItem}`);

                    setTimeout(() => {
                        CKEDITOR.replace(document.getElementById(`itinerary_description_${itineraryCount}`));
                        setTimeout(() => {
                            jQuery('.cke_notifications_area').remove()
                        }, 1000);
                    }, 100);
                }, 100);
            });

            setTimeout(() => {
                jQuery('.cke_notifications_area').remove()
            }, 1000);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Ufanisi_projects\tembea\resources\views/backend/tour/edit.blade.php ENDPATH**/ ?>