<?php $__env->startSection('title'); ?> <?php echo e(__('header.home_title')); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('frontend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Body main wrapper start -->
<main class="main-area fix">

<?php
    $banners = $banners ?? [];
?>

<?php if(count($banners) > 0): ?>
    <!-- Banner area start -->
    <section class="bd-banner-area banner-style-five">
        <div class="booking-search">
            <form method="GET" action="<?php echo e(route('destination.search')); ?>">
				<div class="banner-booking-wrapper">
					<div class="row gy-24">
						<div class="col-12">
							<div class="banner-booking-form-select">
								<div tabindex="0" class="nice-select banner-booking-form-input style-two">
									<span class="banner-booking-form-icon"><i class="icon-location-fill"></i></span>
									<span class="current">Country</span>
									<ul class="list">
										<li data-value="0" class="option selected focus"> Country</li>
										<?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<li data-value="<?php echo e($country); ?>" class="option"><?php echo e($country); ?></li>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</ul>
									<input type="text" name="country" placeholder="Search Country" class="form-control">
								</div>
							</div>
						</div>
						<div class="col-12">
							<div class="banner-booking-form-select">
								<div tabindex="0" class="nice-select banner-booking-form-input style-two">
									<span class="banner-booking-form-icon"><i class="icon-flag-wave"></i></span>
									<span class="current">Categories</span>
									<ul class="list">
										<li data-value="0" class="option selected">Categories</li>
										<?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<li data-value="<?php echo e($tag); ?>" class="option"><?php echo e($tag); ?></li>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</ul>
									<input type="text" name="tags" placeholder="Search Tags" class="form-control">
								</div>
							</div>
						</div>
						<div class="col-12">
							<div class="banner-search-button">
								<button type="submit" class="banner-btn banner-square-btn bd-btn btn-style radius-10 w-100">
									<span><i class="fa-regular fa-magnifying-glass"></i></span> Search
								</button>
							</div>
						</div>
					</div>
				</div>
			</form>
        </div>
        <div class="swiper bd-slider-active p-relative">
            <div class="swiper-wrapper slider-wrapper">
                <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide <?php echo e($key == 0 ? 'active' : ''); ?>">
                        <div class="banner-slider-wrapper">
                            <div class="banner-bg-image" data-background="<?php echo e(Storage::url($banner->photo)); ?>"></div>
                            <div class="container">
                                <div class="row">
                                    <div class="col-xxl-7 col-xl-9 col-lg-8">
                                        <div class="banner-five-content">
                                            <div class="banner-subtitle mb-10"><?php echo e($banner->subtitle); ?></div>
                                            <h1 class="banner-title large white-text mb-25"><?php echo e($banner->title); ?></h1>
                                            <div class="banner-btn">
                                                <a href="<?php echo e($banner->link); ?>" class="bd-primary-btn btn-style has-arrow is-bg radius-60">
                                                    <span class="bd-primary-btn-arrow arrow-right"><i class="fa-regular fa-arrow-right"></i></span>
                                                    <span class="bd-primary-btn-text"><?php echo e($banner->button); ?></span>
                                                    <span class="bd-primary-btn-circle"></span>
                                                    <span class="bd-primary-btn-arrow arrow-left"><i class="fa-regular fa-arrow-right"></i></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <!-- navigation button start -->
            <div class="banner-nav-btn banner-five-navigation d-none d-xxl-block">
                <div class="banner-navigation-btn-2">
                    <button class="banner-navigation-prev"><i class="fa-regular fa-angle-left"></i></button>
                    <button class="banner-navigation-next"><i class="fa-regular fa-angle-right"></i></button>
                </div>
            </div>
            <!-- navigation button end -->
        </div>
    </section>
    <!-- Banner area start -->
<?php endif; ?>


	<!-- activity area start -->
	<section class="bd-activity-area section-space fix">
		<div class="container">
			<div class="row gy-24 text-center align-items-center justify-content-center section-title-space">
				<div class="col-xl-4">
					<div class="section-title-wrapper">
						<span class="section-subtitle mb-10">Our Destinations</span>
						<h2 class="section-title">Find Popular Destinations</h2>
					</div>
				</div>
			</div>
			<div class="row gy-24">
				<?php if($destinations): ?>
                    <?php $__currentLoopData = $destinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
							<div class="activity-wrapper activity-style activity-style-six">
								<div class="activity-thumb image-overly">
									<a href="<?php echo e(route('destination.detail',$destination->slug)); ?>">
										<?php
                                            $photo=explode(',',$destination->photo);
                                        ?>
                                        <img src="<?php echo e(Storage::url($destination->photo)); ?>" class="img-responsive"  alt="" />
									</a>
								</div>
								
								<div class="activity-content-wrap">
									<div class="activity-content">
										<div class="activity-content-top d-flex align-items-center gap-10 justify-content-between">
											<div class="activity-title-wrap">
												<h6 class="underline">
													<a href="<?php echo e(route('destination.detail',$destination->slug)); ?>">
														<?php echo e($destination->title); ?>

													</a>
												</h6>
											</div>
											<div class="activity-btn">
												<a class="bd-icon-btn hover-style"
												 href="<?php echo e(route('destination.detail',$destination->slug)); ?>" 
												target="_blank"><i class="fa-sharp fa-regular fa-arrow-right"></i></a>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!-- activity area end -->

	<!-- about-us area start -->
    <section class="bd-about-us-area section-space">
        <div class="container">
            <div class="row gy-24 justify-content-between">
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 wow fadeInLeft">
                    <div class="about-thumb-wrap about-style-two">
                        <div class="about-thumb-one">
                            <img src="<?php echo e(asset('frontend/assets/images/home_big.jpg')); ?>" alt="image">
                        </div>
                        <div class="about-thumb-two">
                            <img src="<?php echo e(asset('frontend/assets/images/home_small.jpg')); ?>" alt="image">
                        </div>
                        <div class="about-icon-badge">
                            <span><i class="icon-world"></i></span>
                        </div>
                        <div class="about-shape">
                            <img src="<?php echo e(asset('frontend/assets/images/shapes/about-shape.png')); ?>" alt="shape">
                        </div>
                    </div>
                    <br>
                    <h5>Who We Are</h5>
                    <p>Zawadi Sanctuary is a local tour operator based in Uganda, offering quality nature tours & safaris to Uganda’s most attractive destinations.
                    </p>
                    <p>We plan relaxed and flexible itineraries tailor made according to your interests.  Apart from our proposed itineraries, we also organize transfers, short day trips and excursions. Our support service is available 24/7. </p>
                    <p>You will work with a dedicated team. We keep in touch with you right away from enquiry, arrival until departure.
                    We also provide all the auxiliary services related to tourist needs and services within our area of operation.
                    </p>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12">
                    <div class="section-title-wrapper mb-35">
                        <span class="section-subtitle mb-15">About Us</span>
                        <h2 class="section-title mb-20">
                            Get 100% Satisfaction With
                            Our Service</h2>
                    </div>
                    <div class="about-list">
                        <ul>
                            
                            <li>
                                <span class="about-list-icon">
                          <i class="icon-life-jacket"></i>
                       </span>
                                <div>
                                    <span class="about-list-title mb-5">Our Vision</span>
                                    <span class="about-list-subtitle">To be among the best tourism companies in Uganda, being recognized for our professionalism, excellent customer care and high quality services.</span>
                                </div>
                            </li>
                            <li>
                                <span class="about-list-icon">
                          <i class="fa-light fa-badge-dollar"></i>
                       </span>
                                <div>
                                    <span class="about-list-title mb-5">Our Mission</span>
                                    <span class="about-list-subtitle">To perform and deliver excellent quality service to our clients. Providing them unforgettable Safaris & enjoyable Excursions , with guaranteed services that exceed their expectations.
                                    We plan relaxed and flexible itineraries tailor made according to your interests.
                                    Our support service is available 24/7. Guides are specialists in nature, wildlife, birds, geography and history. Locals site guides are natives in parks & places that clients visit.
                                    We spend more nights at carefully selected  accommodations, ensuring maximum relaxation and delicious meals!
                         
                                    </span>
                                </div>
                            </li>
                            <li>
                                <span class="about-list-icon">
                          <i class="icon-trip"></i>
                       </span>
                                <span>
                          <span class="about-list-title mb-5">Our Objectives</span>
                                <span class="about-list-subtitle">
                                    <p>To provide a high standard of services suitable for individuals seeking relaxing, comfortable and memorable experiences in the hospitality and tourism industry. </p>
                                    <p>To provide the tourist market with the quality personal required by the tourism industry. </p>
                                    <p>To produce expeditions and memories that would satisfy each of our tour customer. </p>
                                    </span>
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- about-us area end -->

	<br><br>

	<!-- cta area start  -->
	<section class="bd-cta-area">
		<div class="container">
			<div class="row">
				<div class="col-xl-12">
					<div class="cta-wrapper cta-item cta-top p-relative fix">
						<div class="cta-thumb">
							<img src="<?php echo e(asset('frontend/assets/images/cta/cta-bg-3.png')); ?>" alt="image">
						</div>
						<div class="cta-five-shape-wrap">
							<div class="cta-five-shape-one">
								<svg class="line-dash" xmlns="http://www.w3.org/2000/svg" width="62" height="189" viewBox="0 0 62 189" fill="none">
									<path d="M60.8463 1.88108C24.1532 4.12571 3.23706 24.8596 3.65598 39.628C4.54894 71.1079 29.5088 91.5168 46.4287 114.553C86.0696 168.522 21.3918 196.8 1.31736 185.21" stroke="#FFF8E6" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3 3"></path>
								</svg>
							</div>
							<div class="cta-five-shape-two">
								<img src="<?php echo e(asset('frontend/assets/images/shapes/plane-7.png')); ?>" alt="image">
							</div>
						</div>
						<div class="cta-item-box">
							<div class="cta-item-box-left">
								<div class="">
									<div class="cta-item-box-thumb spin">
										<img src="<?php echo e(asset('frontend/assets/images/shapes/cta-world.png')); ?>" alt="shape">
									</div>
								</div>
								<div class="section-title-wrapper p-relative z-index-11">
									<span class="section-subtitle color-warning mb-10">QUISEQUE VEL ORTOR</span>
									<h4 class="section-title white-text mb-5">Ready to Enjoy Next Trip</h4>
								</div>
							</div>
							<div class="cta-btn">
								<a href="<?php echo e(route('tour')); ?>" class="bd-primary-btn btn-style has-arrow is-bg btn-tertiary is-white radius-60">
									<span class="bd-primary-btn-arrow arrow-right"><i class="fa-regular fa-arrow-right"></i></span>
									<span class="bd-primary-btn-text">Explore Now</span>
									<span class="bd-primary-btn-circle"></span>
									<span class="bd-primary-btn-arrow arrow-left"><i class="fa-regular fa-arrow-right"></i></span>
								</a>

							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- cta area end  -->

	<!-- tour area start -->
	<section class="bd-service-area section-space">
		<div class="container">
			<div class="row gy-24 text-center justify-content-center section-title-space">
				<div class="col-xxl-5 col-xl-6 col-lg-6 col-md-8">
					<div class="section-title-wrapper">
						<span class="section-subtitle mb-10">Top Services</span>
						<h2 class="section-title">Dive into Our Range of Activities</h2>
					</div>
				</div>
			</div>
			<div class="row gy-24">
				<?php if($services): ?>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 wow fadeInUp" data-wow-delay=".3s">
							<div class="tour-wrapper style-five">
								<div class="tour-thumb-wrapper p-relative">
									<div class="tour-thumb image-overly">
										<a>
											<?php
                                                $photo=explode(',',$service->photo);
                                            ?>
                                        	<img src="<?php echo e(Storage::url($service->photo)); ?>" class="img-responsive"  alt="<?php echo e(Storage::url($service->photo)); ?>" />
										</a>
									</div>
								</div>
								<div class="tour-content">
									<h5 class="tour-title fw-5 underline mb-10">
										<a>
											<?php echo e($service->title); ?>

										</a>
									</h5>
									<div class="tour-price-wrapper">
										<p><?php echo $service->description; ?></p>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!-- tour area end -->

	<!-- travel area start -->
	<section class="bd-travel-area theme-bg-secondary section-space p-relative">
		<div class="container">
			<div class="travel-shape">
				<div class="travel-shape-one">
					<svg class="line-dash" xmlns="http://www.w3.org/2000/svg" width="62" height="189" viewBox="0 0 62 189" fill="none">
						<path d="M60.8463 1.88108C24.1532 4.12571 3.23706 24.8596 3.65598 39.628C4.54894 71.1079 29.5088 91.5168 46.4287 114.553C86.0696 168.522 21.3918 196.8 1.31736 185.21" stroke="#FFF8E6" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3 3" />
					</svg>
				</div>
				<div class="travel-shape-two">
					<img src="<?php echo e(asset('frontend/assets/images/shapes/plane-2.png')); ?>" alt="shape">
				</div>
				<div class="travel-shape-three">
					<img src="<?php echo e(asset('frontend/assets/images/shapes/camera.png')); ?>" alt="shape">
				</div>
				<div class="travel-shape-four">
					<img src="<?php echo e(asset('frontend/assets/images/shapes/line-circle.png')); ?>" alt="shape">
				</div>
				<div class="travel-shape-five">
					<img src="<?php echo e(asset('frontend/assets/images/shapes/circle-bg-3.png')); ?>" alt="shape">
				</div>
				<div class="travel-shape-six">
					<img src="<?php echo e(asset('frontend/assets/images/shapes/stone.png')); ?>" alt="shape">
				</div>
			</div>
			<div class="row gy-24 align-items-center justify-content-between">
				<div class="col-xl-6 col-lg-6">
					<div class="travel-section">
						<div class="popup-vido mb-40">
							<a class="bd-play-btn btn-tertiary popup-video animation-two theme-bg" href="https://www.youtube.com/watch?v=eUpwDAnkgSM">
								<i class="icon-play"></i>
							</a>
						</div>
						<div class="section-title-wrapper is-white mb-35">
							<span class="section-subtitle text-warning mb-10">Are you ready to travel?</span>
							<h2 class="section-title mb-15">
								Take a Break & Checkout Our Top Destinations
							</h2>
							<p>
								We offer wildlife safari in Ugandan national parks such as Queen Elizabeth national park & all excursion in Uganda.
(Explore more once clicked, should take one to the destination page)
							</p>
						</div>
						<div class="travel-btn">
							<a href="<?php echo e(route('destination')); ?>" class="bd-primary-btn btn-style has-arrow is-bg radius-60">
								<span class="bd-primary-btn-arrow arrow-right"><i class="fa-regular fa-arrow-right"></i></span>
								<span class="bd-primary-btn-text">Know More</span>
								<span class="bd-primary-btn-circle"></span>
								<span class="bd-primary-btn-arrow arrow-left"><i class="fa-regular fa-arrow-right"></i></span>
							</a>
						</div>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="row gy-24">
						<div class="col-lg-6 col-sm-6">
							<div class="travel-wrapper">
								<div class="travel-item">
									<div class="travel-icon"><span><i class="icon-elephant"></i></span></div>
									<h5 class="travel-title white-text underline-two"><a>Wild Life Tours</a></h5>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-sm-6">
							<div class="travel-wrapper">
								<div class="travel-item">
									<div class="travel-icon"><span><i class="icon-cycling"></i></span></div>
									<h5 class="travel-title white-text underline-two"><a>Mountain Climbing</a></h5>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-sm-6">
							<div class="travel-wrapper">
								<div class="travel-item">
									<div class="travel-icon"><span><i class="icon-skydive"></i></span></div>
									<h5 class="travel-title white-text underline-two"><a>Beach Trips & Resorts</a></h5>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-sm-6">
							<div class="travel-wrapper">
								<div class="travel-item">
									<div class="travel-icon"><span><i class="icon-adventure"></i></span></div>
									<h5 class="travel-title white-text underline-two"><a>Adventure
											Tours</a></h5>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- travel area end -->

	<!-- trip area start -->
	<section class="bd-trip section-space">
		<div class="container">
			<div class="row gy-24 text-center justify-content-center section-title-space">
				<div class="col-xxl-6 col-xl-6 col-lg-6 col-md-10">
					<div class="section-title-wrapper">
						<span class="section-subtitle mb-10">Our Trip</span>
						<h2 class="section-title">Experience the Extraordinary Everywhere you Go</h2>
					</div>
				</div>
			</div>
			<div class="row gy-24">
                <?php if($tours): ?>
                    <?php $__currentLoopData = $tours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-lg-4 col-md-4">
                            <div class="trip-wrapper trip-style-one p-relative">
                                <div class="trip-thumb image-overly">
                                    <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>">
                                        <?php
                                            $photo=explode(',',$tour->photo);
                                        ?>
                                        <img src="<?php echo e(Storage::url($tour->photo)); ?>" class="img-responsive"  alt="" />
                                    </a>
                                </div>
                                <div class="trip-tag">
                                    <div class="trip-location">
                                        <span><a href="<?php echo e(route('tour.detail',$tour->slug)); ?>"><?php echo e($tour->title); ?></a></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
	</section>
	<!-- trip area end -->

	<!-- counter area start -->
	<section class="bd-counter-area counter-bottom">
		<div class="container">
			<div class="row gy-24 text-center justify-content-center section-title-space">
				<div class="col-lg-8col-md-8">
					<div class="section-title-wrapper">
						<span class="section-subtitle mb-10">Company Facts</span>
						<h2 class="section-title">Celebrating Our Journey</h2>
					</div>
				</div>
			</div>
			<div class="row gy-24">
				<?php if($statistics): ?>
					<?php $__currentLoopData = $statistics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statistic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 wow fadeInUp" data-wow-delay=".3s">
							<div class="counter-wrapper counter-style-four">
								<div class="counter-item">
									<div class="counter-content">
										<span class="counter-icon bg-two"><i class="icon-location-crosshairs"></i></span>
										<h2><span data-purecounter-duration="1" data-purecounter-end="<?php echo e($statistic->price); ?>"
											class="purecounter"><?php echo e($statistic->price); ?></span>+
										</h2>
										<p><?php echo e($statistic->title); ?></p>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!-- counter area end -->

	<!-- testimonial area start  -->
	<section class="bd-testimonial-area section-space-bottom testimonial-space-top p-relative fix flash-white">
		<div class="container">
			<div class="row gy-24 justify-content-between">
				<div class="col-xxl-5 col-xl-5 col-lg-5">
					<div class="section-title-wrapper mb-35">
						<span class="section-subtitle mb-10">Testimonials</span>
						<h2 class="section-title mb-15">Voices of Travelers Testimonials and Reviews</h2>
						<p class="">Customer Care is our number one Priority. Kindly review some of their Testimonials.</p>
					</div>
					<div class="travel-btn">
						<a href="<?php echo e(route('testimonial')); ?>" class="bd-primary-btn btn-style has-arrow is-bg radius-60">
							<span class="bd-primary-btn-arrow arrow-right"><i class="fa-regular fa-arrow-right"></i></span>
							<span class="bd-primary-btn-text">See More</span>
							<span class="bd-primary-btn-circle"></span>
							<span class="bd-primary-btn-arrow arrow-left"><i class="fa-regular fa-arrow-right"></i></span>
						</a>

					</div>
				</div>
				<div class="col-xxl-7 col-xl-7 col-lg-7">
					<div class="testimonial-five">
						<div class="swiper testimonial-five-active position-relative">
							<div class="swiper-wrapper">
								<?php if($testimonials): ?>
									<?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<div class="swiper-slide">
											<div class="testimonial-wrapper testimonial-style-five">
												<div class="testimonial-content p-relative">
													<div class="avatar-rating mb-25">
														<div class="fs-14 d-flex rating-color">
															<i class="fa-solid fa-star"></i>
															<i class="fa-solid fa-star"></i>
															<i class="fa-solid fa-star"></i>
															<i class="fa-solid fa-star"></i>
															<i class="fa-solid fa-star"></i>
														</div>
													</div>
													<p class="testimonial-description">
														<?php echo $testimonial->message; ?>

													</p>
													<div class="testimonial-quotation">
														<i class="fa-sharp fa-solid fa-quote-left"></i>
													</div>
												</div>
												<div class="testimonial-avatar-wrap">
													<div class="avatar-thumb">
														<?php
															$photo=explode(',',$testimonial->photo);
														?>
														<img src="<?php echo e(Storage::url($testimonial->photo)); ?>" alt="<?php echo e(Storage::url($testimonial->photo)); ?>">
													</div>
													<div class="avatar-meta">
														<h6 class="avatar-meta-title"><?php echo e($testimonial->name); ?></h6>
														<p><?php echo e($testimonial->position); ?></p>
													</div>
												</div>
											</div>
										</div>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php endif; ?>
							</div>
							<div class="slider-pagination-wrapper testimonial-five-pagination">
								<div class="slider-pagination bd-pagination justify-content-center"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- testimonial area end  -->

	<!-- blog area start -->
	<section class="bd-blog-area section-space">
		<div class="container">
			<div class="row gy-24 align-items-center justify-content-center section-title-space">
				<div class="col-xl-6 col-md-8">
					<div class="section-title-wrapper text-center">
						<span class="section-subtitle mb-10">Our Blog</span>
						<h2 class="section-title">Blog For Travel Updates</h2>
					</div>
				</div>
			</div>
			<div class="row gy-24">
				<?php if($posts): ?>
                    <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".5s">
							<article class="blog-wrapper blog-default blog-style-six">
								<div class="blog-thumb image-hover-effect">
									<?php
										$photo=explode(',',$post->photo);
									?>
									<a href="<?php echo e(route('blog.detail',$post->slug)); ?>">
										<img src="<?php echo e(Storage::url($post->photo)); ?>" alt="<?php echo e(Storage::url($post->photo)); ?>">
									</a>
								</div>
								<div class="blog-content">
									<div class="blog-meta-list">
										<div class="blog-meta-item has-seperator">
											<span class="meta-icon">
												<i class="icon-profile"></i>
											</span>
											<span class="meta-text">
												<a class="meta-author" href="<?php echo e(route('blog.detail',$post->slug)); ?>">
													<?php echo e($post->tags); ?>

												</a>
											</span>
										</div>
										<div class="blog-meta-item">
											<span class="meta-icon">
												<i class="icon-cleander-check"></i>
											</span>
											<span class="meta-text">
												<a href="<?php echo e(route('blog.detail',$post->slug)); ?>">
													<?php echo e($post->created_at->format('d M , Y. D')); ?>

												</a>
											</span>
										</div>
									</div>
									<h5 class="blog-title mb-5 underline">
										<a href="<?php echo e(route('blog.detail',$post->slug)); ?>">
											<?php echo e($post->title); ?>

										</a>
									</h5>
									<p<?php echo substr($post->description, 0, 100); ?></p>
									<div class="">
										<div class="icon-text-btn p-relative">
											<a href="<?php echo e(route('blog.detail',$post->slug)); ?>">
												<span>Read More</span>
												<i>
													<svg width="18" height="14" viewBox="0 0 18 14" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M11.2871 1L17 6.71285L11.2871 12.4257" stroke="currentColor" stroke-width="1.5"
															stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
														<path d="M1 6.71313H16.8397" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
															stroke-linecap="round" stroke-linejoin="round"></path>
													</svg>
												</i>
											</a>
										</div>
									</div>
								</div>
							</article>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!-- blog area end -->

	<!-- instagram area start -->
	<div class="bd-instagram-area pb-50">
		<div class="swiper instagram-slide-activation">
			<!-- Elfsight Instagram Feed | Zawadi Sanctuary -->
            <script src="https://static.elfsight.com/platform/platform.js" async></script>
            <div class="elfsight-app-2f6aa6c3-6063-4d78-82a6-8b77fcf885bc" data-elfsight-app-lazy></div>

		</div>
	</div>
	<!-- instagram area start -->
</main>
<!-- Body main wrapper end -->

	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rlmt0yhldtmh/public_html/0255/copy/resources/views/frontend/index.blade.php ENDPATH**/ ?>