<?php $__env->startSection('meta'); ?>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name='copyright' content=''>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="keywords" content="">
	
	
	<meta property="og:type" content="article">
	<meta property="og:title" content="<?php echo e($tour->title); ?>">
	<meta property="og:image" content="<?php echo e($tour->photo); ?>">
	<meta property="og:description" content="<?php echo e($tour->description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?> <?php echo e($tour->title); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('frontend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" data-background="<?php echo e(asset('frontend/assets/images/tours_page.jpg')); ?>"></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title"><?php echo e($tour->title); ?></h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="<?php echo e(route('home')); ?>"><i class="icon-home"></i>Home</a></span>
                                    <span>Tour</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- blog-details area start -->
    <section class="bd-tour-details-area section-space">
        <div class="container">
            <div class="row gy-24">
                <div class="col-xxl-8 col-xl-8 col-lg-7">
                    <div class="tour-details-wrapper">
                        <div class="tour-details mb-25">
                            <div class="tour-details-thumb details-slide-full mb-30">
                                <?php
                                    $photo=explode(',',$tour->photo);
                                ?>
                                <img src="<?php echo e(Storage::url($tour->photo)); ?>" class="img-responsive"  alt="" />
                            </div>
                            <div class="tour-details-content">
                                <div class="tour-details-badge d-flex gap--5 mb-10">
                                    <span class="bd-badge warning fw-5">Discount</span>
                                    <span class="bd-badge danger fw-5"><?php echo e($tour->discount); ?></span>
                                </div>
                                <h3 class="tour-details-title mb-15"><?php echo e($tour->title); ?></h3>
                                <div class="tour-details-meta d-flex flex-wrap gap-10 align-items-center justify-content-between mb-20">
                                    <div class="tour-details-price">
                                        <h4 class="price-title">$<?php echo e($tour->price); ?><span>/Per Person</span></h4>
                                    </div>
                                    <div class="tour-details-price">
                                        <h4 class="price-title">$<?php echo e($tour->price_per_child); ?><span>/Per Child</span></h4>
                                    </div>
                                </div>
                                <div class="tour-details-destination-wrapper">
                                    <div class="tour-details-destination-info">
                                        <div class="search-icon-bg is-big">
                                            <span><i class="fa-light fa-clock"></i></span>
                                        </div>
                                        <div class="tour-details-destination-info-title">
                                            <p class="tour-details-destination-info-top mb-0">Duration</p>
                                            <span class="tour-details-destination-info-bottom small"><?php echo e($tour->number_of_days); ?> Day(s)
                                            </span>
                                        </div>
                                    </div>
                                    <div class="tour-details-destination-info">
                                        <div class="search-icon-bg is-big">
                                            <span><i class="icon-hourglass"></i></span>
                                        </div>
                                        <div class="tour-details-destination-info-title">
                                            <p class="tour-details-destination-info-top mb-0">Min Age</p>
                                            <span class="tour-details-destination-info-bottom small"><?php echo e($tour->age); ?></span>
                                        </div>
                                    </div>
                                    <div class="tour-details-destination-info">
                                        <div class="search-icon-bg is-big">
                                            <span><i class="fa-sharp fa-light fa-moped"></i></span>
                                        </div>
                                        <div class="tour-details-destination-info-title">
                                            <p class="tour-details-destination-info-top mb-0">Tour Type</p>
                                            <span class="tour-details-destination-info-bottom small"><?php echo e($tour->tags); ?></span>
                                        </div>
                                    </div>
                                    <div class="tour-details-destination-info">
                                        <div class="search-icon-bg is-big">
                                            <span><i class="fa-light fa-location-dot"></i></span>
                                        </div>
                                        <div class="tour-details-destination-info-title">
                                            <p class="tour-details-destination-info-top mb-0">Location</p>
                                            <span class="tour-details-destination-info-bottom"><?php echo e($tour->location); ?></span>
                                        </div>
                                    </div>
                                </div>

                                <p class="mb-15"><?php echo $tour->description; ?></p>

                                <div class="tour-details-list-wrap mb-35">
                                    <h4 class="mb-20">Include/ Exclude</h4>
                                    <div class="tour-details-list-box">
                                        <div class="tour-details-list-include">
                                            <ul>
                                                <?php if($tour->includes): ?>
                                                    <?php $__currentLoopData = explode(',', $tour->includes); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $include): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li>
                                                            <span class="list-icon success"><i class="fa-solid fa-check"></i></span>
                                                            <?php echo e($include); ?>

                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                        <div class="tour-details-list-exclude">
                                            <ul>
                                                <?php if($tour->excludes): ?>
                                                    <?php $__currentLoopData = explode(',', $tour->excludes); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exclude): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li>
                                                            <span class="list-icon danger"><i class="fa-regular fa-xmark"></i></span>
                                                            <?php echo e($exclude); ?>

                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="tour-details-faq mb-35">
                                    <h4 class="mb-20">Tour Plan</h4>
                                    <div class="accordion-wrapper faq-style-3">
                                        <div class="accordion" id="accordionExampleThree">
                                            <div class="accordion-item">
                                                <?php for($z = 0; $z < count(json_decode($tour->itinerary_titles)); $z++): ?>
                                                    <h6 class="accordion-header" id="headingNine">
                                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine" aria-expanded="true" aria-controls="collapseNine">
                                                            <span><?php echo json_decode($tour->itinerary_titles)[$z]; ?></span> </button>
                                                    </h6>
                                                    <div id="collapseNine" class="accordion-collapse collapse show" aria-labelledby="headingNine" data-bs-parent="#accordionExampleThree">
                                                        <div class="accordion-body">
                                                            <div class="accordion-body-list">
                                                                <ul>
                                                                    <li><?php echo json_decode($tour->itinerary_descriptions)[$z]; ?></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endfor; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="tour-details-gallery mb-35">
                                    <h4 class="mb-20">Tour Galley</h4>
                                    <div class="row gy-24">
                                        <?php if($tour->images): ?>
                                            <?php
                                                $imageArray = explode(',', $tour->images);
                                            ?>
                                            <?php $__currentLoopData = $imageArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 <?php echo e($tour->id); ?>">
                                                    <div class="tour-details-gallery-thumb image-hover-effect-two position-relative">
                                                        <img src="<?php echo e(Storage::url($image)); ?>" alt="image">
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="tour-details-location mb-35">
                                    <h4 class="mb-20">Tour Location</h4>
                                    <div class="tour-details-location-map">
                                        <iframe src="<?php echo e($tour->map); ?>" 
                                            width="800" height="600" style="border:0;" 
                                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
                                        </iframe>                                        
                                    </div>
                                </div>                                                               
                                
                                <div class="tour-details-related-tour mb-35">
                                    <h4 class="mb-20">Related Tour</h4>
                                    <div class="row gy-24">
                                        <?php $__currentLoopData = $recent_tours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-xxl-4 col-xl-4 col-md-6">
                                                <div class="tour-wrapper style-one">
                                                    <div class="p-relative">
                                                        <div class="tour-thumb image-overly">
                                                            <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>">
                                                                <?php
                                                                    $photo=explode(',',$tour->photo);
                                                                ?>
                                                            <img src="<?php echo e(Storage::url($tour->photo)); ?>" class="img-responsive"  alt="<?php echo e(Storage::url($tour->photo)); ?>" />
                                                            </a>
                                                        </div>
                                                        <div class="tour-meta d-flex align-items-center justify-content-between">
                                                            <div class="tour-location">
                                                                <span>
                                                                    <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>">
                                                                        <i class="fa-regular fa-location-dot"></i> <?php echo e($tour->location); ?>

                                                                    </a>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="tour-content">
                                                        <h5 class="tour-title fw-5 underline mb-5">
                                                            <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>">
                                                                <?php echo e($tour->title); ?>

                                                            </a>
                                                        </h5>
                                                        <span class="tour-price b3">$<?php echo e($tour->price); ?> per Person</span>
                                                        <div class="tour-divider"></div>
                                                        <p><?php echo e($tour->tags); ?> </p>
                                                        <div class="tour-divider"></div>
                    
                                                        <div class="tour-meta d-flex align-items-center justify-content-between">
                                                            <div class="time d-flex align-items-center gap--5">
                                                                
                                                                <span><?php echo e($tour->number_of_days); ?> days</span>
                                                            </div>
                                                            <div class="tour-btn">
                                                                <a class="bd-text-btn style-two" href="<?php echo e(route('tour.detail',$tour->slug)); ?>" >Book Now
                                                                    <span class="icon__box">
                                                                        <i class="fa-regular fa-arrow-right-long icon__first"></i>
                                                                        <i class="fa-regular fa-arrow-right-long icon__second"></i>
                                                                    </span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-5">
                    <aside class="sidebar-wrapper sidebar-sticky">
                        <div class="sidebar-widget-wrapper mb-30">
                            <div class="sidebar-widget widget">
                                <h6 class="sidebar-widget-title small mb-15">Search Here</h6>
                                <div class="sidebar-search">
                                    <form class="sidebar-search-form" action="#" method="get">
                                        <input type="text" value="" required="" name="s" placeholder="Search">
                                        <button type="submit"> <i class="far fa-search"></i> </button>
                                    </form>
                                </div>
                            </div>
                            <div class="sidebar-widget-divider"></div>
                            <div class="sidebar-widget widget">
                                <h6 class="sidebar-widget-title small mb-15">Recent Tour List</h6>
                                <div class="sidebar-widget-post">
                                    <?php $__currentLoopData = $recent_tours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="recent-post">
                                            <div class="recent-post-thumb mr-10">
                                                <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>">
                                                    <?php
                                                        $photo=explode(',',$tour->photo);
                                                    ?>
                                                    <img src="<?php echo e(Storage::url($tour->photo)); ?>" class="img-responsive"  alt="<?php echo e(Storage::url($tour->photo)); ?>" />
                                                </a>
                                            </div>
                                            <div class="recent-post-content">
                                                <h6 class="recent-post-title small underline">
                                                    <a href="<?php echo e(route('tour.detail',$tour->slug)); ?>"><?php echo e($tour->title); ?></a>
                                                </h6>
                                                <span class="recent-post-price">$<?php echo e($tour->price); ?></span>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="sidebar-widget-banner p-relative">
                            <div class="sidebar-widget-thumb p-relative">
                                <img src="<?php echo e(asset('frontend/assets/images/bg/sidebar-img.png')); ?>" alt="img">
                            </div>
                            <div class="sidebar-widget-content">
                                <span class="bd-play-btn pulse-white mb-40"><i class="icon-call-ring"></i></span>
                                <p class="b3 mb-0">Free Call</p>
                                <h5 class="mb-25"><a href="tel:+255774862939">+255774862939</a></h5>
                                <div class="sidebar-btn">
                                    <a class="bd-text-btn style-two" href="<?php echo e(route('contact')); ?>">Contact
                                        <span class="icon__box">
                                            <i class="fa-light fa-angle-right icon__first"></i>
                                            <i class="fa-light fa-angle-right icon__second"></i>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
    <!-- blog-details area end -->

</main>
<!-- Body main wrapper end -->


<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rlmt0yhldtmh/public_html/0255/copy/resources/views/frontend/pages/tour-detail.blade.php ENDPATH**/ ?>