<?php $__env->startSection('title'); ?>
    Create Tour
<?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
    <?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="breadcrumbs">
        <div class="breadcrumbs-inner">
            <div class="row m-0">
                <div class="col-sm-4">
                    <div class="page-header float-left">
                        <div class="page-title">
                            <h1>Tours</h1>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="page-header float-right">
                        <div class="page-title">
                            <ol class="breadcrumb text-right">
                                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                                <li><a href="<?php echo e(route('tour.index')); ?>">Tours</a></li>
                                <li class="active">Add Tour</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <strong>Tours</strong>
                        </div>
                        <div class="card-body card-block">
                            <form method="post" action="<?php echo e(route('tour.store')); ?>" enctype="multipart/form-data">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Tour Title <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="title" placeholder=""
                                        value="<?php echo e(old('title')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="tags">Tour Tag</label>
                                    <select name="tags[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value='<?php echo e($data->title); ?>'><?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Tour Location <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="location" placeholder=""
                                        value="<?php echo e(old('location')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="map" class="col-form-label">Tour Map (Embeded Link)</label>
                                    <input class="form-control" id="map" name="map" value="<?php echo e(old('map')); ?>" type="url">
                                    <?php $__errorArgs = ['map'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Age Limit <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="age" placeholder=""
                                        value="<?php echo e(old('age')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputPhoto" class="col-form-label">Upload Tour image ( Size: 852px x 489px)
                                        <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        
                                        <input class="form-control" type="file" name="photo" required>
                                    </div>
                                    <div id="holder" style="margin-top:15px;max-height:100px;"></div>
                                    <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="description" class="col-form-label">Tour Description</label>
                                    <textarea class="form-control ckeditor" id="description" name="description" required><?php echo e(old('description')); ?></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="number_of_days" class="col-form-label">Number of Days <span
                                            class="text-danger">*</span></label>
                                    <input id="number_of_days" type="text" name="number_of_days" placeholder=""
                                        value="<?php echo e(old('number_of_days')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['number_of_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div id="itinerary-container">
                                    <fieldset>
                                        <legend for="fiels-1" class="w-100 d-flex justify-content-between align-items-center">
                                            <span class="text-muted">Itinerary Section</span>
                                            <button type="button" class="btn btn-sm btn-danger itinery-rem-button"  onclick="removeItItem(this)" style="border-radius: 50%; width: 30px; height: 30px">X</button>
                                        </legend>
                                        <div class="form-group itinerary-item">
                                            <label for="itinerary_title_1" class="col-form-label">Itinerary Title <span
                                                    class="text-danger">*</span></label>
                                            <input id="itinerary_title_1" type="text" name="itinerary_titles[]"
                                                class="form-control" required>

                                            <label for="itinerary_description_1" class="col-form-label">Description <span
                                                    class="text-danger">*</span></label>
                                            <textarea id="itinerary_description_1" name="itinerary_descriptions[]" class="form-control ckeditor" required></textarea>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="form-group">
                                    <button type="button" style="border-radius: 15px" id="add-itinerary" class="btn btn-info btn-sm">Add Itinerary</button>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Price Per Person <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="price" placeholder=""
                                        value="<?php echo e(old('price')); ?>" class="form-control" required>
                                    <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Price Per Child <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="price_per_child" placeholder=""
                                        value="<?php echo e(old('price_per_child')); ?>" class="form-control" >
                                    <?php $__errorArgs = ['price_per_child'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Discount <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="number" name="discount" placeholder=""
                                        value="<?php echo e(old('discount')); ?>" class="form-control" >
                                    <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="includes">Includes</label>
                                    <select name="includes[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $includes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value='<?php echo e($data->title); ?>'><?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="excludes">Excludes</label>
                                    <select name="excludes[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        <?php $__currentLoopData = $excludes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value='<?php echo e($data->title); ?>'><?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="categories" class="col-form-label">Categories <span
                                            class="text-danger">*</span></label>
                                    <select name="categories" class="form-control">
                                        <option value="tanzania-mainland">Tanzania Mainland</option>
                                        <option value="zanzibar">Zanzibar</option>
                                    </select>
                                    <?php $__errorArgs = ['categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="images" class="col-form-label">Upload Multiple Images (Size: 1024px x 576px | Max: 12 photos)</label>
                                    <div class="input-group">
                                        <input class="form-control" type="file" name="images[]" multiple>
                                    </div>
                                    <?php $__errorArgs = ['images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="status" class="col-form-label"><?php echo e(__('sidebar.post_status')); ?> <span
                                            class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option value="active">Active</option>
                                        <option value="featured">Featured</option>
                                        <option value="inactive">Inactive</option>
                                    </select>
                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group mb-3 text-right">
                                    <button type="reset"
                                        class="btn btn-warning"><?php echo e(__('sidebar.post_reset')); ?></button>
                                    <button class="btn btn-success"
                                        type="submit"><?php echo e(__('sidebar.post_submit')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $ = jQuery;

        function removeItItem(e) {
            if(confirm('Are you sure yo want to remove this section?')){
                e.parentNode.parentNode.remove();
            }
        }

        $(document).ready(function() {
            // $('.ckeditor').ckeditor();

            let itineraryCount = 1;

            $('#add-itinerary').on('click tap', function() {
                itineraryCount++;

                let itineraryItem = `
                <legend for="fiels-1" class="w-100 d-flex justify-content-between align-items-center">
                    <span class="text-muted">Itinerary Section</span>
                    <button type="button" class="btn btn-sm btn-danger itinery-rem-button" onclick="removeItItem(this)" style="border-radius: 50%; width: 30px; height: 30px">X</button>
                </legend>
                <div class="form-group itinerary-item">
                    <label for="itinerary_title_${itineraryCount}" class="col-form-label">Itinerary Title <span class="text-danger">*</span></label>
                    <input id="itinerary_title_${itineraryCount}" type="text" name="itinerary_titles[]" class="form-control" required>
                    
                    <label for="itinerary_description_${itineraryCount}" class="col-form-label">Description <span class="text-danger">*</span></label>
                    <textarea id="itinerary_description_${itineraryCount}" name="itinerary_descriptions[]" class="form-control" required></textarea>
                </div>`;

                let newSec = document.createElement('fieldset');
                newSec.id = `new-${itineraryCount}-sec`;
                document.getElementById('itinerary-container').appendChild(newSec);

                setTimeout(() => {
                    $(`#new-${itineraryCount}-sec`).html(`${itineraryItem}`);

                    setTimeout(() => {
                        CKEDITOR.replace(document.getElementById(`itinerary_description_${itineraryCount}`));
                        setTimeout(() => {
                            jQuery('.cke_notifications_area').remove()
                        }, 1000);
                    }, 100);
                }, 100);
            });

            setTimeout(() => {
                jQuery('.cke_notifications_area').remove()
            }, 1000);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rlmt0yhldtmh/public_html/0256/zawadi/resources/views/backend/tour/create.blade.php ENDPATH**/ ?>