<?php $__env->startSection('title'); ?> <?php echo e(__('sidebar.banner_title_name')); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Sliders</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                <li><a href="<?php echo e(route('banner.create')); ?>"> Add Slider</a></li>
                <li class="active">Sliders</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Sliders</strong>
                  </div>
                  <div class="card-body">
                    <?php if(count($banners)>0): ?>
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th><?php echo e(__('sidebar.bann_number')); ?></th>
                                <th><?php echo e(__('sidebar.bann_title')); ?></th>
                                <th>Subtitle</th>
                                <th>Button</th>
                                <th><?php echo e(__('sidebar.bann_photo')); ?></th>
                                <th><?php echo e(__('sidebar.bann_status')); ?></th>
                                <th><?php echo e(__('sidebar.bann_action')); ?></th>
                              </tr>
                          </thead>
                          <tbody>
                            <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <tr>
                                <td><?php echo e($banner->id); ?></td>
                                <td><?php echo e($banner->title); ?></td>
                                <td><?php echo e($banner->subtitle); ?></td>
                                <td><?php echo e($banner->button); ?></td>
                                <td>
                                    <?php if($banner->photo): ?>
                                        <img src="<?php echo e(Storage::url($banner->photo)); ?>" class="img-fluid zoom" style="max-width:80px" alt="<?php echo e(Storage::url($banner->photo)); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('backend/img/thumbnail-default.jpg')); ?>" class="img-fluid zoom" style="max-width:100%" alt="avatar.png">
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($banner->status=='active'): ?>
                                        <span class="badge badge-success"><?php echo e($banner->status); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-warning"><?php echo e($banner->status); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                  <a href="<?php echo e(route('banner.edit',$banner->id)); ?>" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fa fa-edit"></i></a>
                                  <button class="btn btn-danger btn-sm dltBtn" data-toggle="modal" data-target="#modal-delete<?php echo e($banner->id); ?>" data-id=<?php echo e($banner->id); ?> style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                    <div class="modal fade"  id="modal-delete<?php echo e($banner->id); ?>" tabindex="-1" aria-labelledby="modal-new-address" aria-hidden="true">
                                        <div class="modal-dialog  modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h6 class="modal-title" id="staticBackdropLabel">
                                                    </h6>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                      <span aria-hidden="true">×</span>
                                                    </button>
                                                    
                                                </div>
                                                <div class="modal-body">
                                                    <form action="<?php echo e(route('banner.destroy',$banner->id)); ?>" method="post">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                    <div class="row gy-3">
                                                        <div class="col-xl-6">
                                                            <H2>Are you Sure ?</H2>
                                                            <p>You won't be able to revert this!</p> 
                                                        </div>                                       
                                                    </div>
                                                
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger">Yes, Delete It</button>
                                                </div>
                                            </form>
                                            
                                            </div>
                                        </div>
                                    </div>
                                </td>
                              </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                      </table>
                      <?php else: ?>
                      <h6 class="text-center">No banners found!!! Please add banner</h6>
                    <?php endif; ?>
                  </div>
              </div>
          </div>


      </div>
  </div><!-- .animated -->
</div><!-- .content -->

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
       
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Ufanisi_projects\tembea\resources\views/backend/banner/index.blade.php ENDPATH**/ ?>