<?php $__env->startSection('title'); ?> <?php echo e(__('header.news_title')); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" data-background="<?php echo e(asset('frontend/assets/images/articles_page.jpg')); ?>"></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">Blog </h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="<?php echo e(route('home')); ?>"><i class="icon-home"></i>Home</a></span>
                                    <span>Blog </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- blog-grid area start -->
    <div class="bd-blog-grid-area section-space">
        <div class="container">
            <div class="row gy-24">
                <?php if($posts): ?>
                    <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6">
                            <article class="blog-wrapper blog-default blog-style-six">
                                <div class="blog-thumb image-hover-effect">
                                    <a href="<?php echo e(route('blog.detail',$post->slug)); ?>">
                                        <?php
                                            $photo=explode(',',$post->photo);
                                        ?>
                                        <img src="<?php echo e(Storage::url($post->photo)); ?>" class="img-responsive"  alt="" />
                                    </a>
                                </div>
                                <div class="blog-content">
                                    <div class="blog-meta-list">
                                        <div class="blog-meta-item has-seperator">
                                            <span class="meta-icon">
                                                <i class="icon-profile"></i>
                                            </span>
                                            <span class="meta-text">
                                                <a class="meta-author"><?php echo e($post->tags); ?></a>
                                            </span>
                                        </div>
                                        <div class="blo<?php echo e(route('blog.detail',$post->slug)); ?>g-meta-item">
                                            <span class="meta-icon">
                                                <i class="icon-cleander-check"></i>
                                            </span>
                                            <span class="meta-text"><a href="<?php echo e(route('blog.detail',$post->slug)); ?>"> <?php echo e($post->created_at->format('d M , Y. D')); ?></a></span>
                                        </div>
                                    </div>
                                    <h5 class="blog-title mb-5 underline"><a href="<?php echo e(route('blog.detail',$post->slug)); ?>"><?php echo e($post->title); ?></a></h5>
                                    <p><?php echo substr($post->description, 0, 100); ?></p>
                                    <div class="">
                                        <div class="icon-text-btn p-relative">
                                            <a href="<?php echo e(route('blog.detail',$post->slug)); ?>">
                                                <span>Read More</span>
                                                <i>
                                                    <svg width="18" height="14" viewBox="0 0 18 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M11.2871 1L17 6.71285L11.2871 12.4257" stroke="currentColor" stroke-width="1.5"
                                                            stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                                        <path d="M1 6.71313H16.8397" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                                    </svg>
                                                </i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- blog-grid area end -->

</main>
<!-- Body main wrapper end -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rlmt0yhldtmh/public_html/0255/copy/resources/views/frontend/pages/blog.blade.php ENDPATH**/ ?>