<?php $__env->startSection('title'); ?> Destinations <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Destinations</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="<?php echo e(route('admin')); ?>">Dashboard</a></li>
                <li><a href="<?php echo e(route('destination.create')); ?>">Add Destination</a></li>
                <li class="active">Destinations</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Destination</strong>
                  </div>
                  <div class="card-body">
                    <?php if(count($destinations)>0): ?>
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th><?php echo e(__('sidebar.post_snumber')); ?></th>
                                <th><?php echo e(__('sidebar.post_title')); ?></th>
                                <th>Country</th>
                                
                                <th><?php echo e(__('sidebar.post_photo')); ?></th>
                                <th><?php echo e(__('sidebar.post_status')); ?></th>
                                <th><?php echo e(__('sidebar.post_action')); ?></th>
                              </tr>
                          </thead>
                          <tbody>
                            <?php
                            $i =1;
                            ?>
                            <?php $__currentLoopData = $destinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                              <?php 
                              $author_info=DB::table('users')->select('name')->where('id',$destination->added_by)->get();
                              ?>
                              <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($destination->title); ?></td>
                                <td><?php echo e($destination->country); ?></td>
                                
                                <td>
                                    <?php if($destination->photo): ?>
                                        <img src="<?php echo e(Storage::url($destination->photo)); ?>" class="img-fluid zoom" style="max-width:80px" alt="<?php echo e(Storage::url($destination->photo)); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('backend/img/thumbnail-default.jpg')); ?>" class="img-fluid" style="max-width:80px" alt="avatar.png">
                                    <?php endif; ?>
                                </td>                   
                                <td>
                                    <?php if($destination->status=='active'): ?>
                                        <span class="badge badge-success"><?php echo e($destination->status); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-warning"><?php echo e($destination->status); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('destination.edit',$destination->id)); ?>" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fa fa-edit"></i></a>
                                    <button class="btn btn-danger btn-sm dltBtn" data-toggle="modal" data-target="#modal-delete<?php echo e($destination->id); ?>" data-id=<?php echo e($destination->id); ?> style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                    <div class="modal fade"  id="modal-delete<?php echo e($destination->id); ?>" tabindex="-1" aria-labelledby="modal-new-address" aria-hidden="true">
                                        <div class="modal-dialog  modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h6 class="modal-title" id="staticBackdropLabel">
                                                    </h6>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                      <span aria-hidden="true">×</span>
                                                    </button>
                                                    
                                                </div>
                                                <div class="modal-body">
                                                    <form action="<?php echo e(route('destination.destroy',$destination->id)); ?>" method="post">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                    <div class="row gy-3">
                                                        <div class="col-xl-6">
                                                            <H2>Are you Sure ?</H2>
                                                            <p>You won't be able to revert this!</p> 
                                                        </div>                                       
                                                    </div>
                                                
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger">Yes, Delete It</button>
                                                </div>
                                            </form>
                                            
                                            </div>
                                        </div>
                                    </div>
                                </td>
                              </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                      </table>
                      <?php else: ?>
                      <h6 class="text-center">No destinations found!!! Please add destination</h6>
                    <?php endif; ?>
                  </div>
              </div>
          </div>


      </div>
  </div><!-- .animated -->
</div><!-- .content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/defenders/public_html/0255_projects/tembea/resources/views/backend/destination/index.blade.php ENDPATH**/ ?>