<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes(['register'=>false]);

Route::get('user/login','FrontendController@login')->name('login.form');
Route::post('user/login','FrontendController@loginSubmit')->name('login.submit');
Route::get('user/logout','FrontendController@logout')->name('user.logout');

Route::get('user/register','FrontendController@register')->name('register.form');
Route::post('user/register','FrontendController@registerSubmit')->name('register.submit');
// Reset password
Route::post('password-reset', 'FrontendController@showResetForm')->name('password.reset'); 

Route::get('/','FrontendController@home')->name('home');

// Frontend Routes
Route::get('/home', 'FrontendController@index');
Route::get('/about-us','FrontendController@aboutUs')->name('about-us');

//What we are
Route::get('/what-we-are','FrontendController@whatweAre')->name('what-we-are');

//Team
Route::get('/team','FrontendController@team')->name('team');

//Agent
Route::get('/agent','FrontendController@agent')->name('agent');

//Service
Route::get('service/{slug}','FrontendController@showPortfolioByService')->name('portfolio.service');

//Portfolio Filter
Route::post('/portfolio/filter','FrontendController@portfolioFilter')->name('portfolio.filter');

//Portfolio
Route::get('/portfolio','FrontendController@portfolio')->name('portfolio');

//Pricing
Route::get('/pricing','FrontendController@pricing')->name('pricing');

//FAQ
Route::get('/faq','FrontendController@faq')->name('faq');

//Testimonial
Route::get('/testimonial','FrontendController@testimonial')->name('testimonial');

//Order
Route::get('/book/{slug}','FrontendController@order')->name('book');
//FAQ
Route::get('/faq','FrontendController@faq')->name('faq');

//Statistics
Route::get('/statistic','FrontendController@statistic')->name('statistic');

//Document
Route::get('/document','FrontendController@document')->name('document');

//Download
//Route for downloading a file using the id of the related student
Route::get('download/{id}', 'FrontendController@downloadFile')->name('document.download');

//Video
Route::get('/video','FrontendController@video')->name('video');

//Testimonials
Route::get('/testimonial','FrontendController@testimonial')->name('testimonial');

//Contact
Route::get('/contact','FrontendController@contact')->name('contact');
Route::post('/contact/store','MessageController@store')->name('contact.store');

// Order routes
Route::post('order', 'OrderController@store')->name('order');
Route::get('order/pdf/{id}', 'OrderController@pdf')->name('order.pdf');
Route::get('/book', 'OrderController@book')->name('book');

// Blog
Route::get('/blog','FrontendController@blog')->name('blog');
Route::get('/blog-detail/{slug}','FrontendController@blogDetail')->name('blog.detail');
Route::get('/blog-detail/lang/{locale}', 'FrontendController@bloglang');
Route::get('/blog/search','FrontendController@blogSearch')->name('blog.search');
Route::post('/blog/filter','FrontendController@blogFilter')->name('blog.filter');
Route::get('blog-cat/{slug}','FrontendController@blogByCategory')->name('blog.category');
Route::get('blog-tag/{slug}','FrontendController@blogByTag')->name('blog.tag');

// Post Comment 
Route::post('post/{slug}/comment','PostCommentController@store')->name('post-comment.store');
Route::resource('/comment','PostCommentController');

// NewsLetter
Route::post('/subscribe','FrontendController@subscribe')->name('subscribe');

//Destination
Route::get('/destination','FrontendController@destination')->name('destination');
Route::get('/destination-detail/{slug}','FrontendController@destinationDetail')->name('destination.detail');
Route::get('/destination-detail/lang/{locale}', 'FrontendController@destinationlang');
Route::match(['get', 'post'], '/search', 'FrontendController@destinationSearch')->name('destination.search');
Route::get('/destination-autocomplete', 'FrontendController@destinationAutocomplete')->name('destination.autocomplete');
Route::get('/destination/{slug}', 'FrontendController@show')->name('destination.show');
Route::post('/destination/filter','FrontendController@destinationFilter')->name('destination.filter');
Route::get('destination-cat/{slug}','FrontendController@destinationByCategory')->name('destination.category');
Route::get('destination-tag/{slug}','FrontendController@destinationByTag')->name('destination.tag');

//Tour
Route::get('/tour','FrontendController@tour')->name('tour');
Route::get('/tour-detail/{slug}','FrontendController@tourDetail')->name('tour.detail');
Route::get('/tour-detail/lang/{locale}', 'FrontendController@tourlang');
Route::post('/tour/search','FrontendController@tourSearch')->name('tour.search');
Route::post('/tour/filter','FrontendController@tourFilter')->name('tour.filter');
Route::get('tour-cat/{slug}','FrontendController@tourByCategory')->name('tour.category');
Route::get('tour-type/{slug}','FrontendController@tourByType')->name('tour.type');
Route::get('tour-tag/{slug}','FrontendController@tourByTag')->name('tour.tag');

//Gallery
Route::get('/gallery','FrontendController@gallery')->name('gallery');

//Order
Route::get('/book','FrontendController@book')->name('book');
Route::post('/book/message','BookController@store')->name('book.store');

// Backend section start

Route::group(['prefix'=>'/admin','middleware'=>['auth','admin']],function(){
    Route::get('/','AdminController@index')->name('admin');
    // user route
    Route::resource('users','UsersController');
    // Banner
    Route::resource('banner','BannerController');
    // Page Banner
    Route::resource('page-banner','PageBannerController');
     // Testimonial 
     Route::resource('testimonial','TestimonialController');
    // Team 
    Route::resource('team','TeamController');
    // Profile
    Route::get('/profile','AdminController@profile')->name('admin-profile');
    Route::post('/profile/{id}','AdminController@profileUpdate')->name('profile-update');
    // POST category
    Route::resource('/post-category','PostCategoryController');
    // Post tag
    Route::resource('/post-tag','PostTagController');
    // Post
    Route::resource('/post','PostController');
    // Message
    Route::resource('/message','MessageController');
    Route::get('/message/five','MessageController@messageFive')->name('messages.five');
    // Settings
    Route::get('settings','AdminController@settings')->name('settings');
    Route::post('setting/update','AdminController@settingsUpdate')->name('settings.update');
    // Notification
    Route::get('/notification/{id}','NotificationController@show')->name('admin.notification');
    Route::get('/notifications','NotificationController@index')->name('all.notification');
    Route::delete('/notification/{id}','NotificationController@delete')->name('notification.delete');
    // Password Change
    Route::get('change-password', 'AdminController@changePassword')->name('change.password.form');
    Route::post('change-password', 'AdminController@changPasswordStore')->name('change.password');
    // FAQ
    Route::resource('/faq','FAQController');
    // Service
    Route::resource('/service','ServiceController');
    // Portfolio
    Route::resource('/portfolio','PortfolioController');
    // Statistics
    Route::resource('/statistic','StatisticController');
    // Document 
    Route::resource('document','DocumentController');
    // Video 
    Route::resource('video','VideoController');
    // Destination
    Route::resource('/destination','DestinationController');
    // Deatrination tag
    Route::resource('/destination-tag','DestinationTagController');
    // Include tour
    Route::resource('/include-tour','IncludeController');
    // Exclude tour
    Route::resource('/exclude-tour','ExcludeController');
    // Tour
    Route::resource('/tour','TourController');
    // Tour tag
    Route::resource('/tour-tag','TourTagController');
    // Order
    Route::resource('/order','OrderController');
    // Category
    Route::resource('/category','CategoryController');
    // Location Category
    Route::resource('/location-category','LocationCategoryController');
});

// Global Search Routes
Route::get('/search', 'FrontendController@searchAll')->name('search.all');
Route::get('/global-autocomplete', 'FrontendController@globalAutocomplete')->name('global.autocomplete');

Route::get('lang/{locale}', 'HomeController@lang');
Route::get('lang/{locale}', 'FrontendController@lang');