@extends('frontend.layouts.master2')
@section('title') Video @endsection
@section('main-content')
@include('frontend.layouts.notification')

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" @if(isset($banner) && $banner && $banner->banner_image) data-background="{{ asset('storage/' . $banner->banner_image) }}" @else data-background="{{ asset('frontend/assets/images/bg/breadcrumb-bg.png') }}" @endif></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">Video </h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Home</a></span>
                                    <span>Video </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- tour-grid area start -->
    <section class="bd-tour-grid-area section-space">
        <div class="container">
            <div class="row gy-24">
                @if($videos)
                        @foreach($videos as $video)
                        <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6">
                            <div class="tour-wrapper style-one">
                                <div class="p-relative">
                                    <iframe width="310" height="300" 
                                    src="{{$video->link}}" 
                                    title="{{$video->title}}" 
                                    frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
                                    allowfullscreen></iframe>
                                </div>
                                <div class="tour-content">
                                    <h5 class="tour-title fw-5 underline mb-5">
                                        <a>
                                            {{$video->title}}
                                        </a>
                                    </h5>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
    <!-- tour-grid area end -->

</main>
<!-- Body main wrapper end -->

@endsection

