@extends('frontend.layouts.master2')
@section('meta')
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name='copyright' content=''>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="keywords" content="">
	{{-- <meta name="description" content="{{$post->summary}}"> --}}
	{{-- <meta property="og:url" content="{{route('blog-detail',$post->slug)}}"> --}}
	<meta property="og:type" content="article">
	<meta property="og:title" content="{{$tour->title}}">
	<meta property="og:image" content="{{$tour->photo}}">
	<meta property="og:description" content="{{$tour->description}}">
@endsection
@section('title') {{$tour->title}} @endsection
@section('main-content')
@include('frontend.layouts.notification')

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" @if(isset($tour->tour_tag_info->banner) && $tour->tour_tag_info->banner) data-background="{{ Storage::url($tour->tour_tag_info->banner) }}" @else data-background="{{ asset('frontend/assets/images/tours_page.jpg') }}" @endif></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">{{$tour->title}}</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Home</a></span>
                                    <span>Tour</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- blog-details area start -->
    <section class="bd-tour-details-area section-space">
        <div class="container">
            <div class="row gy-24">
                <div class="col-xxl-8 col-xl-8 col-lg-7">
                    <div class="tour-details-wrapper">
                        <div class="tour-details mb-25">
                            <div class="tour-details-thumb details-slide-full mb-30">
                                @php
                                    $photo=explode(',',$tour->photo);
                                @endphp
                                <img src="{{ Storage::url($tour->photo) }}" class="img-responsive"  alt="" />
                            </div>
                            <div class="tour-details-content">
                                <div class="tour-details-badge d-flex gap--5 mb-10">
                                    <span class="bd-badge warning fw-5">Discount</span>
                                    <span class="bd-badge danger fw-5">{{$tour->discount}}</span>
                                </div>
                                <h3 class="tour-details-title mb-15">{{$tour->title}}</h3>
                                <div class="tour-details-meta d-flex flex-wrap gap-10 align-items-center justify-content-between mb-20">
                                    <div class="tour-details-price">
                                        <h4 class="price-title">${{$tour->price}}<span>/Per Person</span></h4>
                                    </div>
                                    <div class="tour-details-price">
                                        <h4 class="price-title">${{$tour->price_per_child}}<span>/Per Child</span></h4>
                                    </div>
                                </div>
                                <div class="tour-details-destination-wrapper">
                                    <div class="tour-details-destination-info">
                                        <div class="search-icon-bg is-big">
                                            <span><i class="fa-light fa-clock"></i></span>
                                        </div>
                                        <div class="tour-details-destination-info-title">
                                            <p class="tour-details-destination-info-top mb-0">Duration</p>
                                            <span class="tour-details-destination-info-bottom small">{{$tour->number_of_days}} Day(s)
                                            </span>
                                        </div>
                                    </div>
                                    <div class="tour-details-destination-info">
                                        <div class="search-icon-bg is-big">
                                            <span><i class="icon-hourglass"></i></span>
                                        </div>
                                        <div class="tour-details-destination-info-title">
                                            <p class="tour-details-destination-info-top mb-0">Min Age</p>
                                            <span class="tour-details-destination-info-bottom small">{{$tour->age}}</span>
                                        </div>
                                    </div>
                                    <div class="tour-details-destination-info">
                                        <div class="search-icon-bg is-big">
                                            <span><i class="fa-sharp fa-light fa-moped"></i></span>
                                        </div>
                                        <div class="tour-details-destination-info-title">
                                            <p class="tour-details-destination-info-top mb-0">Tour Type</p>
                                            <span class="tour-details-destination-info-bottom small">{{$tour->tags}}</span>
                                        </div>
                                    </div>
                                    <div class="tour-details-destination-info">
                                        <div class="search-icon-bg is-big">
                                            <span><i class="fa-light fa-location-dot"></i></span>
                                        </div>
                                        <div class="tour-details-destination-info-title">
                                            <p class="tour-details-destination-info-top mb-0">Location</p>
                                            <span class="tour-details-destination-info-bottom">{{$tour->location}}</span>
                                        </div>
                                    </div>
                                </div>

                                <p class="mb-15">{!!$tour->description!!}</p>

                                <div class="tour-details-list-wrap mb-35">
                                    <h4 class="mb-20">Include/ Exclude</h4>
                                    <div class="tour-details-list-box">
                                        <div class="tour-details-list-include">
                                            <ul>
                                                @if($tour->includes)
                                                    @foreach(explode(',', $tour->includes) as $include)
                                                        <li>
                                                            <span class="list-icon success"><i class="fa-solid fa-check"></i></span>
                                                            {{$include}}
                                                        </li>
                                                    @endforeach
                                                @endif
                                            </ul>
                                        </div>
                                        <div class="tour-details-list-exclude">
                                            <ul>
                                                @if($tour->excludes)
                                                    @foreach(explode(',', $tour->excludes) as $exclude)
                                                        <li>
                                                            <span class="list-icon danger"><i class="fa-regular fa-xmark"></i></span>
                                                            {{$exclude}}
                                                        </li>
                                                    @endforeach
                                                @endif
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="tour-details-faq mb-35">
                                    <h4 class="mb-20">Tour Plan</h4>
                                    <div class="accordion-wrapper faq-style-3">
                                        <div class="accordion" id="accordionExampleThree">
                                            <div class="accordion-item">
                                                @for ($z = 0; $z < count(json_decode($tour->itinerary_titles)); $z++)
                                                    <h6 class="accordion-header" id="headingNine">
                                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine" aria-expanded="true" aria-controls="collapseNine">
                                                            <span>{!! json_decode($tour->itinerary_titles)[$z] !!}</span> </button>
                                                    </h6>
                                                    <div id="collapseNine" class="accordion-collapse collapse show" aria-labelledby="headingNine" data-bs-parent="#accordionExampleThree">
                                                        <div class="accordion-body">
                                                            <div class="accordion-body-list">
                                                                <ul>
                                                                    <li>{!! json_decode($tour->itinerary_descriptions)[$z] !!}</li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endfor
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="tour-details-gallery mb-35">
                                    <h4 class="mb-20">Tour Galley</h4>
                                    <div class="row gy-24">
                                        @if ($tour->images)
                                            @php
                                                $imageArray = explode(',', $tour->images);
                                            @endphp
                                            @foreach($imageArray as $index => $image)
                                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 {{$tour->id}}">
                                                    <div class="tour-details-gallery-thumb image-hover-effect-two position-relative">
                                                        <img src="{{ Storage::url($image) }}" alt="image">
                                                    </div>
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>
                                </div>
                                <div class="tour-details-location mb-35">
                                    <h4 class="mb-20">Tour Location</h4>
                                    <div class="tour-details-location-map">
                                        <iframe src="{{ $tour->map }}" 
                                            width="800" height="600" style="border:0;" 
                                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
                                        </iframe>                                        
                                    </div>
                                </div>                                                               
                                
                                <div class="tour-details-related-tour mb-35">
                                    <h4 class="mb-20">Related Tour</h4>
                                    <div class="row gy-24">
                                        @foreach($recent_tours as $tour)
                                            <div class="col-xxl-4 col-xl-4 col-md-6">
                                                <div class="tour-wrapper style-one">
                                                    <div class="p-relative">
                                                        <div class="tour-thumb image-overly">
                                                            <a href="{{route('tour.detail',$tour->slug)}}">
                                                                @php
                                                                    $photo=explode(',',$tour->photo);
                                                                @endphp
                                                            <img src="{{ Storage::url($tour->photo) }}" class="img-responsive"  alt="{{ Storage::url($tour->photo) }}" />
                                                            </a>
                                                        </div>
                                                        <div class="tour-meta d-flex align-items-center justify-content-between">
                                                            <div class="tour-location">
                                                                <span>
                                                                    <a href="{{route('tour.detail',$tour->slug)}}">
                                                                        <i class="fa-regular fa-location-dot"></i> {{$tour->location}}
                                                                    </a>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="tour-content">
                                                        <h5 class="tour-title fw-5 underline mb-5">
                                                            <a href="{{route('tour.detail',$tour->slug)}}">
                                                                {{$tour->title}}
                                                            </a>
                                                        </h5>
                                                        <span class="tour-price b3">${{$tour->price}} per Person</span>
                                                        <div class="tour-divider"></div>
                                                        <p>{{$tour->tags}} </p>
                                                        <div class="tour-divider"></div>
                    
                                                        <div class="tour-meta d-flex align-items-center justify-content-between">
                                                            <div class="time d-flex align-items-center gap--5">
                                                                {{-- <i class="icon-heart"></i> --}}
                                                                <span>{{$tour->number_of_days}} days</span>
                                                            </div>
                                                            <div class="tour-btn">
                                                                <a class="bd-text-btn style-two" href="{{route('tour.detail',$tour->slug)}}" >Book Now
                                                                    <span class="icon__box">
                                                                        <i class="fa-regular fa-arrow-right-long icon__first"></i>
                                                                        <i class="fa-regular fa-arrow-right-long icon__second"></i>
                                                                    </span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-5">
                    <aside class="sidebar-wrapper sidebar-sticky">
                        <div class="sidebar-widget-wrapper mb-30">
                            <div class="sidebar-widget widget">
                                <h6 class="sidebar-widget-title small mb-15">Search Here</h6>
                                <div class="sidebar-search">
                                    <form class="sidebar-search-form" action="#" method="get">
                                        <input type="text" value="" required="" name="s" placeholder="Search">
                                        <button type="submit"> <i class="far fa-search"></i> </button>
                                    </form>
                                </div>
                            </div>
                            <div class="sidebar-widget-divider"></div>
                            <div class="sidebar-widget widget">
                                <h6 class="sidebar-widget-title small mb-15">Recent Tour List</h6>
                                <div class="sidebar-widget-post">
                                    @foreach($recent_tours as $tour)
                                        <div class="recent-post">
                                            <div class="recent-post-thumb mr-10">
                                                <a href="{{route('tour.detail',$tour->slug)}}">
                                                    @php
                                                        $photo=explode(',',$tour->photo);
                                                    @endphp
                                                    <img src="{{ Storage::url($tour->photo) }}" class="img-responsive"  alt="{{ Storage::url($tour->photo) }}" />
                                                </a>
                                            </div>
                                            <div class="recent-post-content">
                                                <h6 class="recent-post-title small underline">
                                                    <a href="{{route('tour.detail',$tour->slug)}}">{{$tour->title}}</a>
                                                </h6>
                                                <span class="recent-post-price">${{$tour->price}}</span>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <div class="sidebar-widget-banner p-relative">
                            <div class="sidebar-widget-thumb p-relative">
                                <img src="{{ asset('frontend/assets/images/bg/sidebar-img.png') }}" alt="img">
                            </div>
                            <div class="sidebar-widget-content">
                                <span class="bd-play-btn pulse-white mb-40"><i class="icon-call-ring"></i></span>
                                <p class="b3 mb-0">Free Call</p>
                                <h5 class="mb-25"> <a href="https://wa.me/+256788117307?text=Hello I have a question">+256788117307</a></h5>
                                <div class="sidebar-btn">
                                    <a class="bd-text-btn style-two" href="{{route('contact')}}">Contact
                                        <span class="icon__box">
                                            <i class="fa-light fa-angle-right icon__first"></i>
                                            <i class="fa-light fa-angle-right icon__second"></i>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
    <!-- blog-details area end -->

</main>
<!-- Body main wrapper end -->


@endsection