@extends('frontend.layouts.master2')
@section('title') Testimonials @endsection
@section('main-content')

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" @if(isset($banner) && $banner && $banner->banner_image) data-background="{{ Storage::url($banner->banner_image) }}" @else data-background="{{ asset('frontend/assets/images/bg/breadcrumb-bg.png') }}" @endif></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">Testimonials</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Home</a></span>
                                    <span>Testimonials</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- team-area area start -->
    <section class="bd-team-area section-space">
        <div class="container">
            <div class="row gy-24">
                @if($testimonials)
					@foreach($testimonials as $testimonial)
                        <div class="col-xxl-3 col-xl-3 col-lg-4">
                            <div class="team-wrapper team-style-two">
                                <div class="team-content-wrap position-relative">
                                    <div class="team-thumb-wrap">
                                        <div class="team-thumb image-overly radius-8">
                                            <a>
                                                @php
                                                    $photo=explode(',',$testimonial->photo);
                                                @endphp
                                                <img src="{{ Storage::url($testimonial->photo) }}" alt="{{ Storage::url($testimonial->photo) }}">
                                            </a>
                                        </div>
                                        {{-- <div class="theme-social team-social has-white-bg">
                                            <a class="icon-1" target="_blank" href="https://www.facebook.com/"><i class="icon-facebook"></i></a>
                                            <a class="icon-2" target="_blank" href="https://twitter.com/"><i class="icon-twitter-x"></i></a>
                                            <a class="icon-3" target="_blank" href="https://www.instagram.com/"><i class="icon-instagram"></i></a>
                                            <a class="icon-4" target="_blank" href="https://bd.linkedin.com/"><i class="icon-linkedin"></i></a>
                                        </div> --}}
                                    </div>
                                    <div class="team-content">
                                        <h6 class="team-member-name b3 underline"><a>{{$testimonial->name}}</a></h6>
                                        <span>{{$testimonial->position}}</span>
                                        <p>{!!$testimonial->message!!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
    <!-- team-area area end -->

</main>
<!-- Body main wrapper end -->

@endsection