@extends('frontend.layouts.master')
@section('title') Search Results - {{ $query }} @endsection
@section('main-content')

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" @if(isset($banner) && $banner && $banner->banner_image) data-background="{{ Storage::url($banner->banner_image) }}" @else data-background="{{ asset('frontend/assets/images/updates_page.jpg') }}" @endif></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">Search Results</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Home</a></span>
                                    <span>Search Results for "{{ $query }}"</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- search results area start -->
    <section class="bd-search-results-area section-space">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="search-results-header mb-40">
                        <h2 class="search-results-title">
                            @if(isset($results['total']) && $results['total'] > 0)
                                Found {{ $results['total'] }} result(s) for "{{ $query }}"
                            @else
                                No results found for "{{ $query }}"
                            @endif
                        </h2>
                        
                        <!-- Search Form -->
                        <div class="search-form-wrapper mb-30">
                            <form action="{{ route('search.all') }}" method="GET" class="search-form">
                                <div class="search-input-group">
                                    <input type="text" name="q" placeholder="Search tours, destinations, articles..." value="{{ $query }}" class="form-control">
                                    <button type="submit" class="search-btn">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            @if(isset($results['total']) && $results['total'] > 0)
            <div class="row gy-24">
                <!-- Tours Section -->
                @if($results['tours']->count() > 0)
                <div class="col-12">
                    <div class="search-section">
                        <h3 class="search-section-title">
                            <i class="fa-solid fa-map-marked-alt me-2"></i>
                            Tours ({{ $results['tours']->count() }})
                        </h3>
                        <div class="row gy-24">
                            @foreach($results['tours'] as $tour)
                            <div class="col-lg-4 col-md-6">
                                <div class="search-result-card">
                                    <div class="search-result-image">
                                        <a href="{{ $tour['url'] }}">
                                            <img src="{{ Storage::url($tour['photo']) }}" alt="{{ $tour['title'] }}">
                                        </a>
                                        <div class="search-result-type">
                                            <span class="type-badge tour-badge">Tour</span>
                                        </div>
                                    </div>
                                    <div class="search-result-content">
                                        <h4 class="search-result-title">
                                            <a href="{{ $tour['url'] }}">{{ $tour['title'] }}</a>
                                        </h4>
                                        <p class="search-result-location">
                                            <i class="fa-solid fa-location-dot me-1"></i>
                                            {{ $tour['location'] }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endif

                <!-- Destinations Section -->
                @if($results['destinations']->count() > 0)
                <div class="col-12">
                    <div class="search-section">
                        <h3 class="search-section-title">
                            <i class="fa-solid fa-mountain me-2"></i>
                            Destinations ({{ $results['destinations']->count() }})
                        </h3>
                        <div class="row gy-24">
                            @foreach($results['destinations'] as $destination)
                            <div class="col-lg-4 col-md-6">
                                <div class="search-result-card">
                                    <div class="search-result-image">
                                        <a href="{{ $destination['url'] }}">
                                            <img src="{{ Storage::url($destination['photo']) }}" alt="{{ $destination['title'] }}">
                                        </a>
                                        <div class="search-result-type">
                                            <span class="type-badge destination-badge">Destination</span>
                                        </div>
                                    </div>
                                    <div class="search-result-content">
                                        <h4 class="search-result-title">
                                            <a href="{{ $destination['url'] }}">{{ $destination['title'] }}</a>
                                        </h4>
                                        <p class="search-result-location">
                                            <i class="fa-solid fa-location-dot me-1"></i>
                                            {{ $destination['location'] }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endif

                <!-- Articles Section -->
                @if($results['posts']->count() > 0)
                <div class="col-12">
                    <div class="search-section">
                        <h3 class="search-section-title">
                            <i class="fa-solid fa-newspaper me-2"></i>
                            Articles ({{ $results['posts']->count() }})
                        </h3>
                        <div class="row gy-24">
                            @foreach($results['posts'] as $post)
                            <div class="col-lg-4 col-md-6">
                                <div class="search-result-card">
                                    <div class="search-result-image">
                                        <a href="{{ $post['url'] }}">
                                            <img src="{{ Storage::url($post['photo']) }}" alt="{{ $post['title'] }}">
                                        </a>
                                        <div class="search-result-type">
                                            <span class="type-badge article-badge">Article</span>
                                        </div>
                                    </div>
                                    <div class="search-result-content">
                                        <h4 class="search-result-title">
                                            <a href="{{ $post['url'] }}">{{ $post['title'] }}</a>
                                        </h4>
                                        @if($post['quote'])
                                        <p class="search-result-quote">{{ Str::limit($post['quote'], 100) }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endif
            </div>
            @else
            <!-- No Results -->
            <div class="row">
                <div class="col-12">
                    <div class="no-results text-center">
                        <div class="no-results-icon mb-30">
                            <i class="fa-solid fa-search"></i>
                        </div>
                        <h3 class="no-results-title">No results found</h3>
                        <p class="no-results-text">
                            We couldn't find any tours, destinations, or articles matching "{{ $query }}".
                            <br>Try different keywords or check your spelling.
                        </p>
                        <div class="no-results-suggestions">
                            <h4>Try searching for:</h4>
                            <ul>
                                <li>Popular destinations like "Zanzibar", "Serengeti", "Kilimanjaro"</li>
                                <li>Tour types like "Safari", "Beach", "Cultural"</li>
                                <li>Activities like "Wildlife", "Photography", "Adventure"</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </section>
    <!-- search results area end -->

</main>
<!-- Body main wrapper end -->

@endsection

@push('styles')
<style>
/* Search Results Styles */
.search-results-header {
    text-align: center;
    padding: 40px 0;
}

.search-results-title {
    font-size: 28px;
    font-weight: 600;
    color: #333;
    margin-bottom: 20px;
}

.search-form-wrapper {
    max-width: 600px;
    margin: 0 auto;
}

.search-input-group {
    position: relative;
    display: flex;
    background: #fff;
    border-radius: 50px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    overflow: hidden;
}

.search-input-group .form-control {
    border: none;
    padding: 15px 25px;
    font-size: 16px;
    background: transparent;
    flex: 1;
}

.search-input-group .form-control:focus {
    box-shadow: none;
    outline: none;
}

.search-btn {
    background: #007bff;
    border: none;
    color: white;
    padding: 15px 25px;
    cursor: pointer;
    transition: background 0.3s ease;
}

.search-btn:hover {
    background: #0056b3;
}

.search-section {
    margin-bottom: 50px;
}

.search-section-title {
    font-size: 24px;
    font-weight: 600;
    color: #333;
    margin-bottom: 30px;
    padding-bottom: 10px;
    border-bottom: 2px solid #007bff;
}

.search-result-card {
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    height: 100%;
}

.search-result-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(0,0,0,0.12);
}

.search-result-image {
    position: relative;
    height: 200px;
    overflow: hidden;
}

.search-result-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.search-result-card:hover .search-result-image img {
    transform: scale(1.05);
}

.search-result-type {
    position: absolute;
    top: 15px;
    right: 15px;
}

.type-badge {
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.tour-badge {
    background: #28a745;
    color: white;
}

.destination-badge {
    background: #007bff;
    color: white;
}

.article-badge {
    background: #6f42c1;
    color: white;
}

.search-result-content {
    padding: 20px;
}

.search-result-title {
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 10px;
}

.search-result-title a {
    color: #333;
    text-decoration: none;
    transition: color 0.3s ease;
}

.search-result-title a:hover {
    color: #007bff;
}

.search-result-location {
    color: #666;
    font-size: 14px;
    margin: 0;
}

.search-result-quote {
    color: #666;
    font-size: 14px;
    font-style: italic;
    margin: 10px 0 0 0;
}

/* No Results Styles */
.no-results {
    padding: 80px 20px;
}

.no-results-icon {
    font-size: 80px;
    color: #ddd;
}

.no-results-title {
    font-size: 28px;
    font-weight: 600;
    color: #333;
    margin-bottom: 15px;
}

.no-results-text {
    font-size: 16px;
    color: #666;
    margin-bottom: 30px;
}

.no-results-suggestions {
    background: #f8f9fa;
    padding: 30px;
    border-radius: 10px;
    text-align: left;
    max-width: 600px;
    margin: 0 auto;
}

.no-results-suggestions h4 {
    color: #333;
    margin-bottom: 15px;
}

.no-results-suggestions ul {
    list-style: none;
    padding: 0;
}

.no-results-suggestions li {
    padding: 5px 0;
    color: #666;
}

.no-results-suggestions li:before {
    content: "•";
    color: #007bff;
    font-weight: bold;
    margin-right: 10px;
}

/* Responsive */
@media (max-width: 768px) {
    .search-results-title {
        font-size: 24px;
    }
    
    .search-section-title {
        font-size: 20px;
    }
    
    .search-input-group .form-control {
        padding: 12px 20px;
        font-size: 14px;
    }
    
    .search-btn {
        padding: 12px 20px;
    }
    
    .search-result-content {
        padding: 15px;
    }
    
    .search-result-title {
        font-size: 16px;
    }
}
</style>
@endpush
