@extends('frontend.layouts.master2')
@section('meta')
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name='copyright' content=''>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="keywords" content="">
	{{-- <meta name="description" content="{{$post->summary}}"> --}}
	{{-- <meta property="og:url" content="{{route('blog-detail',$post->slug)}}"> --}}
	<meta property="og:type" content="article">
	<meta property="og:title" content="{{$destination->title}}">
	<meta property="og:image" content="{{$destination->photo}}">
	<meta property="og:description" content="{{$destination->description}}">
@endsection
@section('title') {{$destination->title}} @endsection
@section('main-content')
@include('frontend.layouts.notification')

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
            <div class="bd-breadcrumb-bg" @if(isset($location_category->banner) && $location_category->banner) data-background="{{ Storage::url($location_category->banner) }}" @else data-background="{{ asset('frontend/assets/images/destinations_page.jpg') }}" @endif></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">{{$destination->title}}</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Home</a></span>
                                    <span>{{$destination->title}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- destinations-details area start -->
    <section class="bd-destinations-details-area section-space">
        <div class="container">
            <div class="row gy-24 justify-content-center">
                <div class="col-xxl-8 col-xl-8 col-lg-10">
                    <div class="destinations-details-wrapper">
                        <div class="destinations-details mb-25">
                            <div class="destinations-details-slider details-slide p-relative mb-30">
                                <div class="swiper details-slide-activation">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            @php
                                                $photo=explode(',',$destination->photo);
                                            @endphp
                                            <img src="{{ Storage::url($destination->photo) }}" class="img-responsive"  alt="{{ Storage::url($destination->photo) }}" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="destinations-details-content">
                                <h3 class="destinations-details-title mb-15">{{$destination->title}}
                                </h3>
                                {{-- <p class="mb-15">{!!$destination->description!!}</p> --}}
                                <div class="tour-details-list-box mb-35">
                                    <div class="tour-details-list-include">
                                        <ul>
                                            <li>
                                                <span class="list-icon has-big secondary">
                                                    <i class="icon-flag"></i>
                                                </span>
                                                Country: {{$destination->country}}
                                            </li>
                                            <li>
                                                <span class="list-icon has-big secondary">
                                                    <i class="icon-flag"></i>
                                                </span>
                                                Location: {{$destination->location}}
                                            </li>
                                            <li>
                                                <span class="list-icon has-big secondary">
                                                    <i class="icon-globe"></i>
                                                </span>
                                                                Language Spoken: {{$destination->language}}
                                            </li>
                                            
                                        </ul>
                                    </div>
                                    <div class="tour-details-list-exclude">
                                        <ul>
                                            
                                            <li>
                                                <span class="list-icon has-big secondary">
                                                    <i class="fa-light fa-location-dot"></i>
                                                </span>
                                                Area (Km): {{$destination->area}}
                                            </li>
                                            <li>
                                                <span class="list-icon has-big secondary">
                                                    <i class="icon-doc"></i>
                                                </span>
                                                Visa Requirement: {{$destination->visa}}
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="post-details-blockquote mb-30">
                                    <!--<blockquote>-->
                                        <h4 class="blockquote-title">{!!$destination->summary!!}</h4>
                                    <!--</blockquote>-->
                                </div>
                                <p>{!!$destination->description!!}</p>
                                
                                <!-- Pros and Cons Section -->
                                @if($destination->pros || $destination->cons)
                                <div class="destinations-pros-cons mb-40">
                                    <div class="pros-cons-toggle-header">
                                        <h3 class="pros-cons-main-title">
                                            <i class="fa-solid fa-balance-scale me-2"></i>
                                            Pros & Cons
                                        </h3>
                                        <button class="pros-cons-toggle-btn" onclick="toggleProsCons()">
                                            <span class="toggle-text">Show Details</span>
                                            <i class="fa-solid fa-chevron-down toggle-icon"></i>
                                        </button>
                                    </div>
                                    
                                    <div class="pros-cons-content-wrapper" id="prosConsContent" style="display: none;">
                                        <div class="row gy-24">
                                            @if($destination->pros && count($destination->pros) > 0)
                                            <div class="col-md-6">
                                                <div class="pros-cons-card pros-card">
                                                    <div class="pros-cons-header">
                                                        <h4 class="pros-cons-title">
                                                            <i class="fa-solid fa-check-circle text-success me-2"></i>
                                                            Pros
                                                        </h4>
                                                    </div>
                                                    <div class="pros-cons-content">
                                                        <ul class="pros-cons-list">
                                                            @foreach($destination->pros as $pro)
                                                                @if(!empty(trim($pro)))
                                                                <li>
                                                                    <i class="fa-solid fa-plus text-success me-2"></i>
                                                                    {{ trim($pro) }}
                                                                </li>
                                                                @endif
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                            
                                            @if($destination->cons && count($destination->cons) > 0)
                                            <div class="col-md-6">
                                                <div class="pros-cons-card cons-card">
                                                    <div class="pros-cons-header">
                                                        <h4 class="pros-cons-title">
                                                            <i class="fa-solid fa-times-circle text-danger me-2"></i>
                                                            Cons
                                                        </h4>
                                                    </div>
                                                    <div class="pros-cons-content">
                                                        <ul class="pros-cons-list">
                                                            @foreach($destination->cons as $con)
                                                                @if(!empty(trim($con)))
                                                                <li>
                                                                    <i class="fa-solid fa-minus text-danger me-2"></i>
                                                                    {{ trim($con) }}
                                                                </li>
                                                                @endif
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @endif
                                
                                {{-- <div class="destinations-details-gallery">
                                    <div class="row gy-24">
                                        @if ($destination->images)
                                            @php
                                                $imageArray = explode(',', $destination->images);
                                            @endphp
                                            @foreach($imageArray as $index => $image)
                                                <div class="col-md-6">
                                                    <div class="destinations-details-thumb image-hover-effect-two position-relative">
                                                        <img src="{{ Storage::url($image) }}" alt="{{ Storage::url($image) }}">
                                                    </div>
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>
                                </div> --}}
                                <div class="destinations-details-slider details-slide p-relative mb-30">
                                    <div class="swiper details-slide-activation">
                                        @if ($destination->images)
                                        <div class="swiper-wrapper">
                                        @php
                                            $imageArray = explode(',', $destination->images);
                                        @endphp
                                        @foreach($imageArray as $index => $image)  
                                            <div class="swiper-slide">
                                                <img src="{{ Storage::url($image) }}" alt="{{ Storage::url($image) }}">
                                            </div>
                                        @endforeach
                                        </div>
                                    @endif                                        
                                    </div>
                                    <div class="details-slide-navigation btn-navigation">
                                        <button class="tourigo-navigation-prev"><i class="fa-regular fa-angle-left"></i></button>
                                        <button class="tourigo-navigation-next"><i class="fa-regular fa-angle-right"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="section-divider mt-30 mb-25"></div>
                            <div class="destinations-details-tag d-flex flex-wrap gap-10 align-items-center justify-content-between">
                                {{-- <div class="tagcloud">
                                    @php
                                        $tags = explode(',', $destination->tags);
                                    @endphp
                                    @foreach($tags as $tag)
                                        <a href="{{ route('destination.tag', $tag) }}" class="tag-cloud-link">{{ $tag }}</a>
                                    @endforeach
                                </div> --}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- destinations-details area end -->

</main>
<!-- Body main wrapper end -->

@endsection

@push('scripts')
<script>
function toggleProsCons() {
    const content = document.getElementById('prosConsContent');
    const toggleBtn = document.querySelector('.pros-cons-toggle-btn');
    const toggleText = toggleBtn.querySelector('.toggle-text');
    const toggleIcon = toggleBtn.querySelector('.toggle-icon');
    
    if (content.style.display === 'none' || content.style.display === '') {
        content.style.display = 'block';
        toggleText.textContent = 'Hide Details';
        toggleIcon.classList.remove('fa-chevron-down');
        toggleIcon.classList.add('fa-chevron-up');
        
        // Smooth scroll to content
        setTimeout(() => {
            content.scrollIntoView({ 
                behavior: 'smooth', 
                block: 'start',
                inline: 'nearest'
            });
        }, 100);
    } else {
        content.style.display = 'none';
        toggleText.textContent = 'Show Details';
        toggleIcon.classList.remove('fa-chevron-up');
        toggleIcon.classList.add('fa-chevron-down');
    }
}
</script>
@endpush