@extends('frontend.layouts.master2')
@section('title') Confirm Booking @endsection
@section('main-content')
@include('frontend.layouts.notification')


<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" data-background="{{ asset('frontend/assets/images/bg/breadcrumb-bg.png') }}"></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">Booking Confirmation</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Tembea Horizons</a></span>
                                    <span>Booking</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- booking-confirm-area area start -->
    <section class="booking-confirm-area section-space">
        <div class="container">
            <div class="row gx-0 justify-content-center">
                <div class="col-xxl-10 col-xl-10 col-lg-10 col-md-12">
                    <div class="order-inner">
                        <div class="order-details mb-35">
                            <div class="order-details-top text-center mb-70">
                                <div class="order-details-icon">
                                    <span>
                          <svg class="line-dash" width="52" height="52" viewBox="0 0 52 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                             <path d="M46 26V51H6V26" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                             <path d="M51 13.5H1V26H51V13.5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                             <path d="M26 51V13.5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                             <path d="M26 13.5H14.75C13.0924 13.5 11.5027 12.8415 10.3306 11.6694C9.15848 10.4973 8.5 8.9076 8.5 7.25C8.5 5.5924 9.15848 4.00269 10.3306 2.83058C11.5027 1.65848 13.0924 1 14.75 1C23.5 1 26 13.5 26 13.5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                             <path d="M26 13.5H37.25C38.9076 13.5 40.4973 12.8415 41.6694 11.6694C42.8415 10.4973 43.5 8.9076 43.5 7.25C43.5 5.5924 42.8415 4.00269 41.6694 2.83058C40.4973 1.65848 38.9076 1 37.25 1C28.5 1 26 13.5 26 13.5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                          </svg>
                       </span>
                                </div>
                                <div class="order-details-content">
                                    <h3 class="order-details-title mb-15">Booking Confirmation</h3>
                                    <p>We're thrilled to confirm your booking! Once your reservation is processed, we'll send you a confirmation email containing all the essential information regarding your booking.</p>
                                    <p>Thank you for selecting our services. Your trust and support mean the world to us.</p>
                                </div>
                            </div>
                            <div class="booking-details-item-wrapper">
                                <div class="row justify-content-start gy-24">
                                    <div class="col-xl-3 col-lg-6 col-sm-6">
                                        <div class="order-details-item">
                                            <h4>Start Date:</h4>
                                            <p>{{$order->date_arrival->format('d M , Y. D')}}</p>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-6 col-sm-6">
                                        <div class="order-details-item">
                                            <h4>End Date: </h4>
                                            <p>{{$order->date_arrival->addDays($order->total_stay)->format('d M , Y. D')}}</p>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-6 col-sm-6">
                                        <div class="order-details-item">
                                            <h4>Booking ID:</h4>
                                            <p>#{{$order->id}}</p>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-6 col-sm-6">
                                        <div class="order-details-item">
                                            <h4>Payment Method:</h4>
                                            <p>Bank</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="order-info-wrapper">
                            <h4 class="order-info-title">Booking Details</h4>
                            <div class="booking-sidebar-widget-wrapper">
                                <div class="booking-sidebar-price-wrapper">
                                    <h6 class="booking-sidebar-price-title small mb-15">{{$order->tour->title}}</h6>
                                        & Sea</h6>
                                    <div class="booking-sidebar-price-content">
                                        <div class="booking-sidebar-price-item d-flex flex-wrap justify-content-between">
                                            <div class="booking-sidebar-price-item-title">{{$order->number_adult}} 𝗑 Adult (age 7-99)</div>
                                            <div class="booking-sidebar-price-item-amount">${{$order->tour->price * $order->number_adult}}</div>
                                        </div>
                                        <div class="booking-sidebar-price-item d-flex flex-wrap justify-content-between">
                                            <div class="booking-sidebar-price-item-title">{{$order->number_child}} 𝗑 Infant (age 0-6)</div>
                                            <div class="booking-sidebar-price-item-amount">${{$order->tour->price_per_child * $order->number_child}}</div>
                                        </div>
                                        <div class="booking-sidebar-price-total d-flex flex-wrap justify-content-between">
                                            <div class="booking-sidebar-price-item-title b3 fw-7">Total price</div>
                                            <div class="booking-sidebar-price-item-amount b3 fw-7">${{($order->tour->price * $order->number_adult) + ($order->tour->price_per_child * $order->number_child)}}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- booking-confirm-area area end -->

</main>
<!-- Body main wrapper end -->



@endsection