@extends('frontend.layouts.master2')
@section('title') {{ __('Updates') }} @endsection
@section('main-content')

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" @if(isset($banner) && $banner && $banner->banner_image) data-background="{{Storage::url($banner->banner_image) }}" @else data-background="{{ asset('frontend/assets/images/articles_page.jpg') }}" @endif></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">Updates </h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Home</a></span>
                                    <span>Updates </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->
        <!-- blog area start -->
        <section class="bd-blog-area section-space">
            <div class="container">
                <div class="row gy-24 align-items-center justify-content-between section-title-space">
                    
                </div>
                <div class="swiper blog_activation">
                    <div class="swiper-wrapper">
                        @if($posts->isNotEmpty())
                            @foreach($posts as $post)
                        <div class="swiper-slide">
                            <article class="bd-blog-wrapper blog-default blog-style-three">
                                <div class="blog-thumb image-hover-effect">
                                    <a href="{{route('blog.detail',$post->slug)}}"><img src="{{ Storage::url($post->photo) }}" alt="img"></a>
                                </div>
                                <div class="blog-tag">
                                    @php
                                        $tags = explode(',', $post->tags);
                                    @endphp
                                    @foreach($tags as $tag)
                                        <span><a href="{{route('blog.detail',$post->slug)}}">{{$tag}}</a></span>
                                    @endforeach
                                </div>
                                <div class="blog-content">
                                    <div class="blog-meta-list">
                                       
                                        <div class="blog-meta-item">
                                            <span class="meta-icon">
                                                <i class="icon-cleander-check"></i>
                                            </span>
                                            <span class="meta-text"><a href="{{route('blog.detail',$post->slug)}}">{{$post->created_at->format('d M , Y. D')}}</a></span>
                                        </div>
                                    </div>
                                    <h5 class="blog-title mb-30 underline"><a href="{{route('blog.detail',$post->slug)}}">{{$post->title}}</a></h5>
                                    <div class="blog-btn">
                                        <a href="{{route('blog.detail',$post->slug)}}" class="bd-primary-btn btn-style has-arrow radius-60">
                                            <span class="bd-primary-btn-arrow arrow-right"><i class="fa-regular fa-arrow-right"></i></span>
                                            <span class="bd-primary-btn-text">Read More</span>
                                            <span class="bd-primary-btn-circle"></span>
                                            <span class="bd-primary-btn-arrow arrow-left"><i class="fa-regular fa-arrow-right"></i></span>
                                        </a>

                                    </div>
                                </div>
                            </article>
                        </div>
                        @endforeach
                        @endif
                    </div>
                </div>
                <div class="blog-slider-pagination bd-pagination mt-20 justify-content-center"></div>
            </div>
        </section>
        <!-- blog area end -->
    <!-- blog-grid area start -->
    {{-- <div class="bd-blog-grid-area section-space">
        <div class="container">
            <div class="row">
                @if($posts)
                    @foreach($posts as $post)
                        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6">
                            <article class="blog-wrapper blog-default blog-style-six">
                                <div class="blog-thumb image-hover-effect">
                                    <a href="{{route('blog.detail',$post->slug)}}">
                                        <img src="{{ Storage::url($post->photo) }}" class="img-responsive"  alt="" />
                                    </a>
                                </div>
                                <div class="blog-content">
                                    <div class="blog-meta-list">
                                        <div class="blog-meta-item has-seperator">
                                            <span class="meta-icon">
                                                <i class="icon-profile"></i>
                                            </span>
                                            <span class="meta-text">
                                                <a class="meta-author">{{ $post->tags }}</a>
                                            </span>
                                        </div>
                                        <div class="blog-meta-item">
                                            <span class="meta-icon">
                                                <i class="icon-cleander-check"></i>
                                            </span>
                                            <span class="meta-text"><a href="{{route('blog.detail',$post->slug)}}"> {{$post->created_at->format('d M , Y. D')}}</a></span>
                                        </div>
                                    </div>
                                    <h5 class="blog-title mb-5 underline"><a href="{{route('blog.detail',$post->slug)}}">{{$post->title}}</a></h5>
                                    <p>{!! substr($post->description, 0, 100) !!}</p>
                                    <div class="">
                                        <div class="icon-text-btn p-relative">
                                            <a href="{{route('blog.detail',$post->slug)}}">
                                                <span>Read More</span>
                                                <i>
                                                    <svg width="18" height="14" viewBox="0 0 18 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M11.2871 1L17 6.71285L11.2871 12.4257" stroke="currentColor" stroke-width="1.5"
                                                            stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                                        <path d="M1 6.71313H16.8397" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                                    </svg>
                                                </i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </div> --}}
    <!-- blog-grid area end -->

</main>
<!-- Body main wrapper end -->

@endsection