@extends('frontend.layouts.master2')
@section('meta')
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name='copyright' content=''>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="keywords" content="">
	{{-- <meta name="description" content="{{$post->summary}}"> --}}
	{{-- <meta property="og:url" content="{{route('blog-detail',$post->slug)}}"> --}}
	<meta property="og:type" content="article">
	<meta property="og:title" content="{{$post->title}}">
	<meta property="og:image" content="{{$post->photo}}">
	<meta property="og:description" content="{{$post->description}}">
@endsection
@section('title') {{$post->title}} @endsection
@section('main-content')
@include('frontend.layouts.notification')

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" @if(isset($banner) && $banner && $banner->banner_image) data-background="{{ Storage::url($banner->banner_image) }}" @else data-background="{{ asset('frontend/assets/images/updates_page.jpg') }}" @endif></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">{{$post->title}}</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Home</a></span>
                                    <span>{{$post->title}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

<!-- blog-details area start -->
        <section class="bd-blog-details-area section-space">
            <div class="container">
                <div class="row gy-24">
                    <div class="col-xxl-8 col-xl-8 col-lg-7">
                        <div class="post-details-wrapper">
                            <article class="post-details mb-25">
                                <div class="post-details-thumb image-hover-effect mb-15">
                                    <a href="javascript:"><img src="{{ Storage::url($post->photo) }}" alt="image"></a>
                                </div>
                                <div class="post-details-content">
                                    <h3 class="post-details-title mb-15">{{$post->title}}</h3>
                                    <div class="post-details-meta mb-20">
                                        <ul>
                                            <!--<li><a href="javascript:"><img src="assets/images/blog/blog-author.png" alt="author"><span>By</span> Ellena M.Rice</a></li>-->
                                            <li><a href="javascript:"><i class="icon-cleander-check"></i> {{$post->created_at->format('d M , Y. D')}}</a></li>
                                            <!--<li><a href="javascript:"><i class="icon-comment"></i> {{$post->allComments->count()}} Comments</a></li>-->
                                        </ul>
                                    </div>
                                    
                                    @if($post->summary)
                                    <div class="post-details-blockquote mb-30">
                                        <blockquote>
                                            <h4 class="blockquote-title">{!!$post->summary!!}</h4>
                                            <p class="d-flex justify-content-end"><span></span></p>
                                        </blockquote>
                                    </div>
                                    @endif
                                    
                                    <p class="mb-15">{!!$post->description!!}</p>
                                    <p class="mb-20"></p>
                                    
                                    <!--<div class="post-details-list-wrap">-->
                                    <!--    <h4 class="mb-10">Patent Process</h4>-->
                                    <!--    <p class="mb-20">Lorem ipsum dolor sit amet consectetur adipiscing elit Ut et massa mi.-->
                                    <!--        Aliquam in-->
                                    <!--        hendrerit urna. Pellentesque sit amet sapien fringilla, mattis ligula consectetur,-->
                                    <!--        ultrices mauris. Maecenas vitae mattis tellus. Nullam quis imperdiet augue. Vestibulum-->
                                    <!--        auctor ornare leo, non suscipit magna interdum eu.</p>-->
                                    <!--    <div class="post-details-list mb-20">-->
                                    <!--        <ul>-->
                                    <!--            <li>-->
                                    <!--                <span class="list-icon">-->
                                    <!--      <i class="fa-solid fa-check"></i>-->
                                    <!--   </span>-->
                                    <!--                Expertise in Patent Protection-->
                                    <!--            </li>-->
                                    <!--            <li>-->
                                    <!--                <span class="list-icon">-->
                                    <!--      <i class="fa-solid fa-check"></i>-->
                                    <!--   </span>-->
                                    <!--                Commitment to Excellence-->
                                    <!--            </li>-->
                                    <!--            <li>-->
                                    <!--                <span class="list-icon">-->
                                    <!--      <i class="fa-solid fa-check"></i>-->
                                    <!--   </span>-->
                                    <!--                Collaborative Partnerships-->
                                    <!--            </li>-->
                                    <!--        </ul>-->
                                    <!--    </div>-->
                                    <!--    <p>We are a team of the dedicated patent professionals, united by our commitment toour-->
                                    <!--        excellence patent protection. With years of collective experience acros diverse-->
                                    <!--        industries.</p>-->
                                    <!--</div>-->
                                </div>
                                <div class="section-divider mt-30 mb-25"></div>
                                <div class="post-details-category d-flex flex-wrap gap-10 align-items-center justify-content-between">
                                    <div class="category-section">
                                        <h6 class="category-label mb-10">Article Category:</h6>
                                        <div class="category-badge">
                                            @if($post->tag_info)
                                                <span class="category-tag">{{ $post->tag_info->title }}</span>
                                            @else
                                                <span class="category-tag">Uncategorized</span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="theme-social">
                                        <a href="#"><i class="icon-facebook"></i></a>
                                        <a href="#"><i class="icon-twitter-x"></i></a>
                                        <a href="#"><i class="icon-linkedin"></i></a>
                                        <a href="#"><i class="icon-youtube"></i></a>
                                    </div>
                                </div>
                            </article>
                            {{--<div class="post-avatar ">
                            <div class="comments-counter"><a href="#">({{$post->allComments->count()}}) Comments found</a></div>
                                @include('frontend.pages.comment', ['comments' => $post->comments??[], 'post_id' => $post->id, 'depth' => 3])
                            </div>
                            <div class="post-comment-form">
                            <div class="post-comments-title">
                                <h4 class="mb-15">Leave a Comment</h4>
                                <span class="d-block mb-25">Your email address will not be published. Required fields are
                          marked *</span>
                            </div>
                            <form role="form" class="form comment_form" id="" action="{{route('post-comment.store',$post->slug)}}" method="POST">
                                @csrf
                                <div class="row gy-24">
                                    <div class="col-xl-12">
                                        <div class="input-box">
                                            <textarea cols="30" rows="10" placeholder="Type Comment here"></textarea>
                                            <input type="hidden" name="post_id" value="{{ $post->id }}" />
                                            <input type="hidden" name="parent_id" id="parent_id" value="" />
                                        </div>
                                    </div>
                                    <div class="col-xl-12">
                                        <div class="submit-btn">
                                            <button type="button" class="bd-primary-btn btn-style has-arrow is-bg radius-60">
                                                <span class="bd-primary-btn-arrow arrow-right"><i
                                         class="fa-regular fa-arrow-right"></i></span>
                                                <span class="bd-primary-btn-text">Submit Comment</span>
                                                <span class="bd-primary-btn-circle"></span>
                                                <span class="bd-primary-btn-arrow arrow-left"><i
                                         class="fa-regular fa-arrow-right"></i></span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div> --}}
                            <!--<div class="post-avatar ">-->
                            <!--    <div class="post-avatar-img">-->
                            <!--        <a href="#"><img src="assets/images/blog/blog-author.png" alt="image"></a>-->
                            <!--    </div>-->
                            <!--    <div class="post-avatar-content">-->
                            <!--        <h5 class="post-avatar-name">Ellena M. Ricee</h5>-->
                            <!--        <span class="post-avatar-digi">UI/UX Instructor</span>-->
                            <!--        <p class="mb-20">Lorem ipsum dolor sit amet consectetur adipiscing elit Ut massa mi. Aliquam-->
                            <!--            in hendrerit Pellentesque sit amet sapien fringilla.</p>-->
                            <!--        <span class="post-avatar-signature"><img src="assets/images/blog/blog-author-sign.png"-->
                            <!--     alt="sign"></span>-->
                            <!--    </div>-->
                            <!--</div>-->
                        </div>
                    </div>
                    <div class="col-xxl-4 col-xl-4 col-lg-5">
                        <aside class="sidebar-wrapper sidebar-sticky">
                            <div class="sidebar-widget-wrapper mb-30">
                                <div class="sidebar-widget widget">
                                    <h6 class="sidebar-widget-title small mb-15">Search Here</h6>
                                    <div class="sidebar-search">
                                        <form class="sidebar-search-form" action="{{route('blog.search')}}" method="get">
                                            <input type="text" value="" required="" name="search" placeholder="Search">
                                            <button type="submit"> <i class="far fa-search"></i> </button>
                                        </form>
                                    </div>
                                </div>
                                <div class="sidebar-widget-divider"></div>
                                <div class="sidebar-widget widget">
                                    <h6 class="sidebar-widget-title small mb-15">Recent Post</h6>
                                    <div class="sidebar-widget-post">
                                         @foreach($recent_posts as $tour)
                                        <div class="recent-post">
                                            <div class="recent-post-thumb mr-10">
                                                <a href="{{route('blog.detail',$tour->slug)}}">
                                                    <img src="{{ Storage::url($tour->photo) }}" alt="image">
                                                </a>
                                            </div>
                                            <div class="recent-post-content">
                                                <h6 class="recent-post-title small underline">
                                                    <a href="{{route('blog.detail',$tour->slug)}}">{{$tour->title}}</a>
                                                </h6>
                                                <span class="recent-post-date">
                                                 <a href="{{route('blog.detail',$tour->slug)}}"><span><i class="icon-cleander-check"></i></span> {{$tour->created_at->format('d M , Y. D')}}</a>
                                                </span>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="sidebar-widget-divider"></div>
                                <div class="sidebar-widget widget widget_categories">
                                    <h6 class="sidebar-widget-title small mb-15">Categories</h6>
                                    <ul>
                                        @foreach($alltags as $tag)
                                        <li class="underline-two"><a href="{{route('blog.tag',$tag->slug)}}">{{$tag->title}}</a>({{$tag->posts->count()}})</li>
                                        @endforeach
                                    </ul>
                                </div>
                                
                            </div>
                            <div class="sidebar-widget-banner p-relative">
                                <div class="sidebar-widget-thumb p-relative">
                                    <img src="{{ asset('frontend/assets/images/bg/sidebar-img.png') }}" alt="img">
                                </div>
                                <div class="sidebar-widget-content">
                                    <span class="bd-play-btn pulse-white mb-40"><i class="icon-call-ring"></i></span>
                                    <p class="b3 mb-0">Free Call</p>
                                    <h5 class="mb-25"><a href="https://wa.me/+255711434479?text=Hello I have a question">+255711434479</a></h5>
                                    <div class="sidebar-btn">
                                        <a class="bd-text-btn style-two" href="{{route('contact')}}">Contact
                                            <span class="icon__box">
                                    <i class="fa-light fa-angle-right icon__first"></i>
                                    <i class="fa-light fa-angle-right icon__second"></i>
                                 </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </aside>
                    </div>
                </div>
            </div>
        </section>
        <!-- blog-details area end -->

</main>
<!-- Body main wrapper end -->

@endsection
@push('styles')
<script type='text/javascript' src='https://platform-api.sharethis.com/js/sharethis.js#property=5f2e5abf393162001291e431&product=inline-share-buttons' async='async'></script>
<style>
/* Article Summary Styles */
.post-summary {
    background: #f8f9fa;
    border-left: 4px solid #007bff;
    padding: 20px;
    border-radius: 5px;
    margin: 20px 0;
}

.summary-title {
    color: #007bff;
    font-weight: 600;
    font-size: 16px;
    margin-bottom: 10px;
}

.summary-content {
    color: #555;
    line-height: 1.6;
    margin: 0;
    font-size: 14px;
}

/* Article Category Styles */
.post-details-category {
    padding: 15px 0;
    border-top: 1px solid #eee;
}

.category-section {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
}

.category-label {
    color: #666;
    font-size: 14px;
    font-weight: 500;
    margin: 0;
}

.category-badge {
    margin-top: 5px;
}

.category-tag {
    background: #007bff;
    color: white;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Sidebar Category Styles */
.widget_category_cloud .categorycloud {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
}

.category-link {
    background: #f8f9fa;
    color: #007bff;
    padding: 6px 12px;
    border-radius: 15px;
    font-size: 12px;
    text-decoration: none;
    border: 1px solid #e9ecef;
    transition: all 0.3s ease;
}

.category-link:hover {
    background: #007bff;
    color: white;
    text-decoration: none;
    transform: translateY(-2px);
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .post-summary {
        padding: 15px;
        margin: 15px 0;
    }
    
    .summary-title {
        font-size: 14px;
    }
    
    .summary-content {
        font-size: 13px;
    }
    
    .category-section {
        margin-bottom: 15px;
    }
    
    .post-details-category {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .theme-social {
        margin-top: 15px;
    }
}
</style>
@endpush
@push('scripts')
<script>
$(document).ready(function(){

(function($) {
    "use strict";

    $('.btn-reply.reply').click(function(e){
        e.preventDefault();
        $('.btn-reply.reply').show();

        $('.comment_btn.comment').hide();
        $('.comment_btn.reply').show();

        $(this).hide();
        $('.btn-reply.cancel').hide();
        $(this).siblings('.btn-reply.cancel').show();

        var parent_id = $(this).data('id');
        var html = $('#commentForm');
        $( html).find('#parent_id').val(parent_id);
        $('#commentFormContainer').hide();
        $(this).parents('.comment-list').append(html).fadeIn('slow').addClass('appended');
      });

    $('.comment-list').on('click','.btn-reply.cancel',function(e){
        e.preventDefault();
        $(this).hide();
        $('.btn-reply.reply').show();

        $('.comment_btn.reply').hide();
        $('.comment_btn.comment').show();

        $('#commentFormContainer').show();
        var html = $('#commentForm');
        $( html).find('#parent_id').val('');

        $('#commentFormContainer').append(html);
    });

})(jQuery)
})
</script>
@endpush
