@extends('frontend.layouts.master2')
@section('title') {{ __('header.about_title') }} @endsection
@section('main-content')

<!-- Body main wrapper start -->
<main>
    <!-- breadcrumb area start -->
    <section class="bd-breadcrumb-area p-relative fix">
        <!-- breadcrumb background image -->
        <div class="bd-breadcrumb-bg" @if(isset($banner) && $banner && $banner->banner_image) data-background="{{  Storage::url($banner->banner_image) }}" @else data-background="{{ asset('frontend/assets/images/about_us_page.jpg') }}" @endif></div>
        <div class="bd-breadcrumb-wrapper p-relative">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                            <div class="bd-breadcrumb-content text-center">
                                <h1 class="bd-breadcrumb-title">About Us</h1>
                                <div class="bd-breadcrumb-list">
                                    <span><a href="{{route('home')}}"><i class="icon-home"></i>Home</a></span>
                                    <span>About Us</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- breadcrumb area end -->

    <!-- about-us area start -->
    <section class="bd-about-us-area section-space">
        <div class="container">
            <div class="row gy-24 justify-content-between">
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 wow fadeInLeft">
                    <div class="about-thumb-wrap about-style-two">
                        <div class="about-thumb-one">
                            <img src="{{ asset('frontend/assets/images/about_us_big.jpg') }}" alt="image">
                        </div>
                        <div class="about-thumb-two">
                            <img src="{{ asset('frontend/assets/images/about_small.jpg') }}" alt="image">
                        </div>
                        <div class="about-icon-badge">
                            <span><i class="icon-world"></i></span>
                        </div>
                        <div class="about-shape">
                            <img src="{{ asset('frontend/assets/images/shapes/about-shape.png') }}" alt="shape">
                        </div>
                    </div>
                    <br>
                    <h5>Who We Are</h5>
                    <p>Tembea Horizons is a local tour operator based in Tanzania, offering quality nature tours & safaris to Tanzania’s most attractive destinations.
                    </p>
                    <p>We plan relaxed and flexible itineraries tailor made according to your interests.  Apart from our proposed itineraries, we also organize transfers, short day trips and excursions. Our support service is available 24/7. </p>
                    <p>You will work with a dedicated team. We keep in touch with you right away from enquiry, arrival until departure.
                    We also provide all the auxiliary services related to tourist needs and services within our area of operation.
                    </p>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12">
                    <div class="section-title-wrapper mb-35">
                        <span class="section-subtitle mb-15">About Us</span>
                        <h2 class="section-title mb-20">
                            Get 100% Satisfaction With
                            Our Service</h2>
                    </div>
                    <div class="about-list">
                        <ul>
                            
                            <li>
                                <span class="about-list-icon">
                          <i class="icon-life-jacket"></i>
                       </span>
                                <div>
                                    <span class="about-list-title mb-5">Our Vision</span>
                                    <span class="about-list-subtitle">To be among the best tourism companies in Tanzania, being recognized for our professionalism, excellent customer care and high quality services.</span>
                                </div>
                            </li>
                            <li>
                                <span class="about-list-icon">
                          <i class="fa-light fa-badge-dollar"></i>
                       </span>
                                <div>
                                    <span class="about-list-title mb-5">Our Mission</span>
                                    <span class="about-list-subtitle">To perform and deliver excellent quality service to our clients. Providing them unforgettable Safaris & enjoyable Excursions , with guaranteed services that exceed their expectations.
                                    We plan relaxed and flexible itineraries tailor made according to your interests.
                                    Our support service is available 24/7. Guides are specialists in nature, wildlife, birds, geography and history. Locals site guides are natives in parks & places that clients visit.
                                    We spend more nights at carefully selected  accommodations, ensuring maximum relaxation and delicious meals!</span>
                                </div>
                            </li>
                            <li>
                                <span class="about-list-icon">
                          <i class="icon-trip"></i>
                       </span>
                                <span>
                          <span class="about-list-title mb-5">Our Objectives</span>
                                <span class="about-list-subtitle">
                                     <p>To provide a high standard of services suitable for individuals seeking relaxing, comfortable and memorable experiences in the hospitality and tourism industry. </p>
                                    <p>To provide the tourist market with the quality personal required by the tourism industry. </p>
                                    <p>To produce expeditions and memories that would satisfy each of our tour customer. </p></span>
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- about-us area end -->

    <br><br><br>

    <!-- cta area start -->
    <section class="bd-cta-area section-space-bottom cta-top fix">
        <div class="container">
            <div class="col-xl-12">
                <div class="cta-wrapper cta-item p-relative fix">
                    <div class="cta-shape">
                        <div class="cta-shape-one">
                            <img src="{{ asset('frontend/assets/images/shapes/about-circle.png') }}" alt="shape">
                        </div>
                        <div class="cta-shape-two">
                            <img src="{{ asset('frontend/assets/images/shapes/about-circle.png') }}" alt="shape">
                        </div>
                        <div class="cta-five-shape-one">
                            <svg class="line-dash" width="247" height="196" viewBox="0 0 247 196" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.2" d="M245.14 3.36996C166.842 -15.3027 150.848 81.3076 129.648 127.737C92.9991 208 3.85592 207.125 1.00053 170" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="4 4" />
                            </svg>
                        </div>
                        <div class="cta-five-shape-two">
                            <img src="{{ asset('frontend/assets/images/shapes/plane-9.png') }}" alt="image">
                        </div>
                    </div>
                    <div class="cta-item-box">
                        <div class="section-title-wrapper p-relative z-index-11">
                            <h2 class="section-title white-text mb-5">Lets Get Stared with Us.</h2>
                            <h3 class="cta-subtitle">Call Us Now!</h3>
                        </div>
                        <div class="cta-btn text-center p-relative z-index-11">
                            <a href="{{route('book')}}" class="bd-primary-btn btn-style has-arrow is-bg btn-tertiary is-white radius-60">
                                <span class="bd-primary-btn-arrow arrow-right"><i class="fa-regular fa-arrow-right"></i></span>
                                <span class="bd-primary-btn-text">Book Now</span>
                                <span class="bd-primary-btn-circle"></span>
                                <span class="bd-primary-btn-arrow arrow-left"><i class="fa-regular fa-arrow-right"></i></span>
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- cta area end -->

    <!-- travel area start -->
	<section class="bd-travel-area theme-bg-secondary section-space p-relative">
		<div class="container">
			<div class="travel-shape">
				<div class="travel-shape-one">
					<svg class="line-dash" xmlns="http://www.w3.org/2000/svg" width="62" height="189" viewBox="0 0 62 189" fill="none">
						<path d="M60.8463 1.88108C24.1532 4.12571 3.23706 24.8596 3.65598 39.628C4.54894 71.1079 29.5088 91.5168 46.4287 114.553C86.0696 168.522 21.3918 196.8 1.31736 185.21" stroke="#FFF8E6" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3 3" />
					</svg>
				</div>
				<div class="travel-shape-two">
					<img src="{{ asset('frontend/assets/images/shapes/plane-2.png') }}" alt="shape">
				</div>
				<div class="travel-shape-three">
					<img src="{{ asset('frontend/assets/images/shapes/camera.png') }}" alt="shape">
				</div>
				<div class="travel-shape-four">
					<img src="{{ asset('frontend/assets/images/shapes/line-circle.png') }}" alt="shape">
				</div>
				<div class="travel-shape-five">
					<img src="{{ asset('frontend/assets/images/shapes/circle-bg-3.png') }}" alt="shape">
				</div>
				<div class="travel-shape-six">
					<img src="{{ asset('frontend/assets/images/shapes/stone.png') }}" alt="shape">
				</div>
			</div>
			<div class="row gy-24 align-items-center justify-content-between">
				<div class="col-xl-6 col-lg-6">
					<div class="travel-section">
						<div class="popup-vido mb-40">
							<a class="bd-play-btn btn-tertiary popup-video animation-two theme-bg" href="https://www.youtube.com/watch?v=eUpwDAnkgSM">
								<i class="icon-play"></i>
							</a>
						</div>
						<div class="section-title-wrapper is-white mb-35">
							<span class="section-subtitle text-warning mb-10">Are you ready to travel?</span>
							<h2 class="section-title mb-15">
								Take a Break & Checkout Our Top Destinations
							</h2>
							<p>
							We offer wildlife safari in Tanzanian national parks such as Serengeti national park & all excursion in Tanzania.
(Explore more once clicked, should take one to the destination page)
							</p>
						</div>
						<div class="travel-btn">
							<a href="{{route('destination')}}" class="bd-primary-btn btn-style has-arrow is-bg radius-60">
								<span class="bd-primary-btn-arrow arrow-right"><i class="fa-regular fa-arrow-right"></i></span>
								<span class="bd-primary-btn-text">Know More</span>
								<span class="bd-primary-btn-circle"></span>
								<span class="bd-primary-btn-arrow arrow-left"><i class="fa-regular fa-arrow-right"></i></span>
							</a>
						</div>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="row gy-24">
						<div class="col-lg-6 col-sm-6">
							<div class="travel-wrapper">
								<div class="travel-item">
									<div class="travel-icon"><span><i class="icon-elephant"></i></span></div>
									<h5 class="travel-title white-text underline-two"><a>Wild Life Tours</a></h5>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-sm-6">
							<div class="travel-wrapper">
								<div class="travel-item">
									<div class="travel-icon"><span><i class="icon-cycling"></i></span></div>
									<h5 class="travel-title white-text underline-two"><a>Mountain Climbing</a></h5>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-sm-6">
							<div class="travel-wrapper">
								<div class="travel-item">
									<div class="travel-icon"><span><i class="icon-skydive"></i></span></div>
									<h5 class="travel-title white-text underline-two"><a>Beach Trips & Resorts</a></h5>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-sm-6">
							<div class="travel-wrapper">
								<div class="travel-item">
									<div class="travel-icon"><span><i class="icon-adventure"></i></span></div>
									<h5 class="travel-title white-text underline-two"><a>Adventure
											Tours</a></h5>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- travel area end -->

    <!-- testimonial area start  -->
    <section class="bd-testimonial-area section-space">
        <div class="container">
            <div class="row gy-24 align-items-center justify-content-center section-title-space">
                <div class="col-lg-6 col-md-8">
                    <div class="section-title-wrapper text-center">
                        <span class="section-subtitle mb-10">Testimonials</span>
                        <h2 class="section-title">Our Client Testimonials</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-24 justify-content-between">
                @if($testimonials)
					@foreach($testimonials as $testimonial)
                        <div class="col-xxl-4 col-xl-4 col-lg-4">
                            <div class="testimonial-wrapper testimonial-style-three">
                                <div class="testimonial-content p-relative">
                                    <div class="testimonial-avatar flex-wrap mb-25">
                                        <div class="testimonial-avatar-wrap">
                                            <div class="avatar-thumb">
                                                @php
                                                    $photo=explode(',',$testimonial->photo);
                                                @endphp
                                                <img src="{{ Storage::url($testimonial->photo) }}" alt="{{ Storage::url($testimonial->photo) }}">
                                            </div>
                                            <div class="avatar-meta">
                                                <h6 class="avatar-meta-title">{{$testimonial->name}}</h6>
                                                <p>{{$testimonial->position}}</p>
                                            </div>
                                        </div>
                                        <div class="testimonial-quot-icon">
                                            <i class="fa-solid fa-quote-right"></i>
                                        </div>
                                    </div>
                                    <p class="testimonial-desc">{!!$testimonial->message!!}</p>
                                    <div class="avatar-rating p-relative">
                                        <div class="fs-14 d-flex rating-color">
                                            {{-- <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i> --}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
    <!-- testimonial area end  -->

    <!-- team area start -->
    <section class="bd-team-area section-space-bottom">
        <div class="container">
            <div class="row gy-24 align-items-center justify-content-center section-title-space">
                <div class="col-lg-6 col-md-8">
                    <div class="section-title-wrapper text-center">
                        <span class="section-subtitle mb-10">Our Team</span>
                        <h2 class="section-title">Ready To Serve You</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-24">
                @if($teams)
					@foreach($teams as $team)
                        <div class="col-xxl-4col-xl-4 col-lg-4 col-md-6">
                            <div class="team-wrapper team-style-three position-relative">
                                <div class="team-content-wrap position-relative">
                                    <div class="team-thumb-wrap">
                                        <div class="team-thumb image-overly radius-8">
                                            <a>
                                                <img src="{{ Storage::url($team->photo) }}" alt="{{ Storage::url($team->photo) }}">
                                            </a>
                                        </div>
                                    </div>
                                    <div class="team-meta d-flex align-content-center align-items-center justify-content-between">
                                        <div class="team-content">
                                            <h6 class="team-member-name white-text underline-two"><a>{{$team->name}}</a></h6>
                                            <span>{{$team->position}}</span>
                                        </div>
                                        {{-- <div class="team-social-wrap">
                                            <span><i class="icon-share"></i></span>
                                            <div class="theme-social team-social style-two">
                                                <a target="_blank" href="https://www.facebook.com/"><i class="icon-facebook"></i></a>
                                                <a target="_blank" href="https://twitter.com/"><i class="icon-twitter-x"></i></a>
                                                <a target="_blank" href="https://www.instagram.com/"><i class="icon-instagram"></i></a>
                                                <a target="_blank" href="https://bd.linkedin.com/"><i class="icon-linkedin"></i></a>
                                            </div>
                                        </div> --}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
    <!-- team area end -->

</main>
<!-- Body main wrapper end -->

@endsection

