@php
    $location_categories=App\Models\LocationCategory::where('status','active')->orderBy('id','DESC')->get();
    $tour_tags=App\Models\TourTag::where('status','active')->orderBy('id','DESC')->get();
@endphp
<!-- Header area start -->
<header>
    <div id="header-sticky" class="header-area header-style header-style-one has-border">
        <div class="container">
            <div class="mega-menu-wrapper p-relative">
                <div class="header-main">
                    <div class="header-left">
                        <div class="header-logo">
                            <a href="{{route('home')}}" class="logo-primary">
                                <img src="{{asset('frontend/assets/images/logo/logo.png') }}" alt="{{asset('frontend/assets/images/logo/logo.png') }}">
                            </a>
                            <a href="{{route('home')}}" class="logo-secondary">
                                <img src="{{asset('frontend/assets/images/logo/logo.png') }}" alt="{{asset('frontend/assets/images/logo/logo.png') }}">
                            </a>
                        </div>
                        <div class="header-search mb-0">
                            <form action="{{route('search.all')}}" method="GET" id="global-search-form">
                                <div class="search-autocomplete-wrapper">
                                    <input type="text" name="q" id="global-search-input" placeholder="Search tours, destinations, articles..." autocomplete="off" value="{{ request('q') }}">
                                    <div id="autocomplete-results" class="autocomplete-dropdown"></div>
                                </div>
                                <button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
                            </form>
                        </div>
                        <div class="header-menu">
                            <nav class="main-menu" id="mobile-menu">
                                <ul>
                                    <li class="has-mega-menu">
                                        <a href="{{ route('home') }}">Home</a>
                                    </li>
                                    <li><a href="{{route('about-us')}}">About Us</a></li>
                                    <li class="has-mega-menu">
                                        <a href="javascript:void(0)">Destinations</a>
                                        <ul class="mega-menu home-menu-grid">
                                            @foreach($location_categories as $location_category)
                                            <li>
                                                <div class="home-menu-item">
                                                    <div class="home-menu-thumb">
                                                        <img src="{{ Storage::url($location_category->photo) }}" alt="thumb not found">
                                                        <div class="home-menu-buttons">
                                                            <a href="{{route('destination.category',$location_category->slug)}}" class="bd-primary-btn btn-style">
                                                                <span class="bd-primary-btn-text">{{$location_category->title}}</span>
                                                                <span class="bd-primary-btn-circle"></span>
                                                            </a>

                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            @endforeach
                                            
                                        </ul>
                                    </li>
                                    <li class="has-mega-menu">
                                        <a href="javascript:void(0)">Safari Tours</a>
                                        <ul class="mega-menu home-menu-grid">
                                            @foreach($tour_tags as $tour_tag)
                                            <li>
                                                <div class="home-menu-item">
                                                    <div class="home-menu-thumb">
                                                        <img src="{{ Storage::url($tour_tag->photo) }}" alt="thumb not found">
                                                        <div class="home-menu-buttons">
                                                            <a href="{{route('tour.tag',$tour_tag->slug)}}" class="bd-primary-btn btn-style">
                                                                <span class="bd-primary-btn-text">{{$tour_tag->title}}</span>
                                                                <span class="bd-primary-btn-circle"></span>
                                                            </a>

                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            @endforeach
                                            
                                        </ul>
                                    </li>
                                    
                                    <li class="menu-item-has-children">
                                        <a href="javascript:void(0)">Updates</a>
                                        <ul class="submenu">
                                            <li><a href="{{route('blog')}}">Article</a></li>
                                            <li><a href="{{route('document')}}">Documents</a></li>
                                        </ul>
                                    </li>
                                    <li><a href="{{route('book')}}">Booking</a></li>
                                    <li class="menu-item-has-children">
                                        <a href="javascript:void(0)">Contact</a>
                                        <ul class="submenu">
                                            <li><a href="{{route('contact')}}">Contact</a></li>
                                            <li><a href="{{route('faq')}}">FAQ</a></li>
                                        </ul>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                    <div class="header-right">
                        <div class="header-action d-flex align-items-center">
                            <div class="header-hamburger ml-20">
                                <div class="sidebar-toggle">
                                    <a class="bar-icon style-two" href="javascript:void(0)">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </a>
                                </div>
                            </div>
                            <!-- for wp -->
                            <div class="header-hamburger ml-20 d-none">
                                <button type="button" class="hamburger-btn offcanvas-open-btn">
                                    <span>01</span>
                                    <span>01</span>
                                    <span>01</span>
                                </button>
                            </div>

                            <div class="ml-20 header-language-item header-language">
                                <div id="google_translate_element"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- Header area end -->