<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>@yield('title') - {{ config('app.name') }}</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="keywords" content="Uganda tours, Uganda safaris, Uganda adventures, Uganda wildlife, Uganda crane, Uganda cultures, Uganda destinations, Uganda travel, Uganda accommodation, Zawadi sanctuary">

    <!-- Place favicon.ico in the root directory -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('frontend/assets/images/favicon.ico') }}">
    <!-- CSS here -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/animate.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/swiper.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/flatpickr.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/chosen.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/nice-select.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/dropzone.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/nouislider.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/magnific-popup.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/fontawesome-pro.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/icomoon.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/spacing.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/main.css') }}">

    <!-- Cloudflare Turnstile -->
    <script src="https://challenges.cloudflare.com/turnstile/v0/api.js" async defer></script>

    @stack('styles')
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css" />
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({
                pageLanguage: 'en',
                includedLanguages: 'en,fr,de,es,it,ru',
                layout: google.translate.TranslateElement.InlineLayout.SIMPLE
            }, 'google_translate_element');
            
            // Hide Google branding after widget loads - Enhanced
            setTimeout(function() {
                // Hide Google logo and branding elements
                var googleBranding = document.querySelector('.goog-logo-link');
                if (googleBranding) {
                    googleBranding.style.display = 'none';
                    googleBranding.style.visibility = 'hidden';
                    googleBranding.style.opacity = '0';
                }
                
                var poweredBy = document.querySelector('.goog-te-gadget span:first-child');
                if (poweredBy) {
                    poweredBy.style.display = 'none';
                }
                
                var banner = document.querySelector('.goog-te-banner-frame');
                if (banner) {
                    banner.style.display = 'none';
                }
                
                // Hide all Google logo elements
                var logoElements = document.querySelectorAll('.goog-te-gadget .goog-te-logo, .goog-te-gadget .goog-te-logo-link, .goog-te-gadget img, .goog-te-gadget svg');
                logoElements.forEach(function(element) {
                    element.style.display = 'none';
                    element.style.visibility = 'hidden';
                    element.style.opacity = '0';
                    element.style.width = '0';
                    element.style.height = '0';
                });
                
                // Hide any remaining branding text
                var brandingText = document.querySelectorAll('.goog-te-gadget span:first-child, .goog-te-gadget > span:last-child');
                brandingText.forEach(function(element) {
                    element.style.display = 'none';
                });
                
                // Additional cleanup for newer versions
                var additionalElements = document.querySelectorAll('.goog-te-gadget .goog-te-logo-link, .goog-te-gadget .goog-te-logo-link img, .goog-te-gadget .goog-te-logo-link svg');
                additionalElements.forEach(function(element) {
                    element.style.display = 'none';
                    element.style.visibility = 'hidden';
                    element.style.opacity = '0';
                    element.style.width = '0';
                    element.style.height = '0';
                });
            }, 1000);
            
            // Additional cleanup after a longer delay
            setTimeout(function() {
                var allGoogleElements = document.querySelectorAll('.goog-te-gadget .goog-te-logo, .goog-te-gadget .goog-te-logo-link, .goog-te-gadget img, .goog-te-gadget svg');
                allGoogleElements.forEach(function(element) {
                    element.style.display = 'none';
                    element.style.visibility = 'hidden';
                    element.style.opacity = '0';
                    element.style.width = '0';
                    element.style.height = '0';
                });
            }, 2000);
        }
    </script>
    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
    <!-- Hide Google Translate Logo -->
    <style>
        /* Hide Google Translate logo and branding - Enhanced */
        .goog-logo-link,
        .goog-logo-link *,
        .goog-te-gadget .goog-te-logo,
        .goog-te-gadget .goog-te-logo *,
        .goog-te-gadget img,
        .goog-te-gadget svg,
        .goog-te-gadget .goog-te-logo-link,
        .goog-te-gadget .goog-te-logo-link * {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
            width: 0 !important;
            height: 0 !important;
        }
        
        .goog-te-gadget {
            color: transparent !important;
        }
        
        .goog-te-gadget > span > a {
            display: none !important;
        }
        
        .goog-te-gadget .goog-te-combo {
            color: #333 !important;
        }
        
        /* Hide the "Powered by Google" text */
        .goog-te-banner-frame {
            display: none !important;
        }
        
        /* Hide Google Translate banner */
        .goog-te-banner-frame.skiptranslate {
            display: none !important;
        }
        
        /* Style the dropdown to match site design */
        .goog-te-gadget .goog-te-combo {
            background-color: transparent !important;
            border: 1px solid var(--bd-border-tertiary, #ddd) !important;
            border-radius: 30px !important;
            padding: 5px 15px !important;
            font-size: 14px !important;
            color: var(--bd-heading, #333) !important;
            outline: none !important;
        }
        
        .goog-te-gadget .goog-te-combo:hover {
            border-color: var(--bd-primary, #007bff) !important;
        }
        
        /* Remove Google branding text */
        .goog-te-gadget span:first-child {
            display: none !important;
        }
        
        /* Hide the Google Translate attribution */
        .goog-te-gadget > span:last-child {
            display: none !important;
        }
        
        /* Additional cleanup */
        .goog-te-gadget .goog-te-combo option {
            color: #333 !important;
        }
        
        /* Hide any remaining Google branding elements */
        .goog-te-gadget .goog-te-logo,
        .goog-te-gadget .goog-te-logo-link,
        .goog-te-gadget .goog-te-logo-link img,
        .goog-te-gadget .goog-te-logo-link svg,
        .goog-te-gadget .goog-te-logo-link:before,
        .goog-te-gadget .goog-te-logo-link:after {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
            width: 0 !important;
            height: 0 !important;
            content: none !important;
        }
        
        /* Hide Google logo in dropdown */
        .goog-te-gadget .goog-te-combo option[value*="google"],
        .goog-te-gadget .goog-te-combo option[value*="Google"] {
            display: none !important;
        }
        
        /* Additional selectors for newer Google Translate versions */
        .goog-te-gadget .goog-te-logo-link,
        .goog-te-gadget .goog-te-logo-link img,
        .goog-te-gadget .goog-te-logo-link svg,
        .goog-te-gadget .goog-te-logo-link:before,
        .goog-te-gadget .goog-te-logo-link:after,
        .goog-te-gadget .goog-te-logo-link::before,
        .goog-te-gadget .goog-te-logo-link::after {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
            width: 0 !important;
            height: 0 !important;
            content: none !important;
        }
        
        /* Autocomplete Styles */
        .search-autocomplete-wrapper {
            position: relative;
            display: inline-block;
            width: 100%;
        }
        
        .autocomplete-dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: #fff;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 8px 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            z-index: 1000;
            max-height: 300px;
            overflow-y: auto;
            display: none;
        }
        
        /* Mobile autocomplete positioning */
        #autocomplete-results-mobile {
            position: relative;
            top: auto;
            left: auto;
            right: auto;
            margin-top: 10px;
            border-radius: 8px;
            border: 1px solid #ddd;
        }
        
        .autocomplete-item {
            padding: 12px 15px;
            cursor: pointer;
            border-bottom: 1px solid #f0f0f0;
            transition: background-color 0.2s ease;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .autocomplete-item:last-child {
            border-bottom: none;
        }
        
        .autocomplete-item:hover,
        .autocomplete-item.active {
            background-color: #f8f9fa;
        }
        
        .autocomplete-icon {
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            flex-shrink: 0;
            font-size: 12px;
        }
        
        .tour-item .autocomplete-icon {
            background-color: #28a745;
            color: white;
        }
        
        .destination-item .autocomplete-icon {
            background-color: #007bff;
            color: white;
        }
        
        .article-item .autocomplete-icon {
            background-color: #6f42c1;
            color: white;
        }
        
        .autocomplete-content {
            flex: 1;
        }
        
        .autocomplete-title {
            font-weight: 600;
            color: #333;
            margin-bottom: 4px;
            font-size: 14px;
        }
        
        .autocomplete-location {
            font-size: 12px;
            color: #666;
            margin-bottom: 2px;
        }
        
        .autocomplete-type {
            font-size: 11px;
            color: #999;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .autocomplete-item.highlighted {
            background-color: var(--bd-primary, #007bff);
            color: white;
        }
        
        .autocomplete-item.highlighted .autocomplete-title,
        .autocomplete-item.highlighted .autocomplete-location,
        .autocomplete-item.highlighted .autocomplete-type {
            color: white;
        }
        
        /* Loading indicator */
        .autocomplete-loading {
            padding: 12px 15px;
            text-align: center;
            color: #666;
            font-style: italic;
        }
        
        /* No results */
        .autocomplete-no-results {
            padding: 15px;
            text-align: center;
            color: #666;
            font-style: italic;
            background-color: #f8f9fa;
            border-left: 3px solid #ffc107;
            font-size: 14px;
        }
        
        /* Loading indicator */
        .autocomplete-loading {
            padding: 15px;
            text-align: center;
            color: #666;
            font-style: italic;
            background-color: #f8f9fa;
            border-left: 3px solid #007bff;
            font-size: 14px;
        }
        
        /* Pros and Cons Section Styles */
        .destinations-pros-cons {
            margin: 40px 0;
        }
        
        .pros-cons-toggle-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 25px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        
        .pros-cons-main-title {
            font-size: 20px;
            font-weight: 600;
            margin: 0;
            display: flex;
            align-items: center;
        }
        
        .pros-cons-toggle-btn {
            background: rgba(255,255,255,0.2);
            border: 2px solid rgba(255,255,255,0.3);
            color: white;
            padding: 10px 20px;
            border-radius: 25px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
            font-weight: 500;
        }
        
        .pros-cons-toggle-btn:hover {
            background: rgba(255,255,255,0.3);
            border-color: rgba(255,255,255,0.5);
            transform: translateY(-2px);
        }
        
        .toggle-icon {
            transition: transform 0.3s ease;
        }
        
        .pros-cons-content-wrapper {
            animation: fadeIn 0.3s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .pros-cons-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            height: 100%;
        }
        
        .pros-cons-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
        }
        
        .pros-card {
            border-left: 4px solid #28a745;
        }
        
        .cons-card {
            border-left: 4px solid #dc3545;
        }
        
        .pros-cons-header {
            padding: 20px 25px 15px;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }
        
        .pros-card .pros-cons-header {
            background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
        }
        
        .cons-card .pros-cons-header {
            background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
        }
        
        .pros-cons-title {
            margin: 0;
            font-size: 18px;
            font-weight: 600;
            color: #333;
            display: flex;
            align-items: center;
        }
        
        .pros-cons-content {
            padding: 20px 25px 25px;
        }
        
        .pros-cons-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        
        .pros-cons-list li {
            padding: 8px 0;
            display: flex;
            align-items: flex-start;
            line-height: 1.6;
            color: #555;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .pros-cons-list li:last-child {
            border-bottom: none;
        }
        
        .pros-cons-list li i {
            margin-top: 2px;
            flex-shrink: 0;
        }
        
        .text-success {
            color: #28a745 !important;
        }
        
        .text-danger {
            color: #dc3545 !important;
        }
        
        .me-2 {
            margin-right: 0.5rem !important;
        }
        
        /* Responsive adjustments for pros/cons */
        @media (max-width: 768px) {
            .pros-cons-toggle-header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .pros-cons-main-title {
                font-size: 18px;
            }
            
            .pros-cons-toggle-btn {
                padding: 8px 16px;
                font-size: 14px;
            }
            
            .pros-cons-card {
                margin-bottom: 20px;
            }
            
            .pros-cons-header {
                padding: 15px 20px 12px;
            }
            
            .pros-cons-content {
                padding: 15px 20px 20px;
            }
            
            .pros-cons-title {
                font-size: 16px;
            }
        }
        
        /* Contact Icons Styles */
        .contact-item {
            margin-bottom: 12px;
        }
        
        .contact-link {
            display: flex;
            align-items: center;
            color: #666;
            text-decoration: none;
            transition: all 0.3s ease;
            padding: 8px 0;
        }
        
        .contact-link:hover {
            color: var(--bd-primary, #007bff);
            transform: translateX(5px);
        }
        
        .contact-icon {
            width: 20px;
            height: 20px;
            margin-right: 12px;
            color: #666;
            font-size: 16px;
            flex-shrink: 0;
            transition: all 0.3s ease;
        }
        
        .contact-link:hover .contact-icon {
            transform: scale(1.1);
            color: var(--bd-primary, #007bff);
        }
        
        .contact-link span {
            font-size: 14px;
            line-height: 1.4;
        }
        
        /* Uniform color for all contact icons */
        .contact-item .contact-icon {
            color: #666;
        }
        
        .contact-link:hover {
            color: var(--bd-primary, #007bff);
        }
        
        /* Responsive adjustments for contact icons */
        @media (max-width: 768px) {
            .contact-link {
                padding: 6px 0;
            }
            
            .contact-icon {
                width: 18px;
                height: 18px;
                margin-right: 10px;
                font-size: 14px;
            }
            
            .contact-link span {
                font-size: 13px;
            }
        }
    </style>
    
    <!-- Autocomplete JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize autocomplete for all search forms
            initializeAutocomplete('global-search-input', 'autocomplete-results', 'global-search-form');
            initializeAutocomplete('global-search-input-mobile', 'autocomplete-results-mobile', 'global-search-form-mobile');
            initializeAutocomplete('destination-search-input', 'autocomplete-results', 'destination-search-form');
        });
        
        function initializeAutocomplete(inputId, resultsId, formId) {
            const searchInput = document.getElementById(inputId);
            const autocompleteResults = document.getElementById(resultsId);
            const searchForm = document.getElementById(formId);
            
            if (!searchInput || !autocompleteResults || !searchForm) {
                return; // Skip if elements don't exist
            }
            
            let currentRequest = null;
            let selectedIndex = -1;
            let currentResults = [];
            
            // Debounce function to limit API calls
            function debounce(func, wait) {
                let timeout;
                return function executedFunction(...args) {
                    const later = () => {
                        clearTimeout(timeout);
                        func(...args);
                    };
                    clearTimeout(timeout);
                    timeout = setTimeout(later, wait);
                };
            }
            
            // Fetch autocomplete results
            function fetchAutocompleteResults(query) {
                if (currentRequest) {
                    currentRequest.abort();
                }
                
                if (query.length < 2) {
                    hideAutocomplete();
                    return;
                }
                
                console.log('Fetching autocomplete for:', query);
                showLoading();
                
                currentRequest = new XMLHttpRequest();
                currentRequest.open('GET', '{{ route("global.autocomplete") }}?q=' + encodeURIComponent(query), true);
                
                currentRequest.onreadystatechange = function() {
                    if (currentRequest.readyState === 4) {
                        if (currentRequest.status === 200) {
                            try {
                                const results = JSON.parse(currentRequest.responseText);
                                console.log('Autocomplete results:', results);
                                displayResults(results);
                            } catch (e) {
                                console.error('Error parsing autocomplete results:', e);
                                showNoResults('Error loading results');
                            }
                        } else {
                            console.error('Autocomplete request failed with status:', currentRequest.status);
                            showNoResults('Failed to load results');
                        }
                        currentRequest = null;
                    }
                };
                
                currentRequest.onerror = function() {
                    console.error('Autocomplete request error');
                    showNoResults('Network error');
                    currentRequest = null;
                };
                
                currentRequest.send();
            }
            
            // Show loading indicator
            function showLoading() {
                autocompleteResults.innerHTML = '<div class="autocomplete-loading">Searching...</div>';
                autocompleteResults.style.display = 'block';
            }
            
            // Show no results message
            function showNoResults(message = 'No destinations found') {
                autocompleteResults.innerHTML = `<div class="autocomplete-no-results">${message}</div>`;
                autocompleteResults.style.display = 'block';
                currentResults = [];
                selectedIndex = -1;
            }
            
            // Display autocomplete results
            function displayResults(results) {
                currentResults = results;
                selectedIndex = -1;
                
                console.log('Displaying results:', results.length, 'items');
                
                if (results.length === 0) {
                    showNoResults('No results found for your search');
                } else {
                    autocompleteResults.innerHTML = results.map((result, index) => {
                        let typeIcon = '';
                        let typeClass = '';
                        
                        switch(result.type) {
                            case 'tour':
                                typeIcon = '<i class="fa-solid fa-map-marked-alt"></i>';
                                typeClass = 'tour-item';
                                break;
                            case 'destination':
                                typeIcon = '<i class="fa-solid fa-mountain"></i>';
                                typeClass = 'destination-item';
                                break;
                            case 'article':
                                typeIcon = '<i class="fa-solid fa-newspaper"></i>';
                                typeClass = 'article-item';
                                break;
                        }
                        
                        return `<div class="autocomplete-item ${typeClass}" data-index="${index}" data-url="${result.url}">
                            <div class="autocomplete-icon">${typeIcon}</div>
                            <div class="autocomplete-content">
                                <div class="autocomplete-title">${result.title}</div>
                                ${result.location ? `<div class="autocomplete-location">${result.location}</div>` : ''}
                                <div class="autocomplete-type">${result.type.charAt(0).toUpperCase() + result.type.slice(1)}</div>
                            </div>
                        </div>`;
                    }).join('');
                }
                
                autocompleteResults.style.display = 'block';
            }
            
            // Hide autocomplete dropdown
            function hideAutocomplete() {
                autocompleteResults.style.display = 'none';
                selectedIndex = -1;
                currentResults = [];
            }
            
            // Handle input events
            const debouncedFetch = debounce(fetchAutocompleteResults, 300);
            
            searchInput.addEventListener('input', function(e) {
                const query = e.target.value.trim();
                debouncedFetch(query);
            });
            
            // Handle keyboard navigation
            searchInput.addEventListener('keydown', function(e) {
                if (autocompleteResults.style.display === 'none') return;
                
                switch(e.key) {
                    case 'ArrowDown':
                        e.preventDefault();
                        selectedIndex = Math.min(selectedIndex + 1, currentResults.length - 1);
                        updateSelection();
                        break;
                    case 'ArrowUp':
                        e.preventDefault();
                        selectedIndex = Math.max(selectedIndex - 1, -1);
                        updateSelection();
                        break;
                    case 'Enter':
                        e.preventDefault();
                        if (selectedIndex >= 0 && currentResults[selectedIndex]) {
                            selectDestination(currentResults[selectedIndex]);
                        } else {
                            searchForm.submit();
                        }
                        break;
                    case 'Escape':
                        hideAutocomplete();
                        break;
                }
            });
            
            // Update visual selection
            function updateSelection() {
                const items = autocompleteResults.querySelectorAll('.autocomplete-item');
                items.forEach((item, index) => {
                    item.classList.remove('highlighted');
                    if (index === selectedIndex) {
                        item.classList.add('highlighted');
                    }
                });
            }
            
            // Handle mouse clicks on autocomplete items
            autocompleteResults.addEventListener('click', function(e) {
                const item = e.target.closest('.autocomplete-item');
                if (item) {
                    const index = parseInt(item.dataset.index);
                    selectResult(currentResults[index]);
                }
            });
            
            // Select result and redirect
            function selectResult(result) {
                searchInput.value = result.title;
                hideAutocomplete();
                // Redirect to the result URL
                window.location.href = result.url;
            }
            
            // Hide autocomplete when clicking outside
            document.addEventListener('click', function(e) {
                if (!searchInput.contains(e.target) && !autocompleteResults.contains(e.target)) {
                    hideAutocomplete();
                }
            });
            
            // Handle form submission
            searchForm.addEventListener('submit', function(e) {
                if (selectedIndex >= 0 && currentResults[selectedIndex]) {
                    e.preventDefault();
                    selectResult(currentResults[selectedIndex]);
                }
            });
        } // End of initializeAutocomplete function
    </script>
</head>