<!DOCTYPE html>
<html lang="en">
    <!doctype html>
    <html class="no-js" lang="zxx">
    
    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <title>New Booking Notification - {{ config('app.name') }}</title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!-- Place favicon.ico in the root directory -->
        <link rel="shortcut icon" type="image/x-icon" href="{{ asset('frontend/assets/images/favicon.ico') }}">
        <!-- CSS here -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/bootstrap.min.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/animate.min.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/swiper.min.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/flatpickr.min.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/chosen.min.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/nice-select.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/dropzone.min.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/plugins/nouislider.min.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/magnific-popup.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/fontawesome-pro.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/icomoon.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/vendor/spacing.css') }}">
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/main.css') }}">
    </head>
	
<body>
    <!-- preloader start -->
    <div id="preloader">
        <div class="bd-three-bounce">
            <div class="bd-child bd-bounce1"></div>
            <div class="bd-child bd-bounce2"></div>
            <div class="bd-child bd-bounce3"></div>
        </div>
    </div>
    <!-- preloader end -->

	<!-- Header area start -->
    <header>
        <div id="header-sticky" class="header-area header-style header-style-one has-border">
            <div class="container">
                <div class="mega-menu-wrapper p-relative">
                    <div class="header-main">
                        <div class="header-left">
                            <div class="header-logo">
                                <a href="{{route('home')}}" class="logo-primary">
                                    <img src="{{asset('frontend/assets/images/logo/logo.png') }}" alt="{{asset('frontend/assets/images/logo/logo.png') }}">
                                </a>
                                <a href="{{route('home')}}" class="logo-secondary">
                                    <img src="{{asset('frontend/assets/images/logo/logo.png') }}" alt="{{asset('frontend/assets/images/logo/logo.png') }}">
                                </a>
                            </div>
                            <div class="header-menu">
                                <nav class="main-menu" id="mobile-menu">
                                    <ul>
                                        <li class="has-mega-menu">
                                            <a href="{{ route('home') }}">Home</a>
                                        </li>
                                        <li><a href="{{route('about-us')}}">About Us</a></li>
                                        <li><a href="{{route('destination')}}">Destinations</a></li>
                                        <li><a href="{{route('tour')}}">Tours</a></li>
                                        <li class="menu-item-has-children">
                                            <a href="javascript:void(0)">Updates</a>
                                            <ul class="submenu">
                                                <li><a href="{{route('blog')}}">Article</a></li>
                                                <li><a href="{{route('document')}}">Downloads</a></li>
                                                <li><a href="{{route('video')}}">Videos</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="{{route('checkout')}}">Booking</a></li>
                                        <li><a href="{{route('faq')}}">FAQ</a></li>
                                        <li><a href="{{route('contact')}}">Contact</a></li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                        <div class="header-right">
                            <div class="header-action d-flex align-items-center">
                                <div class="header-hamburger ml-20 d-xl-none">
                                    <div class="sidebar-toggle">
                                        <a class="bar-icon" href="javascript:void(0)">
                                            <span></span>
                                            <span></span>
                                            <span></span>
                                        </a>
                                    </div>
                                </div>
                                <!-- for wp -->
                                <div class="header-hamburger ml-20 d-none">
                                    <button type="button" class="hamburger-btn offcanvas-open-btn">
                                        <span>01</span>
                                        <span>01</span>
                                        <span>01</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header area end -->

    <!-- Body main wrapper start -->
    <main>
        <!-- breadcrumb area start -->
        <section class="bd-breadcrumb-area p-relative fix">
            <!-- breadcrumb background image -->
            <div class="bd-breadcrumb-bg" data-background="{{ asset('frontend/assets/images/bg/breadcrumb-bg.png') }}"></div>
            <div class="bd-breadcrumb-wrapper p-relative">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-10">
                            <div class="bd-breadcrumb d-flex align-items-center justify-content-center">
                                <div class="bd-breadcrumb-content text-center">
                                    <h1 class="bd-breadcrumb-title">Booking Notification</h1>
                                    <div class="bd-breadcrumb-list">
                                        <span><a href="Home"><i class="icon-home"></i>Home</a></span>
                                        <span>Booking Notification</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb area end -->

        <!-- contact form area start -->
        <section class="bd-contact-form section-space">
            <div class="container">
                <div class="row justify-content-center">
                    <h1>New Booking Received</h1>
                    <p><strong>First Name:</strong> {{ $order->first_name }}</p>
                    <p><strong>Last Name:</strong> {{ $order->last_name }}</p>
                    <p><strong>Email:</strong> {{ $order->email }}</p>
                    <p><strong>Phone:</strong> {{ $order->phone }}</p>
                    <p><strong>Country:</strong> {{ $order->country }}</p>
                    <p><strong>Language:</strong> {{ $order->language }}</p>
                    <p><strong>Number of Adults:</strong> {{ $order->number_adult }}</p>
                    <p><strong>Number of Children:</strong> {{ $order->number_child }}</p>
                    <p><strong>Children's Ages:</strong> {{ $order->age_child }}</p>
                    <p><strong>Date of Arrival:</strong> {{ $order->date_arrival }}</p>
                    <p><strong>Total Stay:</strong> {{ $order->total_stay }}</p>
                    <p><strong>Experience:</strong> {{ $order->experience }}</p>
                    <p><strong>Accommodation:</strong> {{ $order->accomodation }}</p>
                    <p><strong>Budget:</strong> {{ $order->budget }}</p>
                    <p><strong>Likes Most:</strong> {{ $order->like_most }}</p>
                    <p><strong>Dislikes Most:</strong> {{ $order->dislike_most }}</p>
                    <p><strong>Brief Description:</strong> {{ $order->brief_descript }}</p>
                    <p><strong>Tour ID:</strong> {{ $order->tour_id }}</p>
                </div>
            </div>
        </section>
        <!-- contact form area end -->

    </main>
    <!-- Footer area start -->
    <footer class="bd-footer-area theme-bg-secondary">
        <div class="footer-top section-space">
            <div class="container">
                <div class="row gy-24 align-items-center justify-content-between">
                    <div class="col-xxl-5 col-xl-5 col-lg-6">
                        <div class="footer-support-wrapper">
                            <div class="footer-support-thumb">
                                <img src="{{ asset('frontend/assets/images/shapes/support-img.png') }}" alt="image">
                            </div>
                            <h4 class="footer-support-title white-text">Need Support for tour & travels?</h4>
                            <div class="footer-support-btn">
                                <a class="bd-icon-btn has-big hover-style" href="contact.html" target="_blank"><i class="fa-sharp fa-regular fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-6 col-xl-6 col-lg-6">
                        <div class="footer-support-wrapper right-side">
                            <div class="footer-support-thumb">
                                <img src="{{ asset('frontend/assets/images/shapes/support-img-two.png') }}" alt="image">
                            </div>
                            <h4 class="footer-support-title white-text">Ready to Get Started With Vacations!</h4>
                            <div class="footer-support-btn">
                                <a class="bd-icon-btn has-big hover-style" href="destinations-details-right.html" target="_blank"><i class="fa-sharp fa-regular fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="bd-footer section-space">
            <div class="container">
                <div class="row gy-24">
                    <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
                        <div class="footer-widget footer-4-col-1">
                            <div class="footer-widget-logo mb-25">
                                <a href="index.html">
                                    <img src="{{ asset('frontend/assets/images/logo/logo.png')}}" alt="logo not found">
                                </a>
                            </div>
                            <div class="footer-widget-content">
                                <p>
                                    Zanzibar Point Tours & Safari is a Zanzibar and Tanzania mainland based in tour operator specializing in organizing safaris in Tanzania and tours on the island of Zanzibar and neighbouring sites of touristic interest. We also provide all the auxiliary services related to tourist needs and services within our area of operation. Apart from our proposed itineraries, we also organize transfers, short day trips and excursions, as well as book flights and ferry tickets.
                                </p>
                                <div class="theme-social is-white-color">
                                    <a href="#"><i class="icon-facebook"></i></a>
                                    <a href="#"><i class="icon-twitter-x"></i></a>
                                    <a href="#"><i class="icon-linkedin"></i></a>
                                    <a href="#"><i class="icon-youtube"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-2 col-xl-2 col-lg-6 col-md-6">
                        <div class="footer-widget footer-4-col-2">
                            <h5 class="footer-widget-title white-text">Company</h5>
                            <div class="footer-widget-links has-white">
                                <ul>
                                    <li class="underline-two"><a href="{{route('home')}}">Home</a></li>
                                    <li class="underline-two"><a href="{{route('about-us')}}">About Us</a></li>
                                    <li class="underline-two"><a href="{{route('destination')}}">Destination</a></li>
                                    <li class="underline-two"><a href="{{route('tour')}}">Tour</a><span class="bd-badge warning">New</span>
                                    </li>
                                    <li class="underline-two"><a href="{{route('contact')}}">Contact Now</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6">
                        <div class="footer-widget footer-4-col-3">
                            <h5 class="footer-widget-title white-text">Newsletter</h5>
                            <div class="footer-widget-content">
                                <p>Subscribe our newsletter to get our latest <br> update & news.</p>
                                <div class="footer-form mb-15">
                                    <form action="#">
                                        <div class="footer-subscribe">
                                            <input type="email" placeholder="Email address">
                                            <button type="submit"> <i class="fa-solid fa-paper-plane"></i></button>
                                        </div>
                                    </form>
                                </div>
                                <div class="footer-form-check">
                                    <label class="footer-form-check-label">
                                        <input type="checkbox">
                                        <svg viewBox="0 0 64 64" height="2em" width="2em">
                                            <path d="M 0 16 V 56 A 8 8 90 0 0 8 64 H 56 A 8 8 90 0 0 64 56 V 8 A 8 8 90 0 0 56 0 H 8 A 8 8 90 0 0 0 8 V 16 L 32 48 L 64 16 V 8 A 8 8 90 0 0 56 0 H 8 A 8 8 90 0 0 0 8 V 56 A 8 8 90 0 0 8 64 H 56 A 8 8 90 0 0 64 56 V 16" pathLength="575.0541381835938" class="path"></path>
                                        </svg> I agree to all terms and policies
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
                        <div class="footer-widget footer-4-col-4">
                            <h5 class="footer-widget-title white-text">Contact Us</h5>
                            <div class="footer-widget-list-wrapper">
                                <ul class="footer-widget-list-items">
                                    <li class="footer-widget-list-single-item">
                                        <span class="footer-widget-list-icon"><i class="icon-call"></i></span>
                                        <span class="footer-widget-list-text">
                                <span class="footer-widget-list-text-top">
                                    Call Us
                                </span>
                                        <a href="tel:+00123456889">+255774862939</a>
                                        </span>
                                    </li>
                                    <li class="footer-widget-list-single-item">
                                        <span class="footer-widget-list-icon"><i class="icon-envelope"></i></span>
                                        <span class="footer-widget-list-text">
                                <span class="footer-widget-list-text-top">
                                    Email Us
                                </span>
                                        <a href="mailto:info@zanzibarpointtours.com">info@zanzibarpointtours.com</a>
                                        </span>
                                    </li>
                                    <li class="footer-widget-list-single-item">
                                        <span class="footer-widget-list-icon"><i class="icon-location-fill"></i></span>
                                        <span class="footer-widget-list-text">
                                <span class="footer-widget-list-text-top">
                                    Our office
                                </span>
                                        <a href="contact.html">Stone town-Zanzibar</a>
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-copyright-area border-two">
            <div class="container">
                <div class="row gy-24 align-items-center justify-content-between align-content-end">
                    <div class="col-xl-4 col-lg-6 col-md-6 col-12">
                        <div class="footer-copyright has-white">
                            <p>Copyright @<script>document.write(new Date().getFullYear());</script>
                                Powered By
                                <a href="https://ufanisiafrica.com/" target="_blank">
                                    Ufanisi
                                </a>
                            </p>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-5 col-md-6 col-12">
                        <div class="footer-card">
                            <img src="{{ asset('frontend/assets/images/icons/payment-option-white.png')}}" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- Footer area end -->

    <!-- Javascript Files
        ================================================== -->

        <!-- back to top -->
    <!-- Backtotop start -->
    <div class="backtotop-wrap cursor-pointer">
        <svg class="backtotop-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Backtotop end -->

    <!-- JS here -->
    <script src="{{ asset('frontend/assets/js/vendor/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/waypoints.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/vendor/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/meanmenu.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/swiper.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/wow.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/dropzone.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/vendor/magnific-popup.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/vendor/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/vendor/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/vendor/purecounter.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/nouislider.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/nice-select.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/cleave.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/flatpickr.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/plugins/tinymce.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/vendor/ajax-form.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/main.js') }}"></script>
</body>
</html>
