@extends('backend.layouts.master')
@section('title') Edit Tour Category @endsection
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
  <div class="breadcrumbs-inner">
      <div class="row m-0">
          <div class="col-sm-4">
              <div class="page-header float-left">
                  <div class="page-title">
                      <h1>Edit Tour Category</h1>
                  </div>
              </div>
          </div>
          <div class="col-sm-8">
              <div class="page-header float-right">
                  <div class="page-title">
                      <ol class="breadcrumb text-right">
                          <li><a href="{{ route('admin')}}">Dashboard</a></li>
                          <li><a href="{{ route('tour-tag.index') }}">View Tour Category</a></li>
                          <li class="active">Edit Tour Category</li>
                      </ol>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>

<div class="content">
  <div class="animated fadeIn">
    <div class="row">
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
              <strong>Edit Tour Category</strong>
          </div>
          <div class="card-body card-block">
            <form method="post" action="{{route('tour-tag.update',$tourTag->id)}}" enctype="multipart/form-data">
              @csrf 
              @method('PATCH')
              <div class="form-group">
                <label for="inputTitle" class="col-form-label">Title</label>
                <input id="inputTitle" type="text" name="title" placeholder=""  value="{{$tourTag->title}}" class="form-control" required>
                @error('title')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>

              <div class="form-group">
                <label for="photo" class="col-form-label">Photo</label>
                <input id="photo" type="file" name="photo" class="form-control" accept="image/*">
                @if($tourTag->photo)
                  <div class="mt-2">
                    <p>Current Photo:</p>
                    <img src="{{ asset('storage/'.str_replace('public/', '', $tourTag->photo)) }}" alt="Current Photo" style="max-width: 200px; height: auto;">
                  </div>
                @endif
                @error('photo')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>

                <div class="form-group">
                  <label for="banner" class="col-form-label">Top Banner <small class="text-muted">(Recommended: 1920 x 550px)</small></label>
                <input id="banner" type="file" name="banner" class="form-control" accept="image/*">
                @if($tourTag->banner)
                  <div class="mt-2">
                    <p>Current Banner:</p>
                    <img src="{{ asset('storage/'.str_replace('public/', '', $tourTag->banner)) }}" alt="Current Banner" style="max-width: 300px; height: auto;">
                  </div>
                @endif
                @error('banner')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>

              <div class="form-group">
                <label for="status" class="col-form-label">Status</label>
                <select name="status" class="form-control">
                  <option value="active" {{(($tourTag->status=='active') ? 'selected' : '')}}>Active</option>
                  <option value="inactive" {{(($tourTag->status=='inactive') ? 'selected' : '')}}>Inactive</option>
                </select>
                @error('status')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>
              <div class="form-group mb-3">
                <button class="btn btn-success" type="submit">Update</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
