@extends('backend.layouts.master')
@section('title') Add Service @endsection
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
    <div class="breadcrumbs-inner">
        <div class="row m-0">
            <div class="col-sm-4">
                <div class="page-header float-left">
                    <div class="page-title">
                        <h1>Add Service</h1>
                    </div>
                </div>
            </div>
            <div class="col-sm-8">
                <div class="page-header float-right">
                    <div class="page-title">
                        <ol class="breadcrumb text-right">
                            <li><a href="{{ route('admin')}}">Dashboard</a></li>
                            <li><a href="{{ route('service.index') }}">View</a></li>
                            <li class="active">Add</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="animated fadeIn">
        <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <strong>Add</strong>
                    </div>
                    <div class="card-body card-block">
                        <form method="post" action="{{route('service.store')}}" enctype="multipart/form-data">
                            {{csrf_field()}}
                            <div class="form-group">
                                <label for="inputTitle" class="col-form-label">Service Title</label>
                                <input id="inputTitle" type="text" name="title" placeholder="Enter Service Title" value="{{old('title')}}" class="form-control" required>
                                @error('title')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="inputSubtitle" class="col-form-label">Service Subtitle</label>
                                <input id="inputSubtitle" type="text" name="subtitle" placeholder="Enter Service Subtitle" value="{{old('subtitle')}}" class="form-control" required>
                                @error('subtitle')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="description" class="col-form-label">Service Description</label>
                                <textarea class="form-control ckeditor" id="description" name="description" placeholder="Enter Service Description">{{old('description')}}</textarea>
                                @error('description')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div>

                            {{-- <div class="form-group">
                                <label for="inputIcon" class="col-form-label">Upload Service Icon <span class="text-danger">*</span></label>
                                <input class="form-control" type="file" name="icon" required>
                                @error('icon')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div> --}}

                            <div class="form-group">
                                <label for="inputPhoto" class="col-form-label">Upload Service Image (Size: 690px x 801px) <span class="text-danger">*</span></label>
                                <input class="form-control" type="file" name="photo" required>
                                @error('photo')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="status" class="col-form-label">Status</label>
                                <select name="status" class="form-control">
                                    <option value="active" {{old('status') == 'active' ? 'selected' : ''}}>Active</option>
                                    <option value="inactive" {{old('status') == 'inactive' ? 'selected' : ''}}>Inactive</option>
                                </select>
                                @error('status')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div>

                            <div class="form-group mb-3">
                                <button type="reset" class="btn btn-warning">Reset</button>
                                <button class="btn btn-success" type="submit">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
