@extends('backend.layouts.master')
@section('title')
    Create Tour
@endsection
@section('main-content')
    @include('backend.layouts.notification')

    <div class="breadcrumbs">
        <div class="breadcrumbs-inner">
            <div class="row m-0">
                <div class="col-sm-4">
                    <div class="page-header float-left">
                        <div class="page-title">
                            <h1>Tours</h1>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="page-header float-right">
                        <div class="page-title">
                            <ol class="breadcrumb text-right">
                                <li><a href="{{ route('admin') }}">Dashboard</a></li>
                                <li><a href="{{ route('tour.index') }}">Tours</a></li>
                                <li class="active">Add Tour</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <strong>Tours</strong>
                        </div>
                        <div class="card-body card-block">
                            <form method="post" action="{{ route('tour.store') }}" enctype="multipart/form-data">
                                {{ csrf_field() }}
                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Tour Title <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="title" placeholder=""
                                        value="{{ old('title') }}" class="form-control" required>
                                    @error('title')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="tags">Tour Type</label>
                                    <select name="tags" data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        @foreach ($tags as $key => $data)
                                            <option value='{{ $data->title }}'>{{ $data->title }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="location_category_id" class="col-form-label">Location Category <span
                                            class="text-danger">*</span></label>
                                    <select name="location_category_id" class="form-control">
                                        <option value="">Select Location Category</option>
                                        @php
                                            $location_categories = \App\Models\LocationCategory::where('status', 'active')->get();
                                        @endphp
                                        @foreach($location_categories as $category)
                                            <option value="{{ $category->id }}" {{ old('location_category_id') == $category->id ? 'selected' : '' }}>
                                                {{ $category->title }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('location_category_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Tour Location <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="location" placeholder=""
                                        value="{{ old('location') }}" class="form-control" required>
                                    @error('location')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="map" class="col-form-label">Tour Map (Embeded Link)</label>
                                    <input class="form-control" id="map" name="map" value="{{ old('map') }}" type="url">
                                    @error('map')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Age Limit <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="text" name="age" placeholder=""
                                        value="{{ old('age') }}" class="form-control" required>
                                    @error('age')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="inputPhoto" class="col-form-label">Upload Tour image ( Size: 852px x 589px)
                                        <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        {{-- <span class="input-group-btn">
                        <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary">
                        <i class="fa fa-picture-o"></i> Choose
                        </a>
                    </span>
                <input id="thumbnail" class="form-control" type="text" name="photo" value="{{old('photo')}}"> --}}
                                        <input class="form-control" type="file" name="photo" required>
                                    </div>
                                    <div id="holder" style="margin-top:15px;max-height:100px;"></div>
                                    @error('photo')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="description" class="col-form-label">Tour Description</label>
                                    <textarea class="form-control ckeditor" id="description" name="description" required>{{ old('description') }}</textarea>
                                    @error('description')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="number_of_days" class="col-form-label">Number of Days <span
                                            class="text-danger">*</span></label>
                                    <input id="number_of_days" type="text" name="number_of_days" placeholder=""
                                        value="{{ old('number_of_days') }}" class="form-control" required>
                                    @error('number_of_days')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div id="itinerary-container">
                                    <fieldset>
                                        <legend for="fiels-1" class="w-100 d-flex justify-content-between align-items-center">
                                            <span class="text-muted">Itinerary Section</span>
                                            <button type="button" class="btn btn-sm btn-danger itinery-rem-button"  onclick="removeItItem(this)" style="border-radius: 50%; width: 30px; height: 30px">X</button>
                                        </legend>
                                        <div class="form-group itinerary-item">
                                            <label for="itinerary_title_1" class="col-form-label">Itinerary Title <span
                                                    class="text-danger">*</span></label>
                                            <input id="itinerary_title_1" type="text" name="itinerary_titles[]"
                                                class="form-control" required>

                                            <label for="itinerary_description_1" class="col-form-label">Description <span
                                                    class="text-danger">*</span></label>
                                            <textarea id="itinerary_description_1" name="itinerary_descriptions[]" class="form-control ckeditor" required></textarea>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="form-group">
                                    <button type="button" style="border-radius: 15px" id="add-itinerary" class="btn btn-info btn-sm">Add Itinerary</button>
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Price Per Person <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="number" name="price" placeholder=""
                                        value="{{ old('price') }}" class="form-control" required>
                                    @error('price')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Price Per Child <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="number" name="price_per_child" placeholder=""
                                        value="{{ old('price_per_child') }}" class="form-control" >
                                    @error('price_per_child')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="inputTitle" class="col-form-label">Discount <span
                                            class="text-danger">*</span></label>
                                    <input id="inputTitle" type="number" name="discount" placeholder=""
                                        value="{{ old('discount') }}" class="form-control" >
                                    @error('discount')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="includes">Includes</label>
                                    <select name="includes[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        @foreach ($includes as $key => $data)
                                            <option value='{{ $data->title }}'>{{ $data->title }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="excludes">Excludes</label>
                                    <select name="excludes[]" multiple data-live-search="true"
                                        class="form-control selectpicker" required>
                                        <option value="">----</option>
                                        @foreach ($excludes as $key => $data)
                                            <option value='{{ $data->title }}'>{{ $data->title }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="images" class="col-form-label">Upload Multiple Images (Size: 1024px x 676px | Max: 12 photos)</label>
                                    <div class="input-group">
                                        <input class="form-control" type="file" name="images[]" multiple>
                                    </div>
                                    @error('images.*')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="status" class="col-form-label">{{ __('sidebar.post_status') }} <span
                                            class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option value="active">Active</option>
                                        <option value="featured">Featured</option>
                                        <option value="inactive">Inactive</option>
                                    </select>
                                    @error('status')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Availability Section -->
                                <fieldset style="border: 1px solid #ddd; padding: 15px; margin-bottom: 20px; border-radius: 5px;">
                                    <legend style="font-size: 16px; font-weight: bold; color: #333; padding: 0 10px;">Tour Availability</legend>
                                    
                                    <div class="form-group">
                                        <label for="availability_type" class="col-form-label">Availability Type <span class="text-danger">*</span></label>
                                        <select name="availability_type" id="availability_type" class="form-control" onchange="toggleAvailabilityFields()">
                                            <option value="year_round" {{ old('availability_type') == 'year_round' ? 'selected' : '' }}>Available Year Round</option>
                                            <option value="seasonal" {{ old('availability_type') == 'seasonal' ? 'selected' : '' }}>Seasonal Availability</option>
                                            <option value="custom" {{ old('availability_type') == 'custom' ? 'selected' : '' }}>Custom Availability</option>
                                        </select>
                                        @error('availability_type')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div id="unavailable-periods-section" style="display: none;">
                                        <div class="form-group">
                                            <label class="col-form-label">Unavailable Periods</label>
                                            <div id="unavailable-periods-container">
                                                <div class="unavailable-period-item" style="border: 1px solid #eee; padding: 10px; margin-bottom: 10px; border-radius: 3px;">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <label>Start Date</label>
                                                            <input type="date" name="unavailable_periods[0][start_date]" class="form-control">
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label>End Date</label>
                                                            <input type="date" name="unavailable_periods[0][end_date]" class="form-control">
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label>Reason (Optional)</label>
                                                            <input type="text" name="unavailable_periods[0][reason]" class="form-control" placeholder="e.g., Heavy rains">
                                                        </div>
                                                        <div class="col-md-1">
                                                            <label>&nbsp;</label>
                                                            <button type="button" class="btn btn-danger btn-sm form-control" onclick="removePeriod(this)">×</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <button type="button" id="add-period" class="btn btn-info btn-sm">Add Another Period</button>
                                        </div>
                                    </div>

                                   
                                </fieldset>
                                <div class="form-group mb-3 text-right">
                                    <button type="reset"
                                        class="btn btn-warning">{{ __('sidebar.post_reset') }}</button>
                                    <button class="btn btn-success"
                                        type="submit">{{ __('sidebar.post_submit') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
    <script type="text/javascript">
        $ = jQuery;

        function removeItItem(e) {
            if(confirm('Are you sure yo want to remove this section?')){
                e.parentNode.parentNode.remove();
            }
        }

        $(document).ready(function() {
            $('.ckeditor').ckeditor();

            let itineraryCount = 1;

            $('#add-itinerary').on('click tap', function() {
                itineraryCount++;

                let itineraryItem = `
                <legend for="fiels-1" class="w-100 d-flex justify-content-between align-items-center">
                    <span class="text-muted">Itinerary Section</span>
                    <button type="button" class="btn btn-sm btn-danger itinery-rem-button" onclick="removeItItem(this)" style="border-radius: 50%; width: 30px; height: 30px">X</button>
                </legend>
                <div class="form-group itinerary-item">
                    <label for="itinerary_title_${itineraryCount}" class="col-form-label">Itinerary Title <span class="text-danger">*</span></label>
                    <input id="itinerary_title_${itineraryCount}" type="text" name="itinerary_titles[]" class="form-control" required>
                    
                    <label for="itinerary_description_${itineraryCount}" class="col-form-label">Description <span class="text-danger">*</span></label>
                    <textarea id="itinerary_description_${itineraryCount}" name="itinerary_descriptions[]" class="form-control" required></textarea>
                </div>`;

                let newSec = document.createElement('fieldset');
                newSec.id = `new-${itineraryCount}-sec`;
                document.getElementById('itinerary-container').appendChild(newSec);

                setTimeout(() => {
                    $(`#new-${itineraryCount}-sec`).html(`${itineraryItem}`);

                    setTimeout(() => {
                        CKEDITOR.replace(document.getElementById(`itinerary_description_${itineraryCount}`));
                        setTimeout(() => {
                            jQuery('.cke_notifications_area').remove()
                        }, 1000);
                    }, 100);
                }, 100);
            });

        setTimeout(() => {
            jQuery('.cke_notifications_area').remove()
        }, 1000);
    });

    // Availability functionality
    function toggleAvailabilityFields() {
        const availabilityType = document.getElementById('availability_type').value;
        const periodsSection = document.getElementById('unavailable-periods-section');
        
        if (availabilityType === 'seasonal' || availabilityType === 'custom') {
            periodsSection.style.display = 'block';
        } else {
            periodsSection.style.display = 'none';
        }
    }

    function removePeriod(button) {
        if (document.querySelectorAll('.unavailable-period-item').length > 1) {
            button.closest('.unavailable-period-item').remove();
            updatePeriodIndices();
        }
    }

    function updatePeriodIndices() {
        const periods = document.querySelectorAll('.unavailable-period-item');
        periods.forEach((period, index) => {
            const inputs = period.querySelectorAll('input');
            inputs[0].name = `unavailable_periods[${index}][start_date]`;
            inputs[1].name = `unavailable_periods[${index}][end_date]`;
            inputs[2].name = `unavailable_periods[${index}][reason]`;
        });
    }

    // Add period functionality
    document.getElementById('add-period').addEventListener('click', function() {
        const container = document.getElementById('unavailable-periods-container');
        const currentCount = container.children.length;
        
        const newPeriod = `
            <div class="unavailable-period-item" style="border: 1px solid #eee; padding: 10px; margin-bottom: 10px; border-radius: 3px;">
                <div class="row">
                    <div class="col-md-4">
                        <label>Start Date</label>
                        <input type="date" name="unavailable_periods[${currentCount}][start_date]" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <label>End Date</label>
                        <input type="date" name="unavailable_periods[${currentCount}][end_date]" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label>Reason (Optional)</label>
                        <input type="text" name="unavailable_periods[${currentCount}][reason]" class="form-control" placeholder="e.g., Heavy rains">
                    </div>
                    <div class="col-md-1">
                        <label>&nbsp;</label>
                        <button type="button" class="btn btn-danger btn-sm form-control" onclick="removePeriod(this)">×</button>
                    </div>
                </div>
            </div>
        `;
        
        container.insertAdjacentHTML('beforeend', newPeriod);
    });

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        toggleAvailabilityFields();
    });
</script>
@endpush
