@extends('backend.layouts.master')
@section('title')
    Page Banners - {{ config('app.name') }}
@endsection
@section('main-content')

<div class="card">
    <div class="card-header">
    <h5 >Page Banners</h5>
        <a href="{{ route('page-banner.create') }}" class="btn btn-success pull-right">
            <i class="fa fa-plus"></i> Add New Page Banner
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
        
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Page Name</th>
                        <th>Banner Image</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($pageBanners as $banner)
                        <tr>
                            <td>{{ $banner->id }}</td>
                            <td><code>{{ $banner->page_slug }}</code></td>
                            <td>
                                @if($banner->banner_image)
                                    <img src="{{ Storage::url($banner->banner_image) }}" alt="{{ $banner->page_slug }}" style="max-width: 100px; height: 50px; object-fit: cover;">
                                @else
                                    <span class="text-muted">No image</span>
                                @endif
                            </td>
                            <td>
                                @if($banner->status)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('page-banner.edit', $banner->id) }}" class="btn btn-primary btn-sm">
                                    <i class="fa fa-edit"></i> Edit
                                </a>
                                <form method="POST" action="{{ route('page-banner.destroy', $banner->id) }}" style="display: inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this page banner?')">
                                        <i class="fa fa-trash"></i> Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center">No page banners found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-between align-items-center mt-3">
            
            <div>
                {{ $pageBanners->links() }}
            </div>
        </div>
    </div>
</div>

@endsection
