@extends('backend.layouts.master')
@section('title')
    Edit Page Banner - {{ config('app.name') }}
@endsection
@section('main-content')

<div class="card">
    <h5 class="card-header">Edit Page Banner</h5>
    <div class="card-body">
        <form method="post" action="{{ route('page-banner.update', $pageBanner->id) }}" enctype="multipart/form-data">
            @csrf
            @method('PATCH')
            

            <div class="form-group">
                <label for="page_slug" class="col-form-label">Page Name <span class="text-danger">*</span></label>
                <select name="page_slug" class="form-control">
                    <option value="about-us" {{ $pageBanner->page_slug == 'about-us' ? 'selected' : '' }}>About Us</option>
                    <option value="contact" {{ $pageBanner->page_slug == 'contact' ? 'selected' : '' }}>Contact</option>
                    <option value="blog" {{ $pageBanner->page_slug == 'blog' ? 'selected' : '' }}>Updates</option>
                    <option value="blog-detail" {{ $pageBanner->page_slug == 'blog-detail' ? 'selected' : '' }}>Updates Detail</option>
                    <option value="faq" {{ $pageBanner->page_slug == 'faq' ? 'selected' : '' }}>FAQ</option>
                    <option value="document" {{ $pageBanner->page_slug == 'document' ? 'selected' : '' }}>Document</option>
                    <option value="search" {{ $pageBanner->page_slug == 'search' ? 'selected' : '' }}>Search</option>
                    <option value="book" {{ $pageBanner->page_slug == 'book' ? 'selected' : '' }}>Book</option>
                </select>
                {{-- <input id="page_slug" type="text" name="page_slug" placeholder="Enter page slug (e.g., about-us, contact, blog)" value="{{ $pageBanner->page_slug }}" class="form-control"> --}}
                {{-- <small class="text-muted">This should match the page route slug. Examples: about-us, contact, blog, faq, book, etc.</small> --}}
                @error('page_slug')
                <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="banner_image" class="col-form-label">Banner Image</label>
                <div class="input-group">
                    <span class="input-group-btn">
                        <a id="lfm" data-input="banner_image" data-preview="holder" class="btn btn-primary">
                            <i class="fa fa-picture-o"></i> Choose
                        </a>
                    </span>
                    <input id="banner_image" class="form-control" type="file" name="banner_image" value="{{ $pageBanner->banner_image }}">
                </div>
                <div id="holder" style="margin-top:15px;max-height:100px;">
                    @if($pageBanner->banner_image)
                        <img src="{{ Storage::url($pageBanner->banner_image) }}" style="height:100px;">
                    @endif
                </div>
                @error('banner_image')
                <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
                <select name="status" class="form-control">
                    <option value="1" {{ $pageBanner->status == 1 ? 'selected' : '' }}>Active</option>
                    <option value="0" {{ $pageBanner->status == 0 ? 'selected' : '' }}>Inactive</option>
                </select>
                @error('status')
                <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group mb-3">
                <button type="reset" class="btn btn-warning">Reset</button>
                <button class="btn btn-success" type="submit">Update</button>
            </div>
        </form>
    </div>
</div>

@endsection

@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script>
    $('#lfm').filemanager('image');
</script>
@endpush
