@extends('backend.layouts.master')
@section('title')
    Create Page Banner - {{ config('app.name') }}
@endsection
@section('main-content')

<div class="card">
    <h5 class="card-header">Create Page Banner</h5>
    <div class="card-body">
        <form method="post" action="{{ route('page-banner.store') }}" enctype="multipart/form-data">
            {{ csrf_field() }}
            
           

            <div class="form-group">
                <label for="page_slug" class="col-form-label">Page Name <span class="text-danger">*</span></label>
                <select name="page_slug" class="form-control">
                    <option value="about-us">About Us</option>
                    <option value="contact">Contact</option>
                    <option value="blog">Updates</option>
                    <option value="blog-detail">Updates Detail</option>
                    <option value="faq">FAQ</option>
                    <option value="document">Document</option>
                    <option value="search">Search</option>
                    <option value="book">Book</option>
                </select>
                {{-- <input id="page_slug" type="text" name="page_slug" placeholder="Enter page slug (e.g., about-us, contact, blog)" value="{{ old('page_slug') }}" class="form-control"> --}}
                {{-- <small class="text-muted">This should match the page route slug. Examples: about-us, contact, blog, faq, book, etc.</small> --}}
                @error('page_slug')
                <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="banner_image" class="col-form-label">Banner Image <span class="text-danger">*</span></label>
                <div class="input-group">
                    <span class="input-group-btn">
                        <a id="lfm" data-input="banner_image" data-preview="holder" class="btn btn-primary">
                            <i class="fa fa-picture-o"></i> Choose
                        </a>
                    </span>
                    <input id="banner_image" class="form-control" type="file" name="banner_image" value="{{ old('banner_image') }}">
                </div>
                <div id="holder" style="margin-top:15px;max-height:100px;"></div>
                @error('banner_image')
                <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
                <select name="status" class="form-control">
                    <option value="1" {{ old('status') == 1 ? 'selected' : '' }}>Active</option>
                    <option value="0" {{ old('status') == 0 ? 'selected' : '' }}>Inactive</option>
                </select>
                @error('status')
                <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group mb-3">
                <button type="reset" class="btn btn-warning">Reset</button>
                <button class="btn btn-success" type="submit">Submit</button>
            </div>
        </form>
    </div>
</div>

@endsection

@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script>
    $('#lfm').filemanager('image');
</script>
@endpush
