@extends('backend.layouts.master')

@section('title') Show Booking @endsection

@section('main-content')
<div class="card">
<h5 class="card-header">Booking
  {{-- <a href="{{ route('order.pdf', $order->id) }}" class="btn btn-sm btn-primary shadow-sm float-right">
    <i class="fas fa-download fa-sm text-white-50"></i> Generate PDF
  </a> --}}
  </h5>
  <div class="card-body">
    @if($order)
    @php 
      $tour=DB::table('tours')->select('title')->where('id',$order->tour_id)->get();
    @endphp
    <table class="table table-striped table-hover">
      <thead>
        <tr>
            <th>S.N.</th>
            <th>Name</th>
            <th>Email</th>
            <th>Tour</th>
            <th>Date Created</th>
            <th>Action</th>
        </tr>
      </thead>
      <tbody>
        
        <tr>
            <td>{{$order->id}}</td>
            <td>{{$order->first_name}} - {{$order->first_name}}</td>
            <td>{{$order->email}}</td>
            <td>
              @foreach($tour as $data)
                {{$order->tour->title ?? ''}}
              @endforeach
            </td>
            <td>{{$order->created_at->format('F d, Y h:i A')}}</td>
            <td>
                <form method="POST" action="{{route('order.destroy',[$order->id])}}">
                  @csrf
                  @method('delete')
                      <button class="btn btn-danger btn-sm dltBtn" data-id={{$order->id}} style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                </form>
            </td>

        </tr>
      </tbody>
    </table>

    <section class="confirmation_part section_padding">
      <div class="order_boxes">
        <div class="row">
          <div class="col-lg-6 col-lx-4">
            <div class="order-info">
              <h4 class="text-center pb-4">Booking Information</h4>
              <table class="table">
                    <tr>
                        <td>Booking Date:</td>
                        <td>{{$order->created_at->format('D d M, Y')}} at {{$order->created_at->format('g : i a')}} </td>
                    </tr>
                    <tr>
                      <td>Phone:</td> 
                      <td>{{ $order->phone }}</td>
                    </tr>
                    <tr>
                      <td>Email:</td> 
                      <td>{{ $order->email }}</td>
                    </tr>
                    <tr>
                      <td>Country: </td>
                      <td>{{$order->country}}</td>
                    </tr>
                    <tr>
                      <td>Language: </td>
                      <td>{{ $order->language }} </td>
                    </tr>
                    <tr>
                        <td>Number of Adults: </td>
                        <td>{{ $order->number_adult }} </td>
                    </tr>
                    <tr>
                        <td>Number of Children: </td>
                        <td>{{ $order->number_child }} </td>
                    </tr>
                    <tr>
                        <td>Age of Children: </td>
                       <td> {{ $order->age_child }} </td>
                    </tr>
                    <tr>
                        <td>Date of Arrival: </td>
                        <td>{{ $order->date_arrival }} </td>
                    </tr>
                    <tr>
                        <td>Total Number Of Stay: </td>
                        <td>{{ $order->total_stay }} </td>
                    </tr>
                    <tr>
                        <td>What do you want to experience: </td>
                        <td>{{ $order->experience }} </td>
                    </tr>
                    <tr>
                        <td>Type of Accomodation: </td>
                        <td>{{ $order->accomodation }} </td>
                    </tr>
                    <tr>
                        <td>How Much Is Your Budget: </td>
                        <td>{{ $order->budget }} </td>
                    </tr>
                    <tr>
                        <td>Things Which You Like Most: </td>
                        <td>{{ $order->like_most }} </td>
                    </tr>
                    <tr>
                        <td>Things Which You Dislike: </td>
                        <td>{{ $order->dislike_most }} </td>
                    </tr>
                    <tr>
                        <td>Brief Description About You: </td>
                        <td>{{ $order->brief_descript }} </td>
                    </tr>
              </table>
            </div>
          </div>
        </div>
      </div>
    </section>
    @endif

  </div>
</div>
@endsection
