<button class="btn btn-secondary dropdown-toggle" type="button" id="message" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
  <i class="fa fa-envelope"></i>
  @if(count(Helper::messageList())>5)
      <span data-count="5" class="count bg-primary">5+</span>
  @else 
    <span data-count="{{count(Helper::messageList())}}" class="count bg-primary">{{count(Helper::messageList())}}</span>
  @endif
</button>
<div class="dropdown-menu" aria-labelledby="message">
  <p class="red">Message Center</p>
  @foreach(Helper::messageList() as $message)
    <a class="dropdown-item media" href="{{route('message.show',$message->id)}}">
        {{-- <span class="photo media-left">
          @if($message->photo)
            <img src="{{$message->photo}}" alt="profile">
          @else 
            <img  src="{{asset('backend/images/avatar/1.jpg')}}" alt="default img">
          @endif
        </span> --}}
        <div class="message media-body">
            <span class="name float-left">{{$message->name}}</span>
            <span class="time float-right">{{$message->created_at->diffForHumans()}}</span>
            <p>{{$message->subject}}</p>
        </div>
    </a>
    @if($loop->index+1==5) 
          @php 
            break;
          @endphp
        @endif
    @endforeach

    <a class="dropdown-item text-center small text-gray-500" href="{{route('message.index')}}">Read More Messages</a>

</div>

@push('scripts')
<script type="text/javascript">
  $(document).ready(function() {

    Echo.channel('message')
      .listen('MessageSent', (e) => {

      const message_container = $('#message-items');
      const message_counter_area = $('#messages .count');
      const message_counter = parseInt( $(message_counter_area).attr('data-count') ) + 1;
      const message_length = parseInt( $('#message-items>.dropdown-item').length );
      $(message_counter_area).attr('data-count', message_counter);

      const data = `
      <a class="dropdown-item d-flex align-items-center message-item" href="${e.message.url}">
        <div class="dropdown-list-image mr-3">
          <img class="rounded-circle" src="${e.message.photo}" alt="${e.message.name}">
        </div>
        <div class="font-weight-bold">
          <div class="text-truncate">${e.message.subject}</div>
          <div class="small text-gray-500">${e.message.name} · ${e.message.date}</div>
        </div>
      </a>
      `;

      $(message_container).prepend(data);

      if(message_counter<=5){
        $(message_counter_area).text( message_counter );
      }else{ 
        $(message_counter_area).text('5+');
      };

      if(message_length>=5) $(message_container).find('.message-item').last().remove();

    });

  });
</script>
@endpush
