@extends('backend.layouts.master')
@section('title','All Messages')
@section('main-content')

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Messages</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="{{ route('admin')}}">Dashboard</a></li>
                <li><a href="{{ route('admin')}}">Dashboard</a></li>
                <li class="active">Message</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Messages</strong>
                  </div>
                  <div class="card-body">
                    @if(count($messages)>0)
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Subject</th>
                                <th>Date</th>
                              </tr>
                          </thead>
                          <tbody>
                            @foreach ( $messages as $message)

                              <tr class="@if($message->read_at) border-left-success @else bg-light border-left-warning @endif">
                                <td>{{$loop->index +1}}</td>
                                <td>{{$message->name}} {{$message->read_at}}</td>
                                <td>{{$message->subject}}</td>
                                <td>{{$message->created_at->format('F d, Y h:i A')}}</td>
                                <td>
                                  <a href="{{route('message.show',$message->id)}}" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="view" data-placement="bottom"><i class="fa fa-eye"></i></a>
                                  <button class="btn btn-danger btn-sm dltBtn" data-toggle="modal" data-target="#modal-delete{{$message->id}}" data-id={{$message->id}} style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                  <div class="modal fade"  id="modal-delete{{$message->id}}" tabindex="-1" aria-labelledby="modal-new-address" aria-hidden="true">
                                      <div class="modal-dialog  modal-dialog-centered">
                                          <div class="modal-content">
                                              <div class="modal-header">
                                                  <h6 class="modal-title" id="staticBackdropLabel">
                                                  </h6>
                                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">×</span>
                                                  </button>
                                                  
                                              </div>
                                              <div class="modal-body">
                                                  <form action="{{route('message.destroy',$message->id)}}" method="post">
                                                      @csrf
                                                      @method('DELETE')
                                                  <div class="row gy-3">
                                                      <div class="col-xl-6">
                                                          <H2>Are you Sure ?</H2>
                                                          <p>You won't be able to revert this!</p> 
                                                      </div>                                       
                                                  </div>
                                              
                                              </div>
                                              <div class="modal-footer">
                                                  <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                                                  <button type="submit" class="btn btn-danger">Yes, Delete It</button>
                                              </div>
                                          </form>
                                          
                                          </div>
                                      </div>
                                  </div>
                                </td>
                              </tr>
                              @endforeach
                          </tbody>
                      </table>
                      @else
                      <h6 class="text-center">No messages found!!! </h6>
                    @endif
                  </div>
              </div>
          </div>


      </div>
  </div><!-- .animated -->
</div><!-- .content -->

@endsection
