@extends('backend.layouts.master')
@section('title') Location Categories @endsection
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Location Categories</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="{{ route('admin')}}">Dashboard</a></li>
                <li><a href="{{ route('location-category.create')}}">Add Location Category</a></li>
                <li class="active">Location Categories</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Location Categories</strong>
                  </div>
                  <div class="card-body">
                    @if(count($location_categories)>0)
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th>S.N.</th>
                                <th>Title</th>
                                <th>Slug</th>
                                <th>Photo</th>
                                <th>Status</th>
                                <th>Action</th>
                              </tr>
                          </thead>
                          <tbody>
                            @foreach($location_categories as $data) 
                              <tr>
                                  <td>{{$data->id}}</td>
                                  <td>{{$data->title}}</td>
                                  <td>{{$data->slug}}</td>
                                  <td>
                                    @if($data->photo)
                                        <img src="{{ Storage::url($data->photo) }}" class="img-fluid zoom" style="max-width:80px" alt="{{$data->photo}}">
                                    @else
                                        <img src="{{asset('backend/img/thumbnail-default.jpg')}}" class="img-fluid zoom" style="max-width:100%" alt="avatar.png">
                                    @endif
                                  </td>
                                  <td>
                                      @if($data->status=='active')
                                          <span class="badge badge-success">{{$data->status}}</span>
                                      @else
                                          <span class="badge badge-warning">{{$data->status}}</span>
                                      @endif
                                  </td>
                                  <td>
                                      <a href="{{route('location-category.edit',$data->id)}}" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fa fa-edit"></i></a>
                                      <form method="POST" action="{{route('location-category.destroy',[$data->id])}}">
                                        @csrf 
                                        @method('delete')
                                            <button class="btn btn-danger btn-sm dltBtn" data-id={{$data->id}} style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                        </form>
                                  </td>
                                  
                              </tr>  
                            @endforeach
                          </tbody>
                      </table>
                      <span style="float:right">{{$location_categories->links()}}</span>
                      @else
                        <h6 class="text-center">No Location Categories found!!! Please create Location Category</h6>
                      @endif
                  </div>
              </div>
          </div>

      </div>
  </div><!-- .animated -->
</div><!-- .content -->

@endsection

@push('styles')
  <link rel="stylesheet" href="{{asset('backend/assets/css/lib/datatable/dataTables.bootstrap.min.css')}}">
  <link href="{{asset('backend/assets/css/lib/datatable/buttons.bootstrap.min.css')}}" rel="stylesheet">
  <link rel="stylesheet" href="{{asset('backend/assets/css/lib/datatable/fixedHeader.dataTables.min.css')}}">
  <link rel="stylesheet" href="{{asset('backend/assets/css/lib/datatable/scroller.dataTables.min.css')}}">
  <style>
      div.dataTables_wrapper div.dataTables_paginate{
          display: none;
      }
      .zoom {
        transition: transform .2s; /* Animation */
      }

      .zoom:hover {
        transform: scale(3.2);
      }
  </style>
@endpush

@push('scripts')

  <!-- data table JS
		============================================ -->
    <script src="{{asset('backend/assets/js/lib/datatable/datatables.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/dataTables.bootstrap.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/buttons.bootstrap.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/jszip.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/pdfmake.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/vfs_fonts.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/buttons.html5.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/buttons.print.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/buttons.colVis.min.js')}}"></script>
    <script src="{{asset('backend/assets/js/lib/datatable/datatables-init.js')}}"></script>


    <script>
        $(document).ready(function(){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $('.dltBtn').click(function(e){
                var form=$(this).closest('form');
                  var dataID=$(this).data('id');
                  // alert(dataID);
                  e.preventDefault();
                  swal({
                        title: "Are you sure?",
                        text: "Once deleted, you will not be able to recover this data!",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                           form.submit();
                        } else {
                            swal("Your data is safe!");
                        }
                    });
            })
        })
    </script>
@endpush
