@extends('backend.layouts.master')

@section('title')
Location Category Edit
@endsection

@section('main-content')

<div class="card">
    <h5 class="card-header">Edit Location Category</h5>
    <div class="card-body">
      <form method="post" action="{{route('location-category.update',$location_category->id)}}" enctype="multipart/form-data">
        @csrf 
        @method('PUT')
        <div class="form-group">
          <label for="inputTitle" class="col-form-label">Title <span class="text-danger">*</span></label>
          <input id="inputTitle" type="text" name="title" placeholder="Enter title"  value="{{$location_category->title}}" class="form-control">
          @error('title')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>

        {{-- <div class="form-group">
          <label for="description" class="col-form-label">Description</label>
          <textarea class="form-control" id="description" name="description">{{$location_category->description}}</textarea>
          @error('description')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div> --}}

        <div class="form-group">
          <label for="inputPhoto" class="col-form-label">Photo (Size: 370 x 431)</label>
          <div class="input-group">
            <span class="input-group-btn">
              <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary">
                <i class="fa fa-picture-o"></i> Choose
              </a>
            </span>
            <input id="thumbnail" class="form-control" type="file" name="photo" value="{{$location_category->photo}}">
          </div>
          <div id="holder" style="margin-top:15px;max-height:100px;">
            @if($location_category->photo)
                <img src="{{ Storage::url($location_category->photo) }}" style="height:100px;">
            @endif
          </div>
          @error('photo')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>

        <div class="form-group">
          <label for="inputBanner" class="col-form-label">Top Banner <small class="text-muted">(Recommended: 1920 x 550px)</small></label>
          <div class="input-group">
            <span class="input-group-btn">
              <a id="lfm-banner" data-input="banner" data-preview="banner-holder" class="btn btn-primary">
                <i class="fa fa-picture-o"></i> Choose
              </a>
            </span>
            <input id="banner" class="form-control" type="file" name="banner" value="{{$location_category->banner}}">
          </div>
          <div id="banner-holder" style="margin-top:15px;max-height:100px;">
            @if($location_category->banner)
                <img src="{{ Storage::url($location_category->banner) }}" style="height:100px;">
            @endif
          </div>
          @error('banner')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>
        
        <div class="form-group">
          <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
          <select name="status" class="form-control">
            <option value="active" {{(($location_category->status=='active') ? 'selected' : '')}}>Active</option>
            <option value="inactive" {{(($location_category->status=='inactive') ? 'selected' : '')}}>Inactive</option>
          </select>
          @error('status')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>
        <div class="form-group mb-3">
           <button class="btn btn-success" type="submit">Update</button>
        </div>
      </form>
    </div>
</div>

@endsection

@push('styles')
<link rel="stylesheet" href="{{asset('backend/summernote/summernote.min.css')}}">
@endpush
@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script src="{{asset('backend/summernote/summernote.min.js')}}"></script>
<script>
    $('#lfm').filemanager('image');
    $('#lfm-banner').filemanager('image');

    $(document).ready(function() {
    $('#description').summernote({
      placeholder: "Write short description.....",
        tabsize: 2,
        height: 150
    });
    });
</script>
@endpush
