@extends('backend.layouts.master')
@section('title') Edit FAQ @endsection
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
  <div class="breadcrumbs-inner">
      <div class="row m-0">
          <div class="col-sm-4">
              <div class="page-header float-left">
                  <div class="page-title">
                      <h1>Edit</h1>
                  </div>
              </div>
          </div>
          <div class="col-sm-8">
              <div class="page-header float-right">
                  <div class="page-title">
                      <ol class="breadcrumb text-right">
                          <li><a href="{{ route('admin')}}">Dashboard</a></li>
                          <li><a href="{{ route('faq.index') }}">FAQ</a></li>
                          <li class="active">Edit</li>
                      </ol>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>

<div class="content">
  <div class="animated fadeIn">
    <div class="row">
      <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <strong>Edit</strong>
            </div>
            <div class="card-body card-block">
              <form method="post" action="{{route('faq.update',$faq->id)}}" enctype="multipart/form-data">
                @csrf 
                @method('PATCH')
                <div class="form-group">
                    <label for="inputTitle" class="col-form-label"> Question <span class="text-danger">*</span></label>
                    <input id="inputTitle" type="text" name="title" placeholder=""  value="{{$faq->title}}" class="form-control" required>
                    @error('title')
                    <span class="text-danger">{{$message}}</span>
                    @enderror
                </div>

                <div class="form-group">
                  <label for="comment" class="col-form-label">Answer</label>
                  <textarea class="form-control ckeditor" id="description" name="description"  required>{{$faq->description}}</textarea>
                  @error('description')
                  <span class="text-danger">{{$message}}</span>
                  @enderror
                </div>
                
                <div class="form-group">
                  <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
                  <select name="status" class="form-control" required>
                    <option value="active" {{(($faq->status=='active') ? 'selected' : '')}}>Active</option>
                    <option value="inactive" {{(($faq->status=='inactive') ? 'selected' : '')}}>Inactive</option>
                  </select>
                  @error('status')
                  <span class="text-danger">{{$message}}</span>
                  @enderror
                </div>
                <div class="form-group mb-3">
                  <button class="btn btn-success" type="submit">Update</button>
                </div>
              </form>
            </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@push('scripts')

<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
    });
</script>

@endpush