@extends('backend.layouts.master')
@section('title') Add Exclude @endsection
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
  <div class="breadcrumbs-inner">
      <div class="row m-0">
          <div class="col-sm-4">
              <div class="page-header float-left">
                  <div class="page-title">
                      <h1>Add Exclude</h1>
                  </div>
              </div>
          </div>
          <div class="col-sm-8">
              <div class="page-header float-right">
                  <div class="page-title">
                      <ol class="breadcrumb text-right">
                          <li><a href="{{ route('admin')}}">Dashboard</a></li>
                          <li><a href="{{ route('exclude-tour.index') }}">View Excludes</a></li>
                          <li class="active">Add Exclude</li>
                      </ol>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>

<div class="content">
  <div class="animated fadeIn">
    <div class="row">
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
              <strong>Add Exclude</strong>
          </div>
          <div class="card-body card-block">
            <form method="post" action="{{route('exclude-tour.store')}}">
              {{csrf_field()}}
              <div class="form-group">
                <label for="inputTitle" class="col-form-label">{{ __('sidebar.post_title') }}</label>
                <input id="inputTitle" type="text" name="title" placeholder=""  value="{{old('title')}}" class="form-control" required>
                @error('title')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>

              <div class="form-group">
                <label for="status" class="col-form-label">{{ __('sidebar.post_status') }}</label>
                <select name="status" class="form-control">
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                </select>
                @error('status')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>
              <div class="form-group mb-3">
                <button type="reset" class="btn btn-warning">{{ __('sidebar.post_reset') }}</button>
                <button class="btn btn-success" type="submit">{{ __('sidebar.post_submit') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
