@extends('backend.layouts.master')
@section('title','Add Document')
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
    <div class="breadcrumbs-inner">
        <div class="row m-0">
            <div class="col-sm-4">
                <div class="page-header float-left">
                    <div class="page-title">
                        <h1>Add Document</h1>
                    </div>
                </div>
            </div>
            <div class="col-sm-8">
                <div class="page-header float-right">
                    <div class="page-title">
                        <ol class="breadcrumb text-right">
                            <li><a href="{{ route('admin')}}">Dashboard</a></li>
                            <li><a href="{{ route('document.index') }}">Documents</a></li>
                            <li class="active">Add Document</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
  </div>
  
<div class="content">
    <div class="animated fadeIn">
        <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <strong>Create Document</strong>
                    </div>
                    <div class="card-body card-block">
                        <form method="post" action="{{route('document.store')}}" enctype="multipart/form-data">
                        {{csrf_field()}}
                        <div class="form-group">
                            <label for="inputTitle" class="col-form-label">Document Title</label>
                            <input id="inputTitle" type="text" name="title" placeholder=""  value="{{old('title')}}" class="form-control" required>
                            @error('title')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="inputPhoto" class="col-form-label">Upload Image  ( Size: 851px x 490px) <span class="text-danger">*</span></label>
                            <div class="input-group">
                                {{-- <span class="input-group-btn">
                                    <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                              <input id="thumbnail" class="form-control" type="text" name="photo" value="{{old('photo')}}"> --}}
                              <input class="form-control" type="file" name="photo" required>
                            </div>
                            <div id="holder" style="margin-top:15px;max-height:100px;"></div>
                              @error('photo')
                              <span class="text-danger">{{$message}}</span>
                              @enderror
                            </div>

                            <div class="form-group">
                                <label for="file-input" class="col-form-label">Attach File upload <span class="text-danger">*</span></label>
                                <input type="file" id="file-input" name="file" class="form-control-file" required>
                                @error('file')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                        <div class="form-group">
                            <label for="status" class="col-form-label">{{ __('sidebar.bann_status') }} <span class="text-danger">*</span></label>
                            <select name="status" class="form-control" required>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                            @error('status')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                          </div>

                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary btn-sm">
                                <i class="fa fa-dot-circle-o"></i> Submit
                            </button>
                            <button type="reset" class="btn btn-danger btn-sm">
                                <i class="fa fa-ban"></i> Reset
                            </button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('styles')
<link rel="stylesheet" href="{{asset('backend/summernote/summernote.min.css')}}">
@endpush
@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script src="{{asset('backend/summernote/summernote.min.js')}}"></script>
<script>
    $('#lfm').filemanager('image');

    $(document).ready(function() {
    $('#description').summernote({
      placeholder: "Write short description.....",
        tabsize: 2,
        height: 150
    });
    });
</script>
@endpush