@extends('backend.layouts.master')
@section('title') Destinations @endsection
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
  <div class="col-sm-4">
      <div class="page-header float-left">
          <div class="page-title">
              <h1>Destinations</h1>
          </div>
      </div>
  </div>
  <div class="col-sm-8">
      <div class="page-header float-right">
          <div class="page-title">
              <ol class="breadcrumb text-right">
                <li><a href="{{ route('admin')}}">Dashboard</a></li>
                <li><a href="{{ route('destination.create')}}">Add Destination</a></li>
                <li class="active">Destinations</li>
              </ol>
          </div>
      </div>
  </div>
</div>

<div class="content mt-3">
  <div class="animated fadeIn">
      <div class="row">

          <div class="col-md-12">
              <div class="card">
                  <div class="card-header">
                      <strong class="card-title">Destination</strong>
                  </div>
                  <div class="card-body">
                    @if(count($destinations)>0)
                      <table id="bootstrap-data-table-export" class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                <th>{{ __('sidebar.post_snumber') }}</th>
                                <th>{{ __('sidebar.post_title') }}</th>
                                <th>Country</th>
                                {{-- <th>{{ __('sidebar.post_tag') }}</th> --}}
                                <th>{{ __('sidebar.post_photo') }}</th>
                                <th>{{ __('sidebar.post_status') }}</th>
                                <th>{{ __('sidebar.post_action') }}</th>
                              </tr>
                          </thead>
                          <tbody>
                            @php
                            $i =1;
                            @endphp
                            @foreach($destinations as $destination)   
                              @php 
                              $author_info=DB::table('users')->select('name')->where('id',$destination->added_by)->get();
                              @endphp
                              <tr>
                                <td>{{$i++}}</td>
                                <td>{{$destination->title}}</td>
                                <td>{{$destination->country}}</td>
                                {{-- <td>{{$destination->tags}}</td> --}}
                                <td>
                                    @if($destination->photo)
                                        <img src="{{ Storage::url($destination->photo) }}" class="img-fluid zoom" style="max-width:80px" alt="{{ Storage::url($destination->photo) }}">
                                    @else
                                        <img src="{{asset('backend/img/thumbnail-default.jpg')}}" class="img-fluid" style="max-width:80px" alt="avatar.png">
                                    @endif
                                </td>                   
                                <td>
                                    @if($destination->status=='active')
                                        <span class="badge badge-success">{{$destination->status}}</span>
                                    @else
                                        <span class="badge badge-warning">{{$destination->status}}</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{route('destination.edit',$destination->id)}}" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fa fa-edit"></i></a>
                                    <button class="btn btn-danger btn-sm dltBtn" data-toggle="modal" data-target="#modal-delete{{$destination->id}}" data-id={{$destination->id}} style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fa fa-trash"></i></button>
                                    <div class="modal fade"  id="modal-delete{{$destination->id}}" tabindex="-1" aria-labelledby="modal-new-address" aria-hidden="true">
                                        <div class="modal-dialog  modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h6 class="modal-title" id="staticBackdropLabel">
                                                    </h6>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                      <span aria-hidden="true">×</span>
                                                    </button>
                                                    
                                                </div>
                                                <div class="modal-body">
                                                    <form action="{{route('destination.destroy',$destination->id)}}" method="post">
                                                        @csrf
                                                        @method('DELETE')
                                                    <div class="row gy-3">
                                                        <div class="col-xl-6">
                                                            <H2>Are you Sure ?</H2>
                                                            <p>You won't be able to revert this!</p> 
                                                        </div>                                       
                                                    </div>
                                                
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger">Yes, Delete It</button>
                                                </div>
                                            </form>
                                            
                                            </div>
                                        </div>
                                    </div>
                                </td>
                              </tr>
                              @endforeach
                          </tbody>
                      </table>
                      @else
                      <h6 class="text-center">No destinations found!!! Please add destination</h6>
                    @endif
                  </div>
              </div>
          </div>


      </div>
  </div><!-- .animated -->
</div><!-- .content -->

@endsection
