@extends('backend.layouts.master')
@section('title') Edit Category @endsection
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
  <div class="breadcrumbs-inner">
      <div class="row m-0">
          <div class="col-sm-4">
              <div class="page-header float-left">
                  <div class="page-title">
                      <h1>Edit Category</h1>
                  </div>
              </div>
          </div>
          <div class="col-sm-8">
              <div class="page-header float-right">
                  <div class="page-title">
                      <ol class="breadcrumb text-right">
                          <li><a href="{{ route('admin')}}">Dashboard</a></li>
                          <li><a href="{{ route('category.index') }}">View Category</a></li>
                          <li class="active">Edit Category</li>
                      </ol>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>

<div class="content">
  <div class="animated fadeIn">
    <div class="row">
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
              <strong>Edit Category</strong>
          </div>
          <div class="card-body card-block">
            <form method="post" action="{{route('category.update',$category->id)}}" enctype="multipart/form-data">
              @csrf 
              @method('PATCH')
              <div class="form-group">
                <label for="inputTitle" class="col-form-label">Title</label>
                <input id="inputTitle" type="text" name="title" placeholder=""  value="{{$category->title}}" class="form-control" required>
                @error('title')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>

              <div class="form-group">
                <label for="inputPhoto" class="col-form-label">Upload Icon</label>
                <div class="input-group">
                  <input class="form-control" type="file" name="icon" value="{{$category->icon}}">
                </div>
              <div id="holder" style="margin-top:15px;max-height:100px;"></div>

                @error('icon')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>

              <div class="form-group">
                <img src="{{ Storage::url($category->icon) }}" height="75" width="75" alt="" />
              </div>

              <div class="form-group">
                <label for="status" class="col-form-label">Status</label>
                <select name="status" class="form-control">
                  <option value="active" {{(($category->status=='active') ? 'selected' : '')}}>Active</option>
                  <option value="inactive" {{(($category->status=='inactive') ? 'selected' : '')}}>Inactive</option>
                </select>
                @error('status')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>
              <div class="form-group mb-3">
                <button class="btn btn-success" type="submit">Update</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
