@extends('backend.layouts.master')
@section('title') Category @endsection
@section('main-content')
@include('backend.layouts.notification')

<div class="breadcrumbs">
  <div class="breadcrumbs-inner">
      <div class="row m-0">
          <div class="col-sm-4">
              <div class="page-header float-left">
                  <div class="page-title">
                      <h1>Category</h1>
                  </div>
              </div>
          </div>
          <div class="col-sm-8">
              <div class="page-header float-right">
                  <div class="page-title">
                      <ol class="breadcrumb text-right">
                          <li><a href="{{ route('admin')}}">Dashboard</a></li>
                          <li><a href="{{ route('category.index') }}">View Category</a></li>
                          <li class="active">Category</li>
                      </ol>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>

<div class="content">
  <div class="animated fadeIn">
    <div class="row">
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
              <strong>Category</strong>
          </div>
          <div class="card-body card-block">
            <form method="post" action="{{route('category.store')}}" enctype="multipart/form-data">
              {{csrf_field()}}
              <div class="form-group">
                <label for="inputTitle" class="col-form-label">{{ __('sidebar.post_title') }}</label>
                <input id="inputTitle" type="text" name="title" placeholder=""  value="{{old('title')}}" class="form-control" required>
                @error('title')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>

              <div class="form-group">
                <label for="inputPhoto" class="col-form-label">Upload Icon <span class="text-danger">*</span></label>
                <div class="input-group">
                  <input class="form-control" type="file" name="icon" required>
                </div>
              <div id="holder" style="margin-top:15px;max-height:100px;"></div>
                @error('icon')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>

              <div class="form-group">
                <label for="status" class="col-form-label">{{ __('sidebar.post_status') }}</label>
                <select name="status" class="form-control">
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                </select>
                @error('status')
                <span class="text-danger">{{$message}}</span>
                @enderror
              </div>
              <div class="form-group mb-3">
                <button type="reset" class="btn btn-warning">{{ __('sidebar.post_reset') }}</button>
                <button class="btn btn-success" type="submit">{{ __('sidebar.post_submit') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
