<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class VideosTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        // Define your seed data
        $videos = [
            [
                'title' => 'Introduction to Laravel',
                'slug' => 'introduction-to-laravel',
                'link' => 'https://example.com/laravel-intro',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Building RESTful APIs with Laravel',
                'slug' => 'restful-apis-with-laravel',
                'link' => 'https://example.com/laravel-apis',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Authentication in Laravel',
                'slug' => 'authentication-in-laravel',
                'link' => 'https://example.com/laravel-auth',
                'status' => 'inactive',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        // Insert the data
        DB::table('videos')->insert($videos);
    }
}
