<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ToursTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('tours')->insert([
            [
                'title' => 'Amazing Zanzibar Beach Tour',
                'slug' => Str::slug('Amazing Zanzibar Beach Tour'),
                'description' => 'Experience the best of Zanzibar beaches with this amazing tour package.',
                'photo' => 'zanzibar_beach.jpg',
                'tags' => 'beach,relaxation,adventure',
                'includes' => 'Accommodation, Meals, Transport',
                'excludes' => 'Flights, Personal Expenses',
                'tour_tag_id' => 1, // Adjust according to your actual data
                'include_tour_id' => 1, // Adjust according to your actual data
                'exclude_tour_id' => 1, // Adjust according to your actual data
                'added_by' => 1, // Adjust according to your actual data
                'location' => 'Zanzibar, Tanzania',
                'map' => 'https://maps.example.com/zanzibar',
                'age' => 'All Ages',
                'number_of_days' => 7,
                'images' => '["image1.jpg", "image2.jpg", "image3.jpg"]',
                'price' => 999.99,
                'price_per_child' => 200.99,
                'discount' => 100.00,
                'categories' => 'tanzania-mainland',
                'status' => 'active',
                'itinerary_titles' => '["Day 1: Arrival", "Day 2: Beach Activities", "Day 3: City Tour"]',
                'itinerary_descriptions' => '["Arrival at Zanzibar Airport", "Enjoy beach activities and relaxation", "Explore the city and local markets"]',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Safari and Beach Combo Tour',
                'slug' => Str::slug('Safari and Beach Combo Tour'),
                'description' => 'Combine the thrill of safari with the relaxation of the beach in this combo tour.',
                'photo' => 'safari_beach_combo.jpg',
                'tags' => 'safari,beach,adventure',
                'includes' => 'Accommodation, Meals, Safari Tours, Beach Activities',
                'excludes' => 'Flights, Personal Expenses',
                'tour_tag_id' => 2, // Adjust according to your actual data
                'include_tour_id' => 2, // Adjust according to your actual data
                'exclude_tour_id' => 2, // Adjust according to your actual data
                'added_by' => 1, // Adjust according to your actual data
                'location' => 'Serengeti and Zanzibar, Tanzania',
                'map' => 'https://maps.example.com/safari_beach_combo',
                'age' => 'All Ages',
                'number_of_days' => 10,
                'images' => '["safari1.jpg", "beach1.jpg", "combo.jpg"]',
                'price' => 1499.99,
                'price_per_child' => 300.99,
                'discount' => 200.00,
                'categories' => 'zanzibar',
                'status' => 'active',
                'itinerary_titles' => '["Day 1: Arrival", "Day 2: Safari Adventure", "Day 3: Beach Relaxation"]',
                'itinerary_descriptions' => '["Arrival at Serengeti", "Full day safari adventure", "Relax at Zanzibar beach"]',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}


