<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TourTagsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $tags = [
            ['title' => 'Adventure', 'slug' => Str::slug('Adventure')],
            ['title' => 'Historical', 'slug' => Str::slug('Historical')],
            ['title' => 'Nature', 'slug' => Str::slug('Nature')],
            ['title' => 'Cultural', 'slug' => Str::slug('Cultural')],
            ['title' => 'Family', 'slug' => Str::slug('Family')],
        ];

        foreach ($tags as $tag) {
            DB::table('tour_tags')->insert([
                'title' => $tag['title'],
                'slug' => $tag['slug'],
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
