<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TestimonialsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
         // Generate dummy data for testimonials
         $testimonials = [
            [
                'name' => 'John Doe',
                'position' => 'CEO',
                'message' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sit amet scelerisque orci, ut placerat felis. Pellentesque vehicula efficitur nulla a rutrum.',
                'slug' => Str::slug('John Doe'),
                'photo' => 'john_doe.jpg',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Jane Smith',
                'position' => 'Manager',
                'message' => 'Duis non augue ultricies, convallis magna et, semper elit. Proin nec dictum ligula. Nullam vel justo sed erat ultricies elementum vitae in ipsum.',
                'slug' => Str::slug('Jane Smith'),
                'photo' => 'jane_smith.jpg',
                'status' => 'inactive',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Add more testimonials as needed
        ];

        // Insert data into testimonials table
        DB::table('testimonials')->insert($testimonials);
    }
}
